#!/usr/bin/python

import os
import re

from distutils.core import setup

# look/set what version we have
changelog = "../debian/changelog"
if os.path.exists(changelog):
    head = open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

scripts = [
    'dh_xul-ext',
    'install-xpi',
    'xpi-pack',
    'xpi-repack',
    'xpi-unpack',
    'moz-version',
]

if __name__ == '__main__':
    setup(name='mozilla-devscripts',
          version=version,
          url='https://launchpad.net/mozilla-devscripts',
          scripts=scripts,
          py_modules=['moz_version'],
    )
