/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import viewer.legends.LegendTableModel;

public class OperationBooleanMenu
extends JPopupMenu {
    private static final long serialVersionUID = 2700L;
    private static String toggle_selected_icon_path = "/images/checkbox/ToggleSelected.gif";
    private static String enable_selected_icon_path = "/images/checkbox/EnableSelected.gif";
    private static String disable_selected_icon_path = "/images/checkbox/DisableSelected.gif";
    private static String toggle_all_icon_path = "/images/checkbox/ToggleAll.gif";
    private static String enable_all_icon_path = "/images/checkbox/EnableAll.gif";
    private static String disable_all_icon_path = "/images/checkbox/DisableAll.gif";
    private JTable table_view;
    private LegendTableModel table_model;
    private int bool_column;

    public OperationBooleanMenu(JTable jTable, int n) {
        this.table_view = jTable;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        this.bool_column = n;
        super.setLabel(this.table_model.getColumnName(this.bool_column));
        super.setToolTipText(this.table_model.getColumnToolTip(this.bool_column));
        this.addMenuItems();
    }

    private void addMenuItems() {
        URL uRL = null;
        uRL = this.getURL(toggle_selected_icon_path);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        JMenuItem jMenuItem = new JMenuItem("Toggle Selected", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationBooleanMenu.this.toggleSelectedAtColumn(OperationBooleanMenu.this.bool_column);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(enable_selected_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Enable Selected", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationBooleanMenu.this.setSelectedAtColumn(OperationBooleanMenu.this.bool_column, Boolean.TRUE);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(disable_selected_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Disable Selected", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationBooleanMenu.this.setSelectedAtColumn(OperationBooleanMenu.this.bool_column, Boolean.FALSE);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(toggle_all_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Toggle All", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationBooleanMenu.this.toggleAllAtColumn(OperationBooleanMenu.this.bool_column);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(enable_all_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Enable All", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationBooleanMenu.this.setAllAtColumn(OperationBooleanMenu.this.bool_column, Boolean.TRUE);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(disable_all_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Disable All", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationBooleanMenu.this.setAllAtColumn(OperationBooleanMenu.this.bool_column, Boolean.FALSE);
            }
        });
        super.add(jMenuItem);
    }

    private void toggleSelectedAtColumn(int n) {
        int[] nArray = this.table_view.getSelectedRows();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            Boolean bl = (Boolean)this.table_model.getValueAt(n3, n);
            if (bl.booleanValue()) {
                this.table_model.setValueAt(Boolean.FALSE, n3, n);
                continue;
            }
            this.table_model.setValueAt(Boolean.TRUE, n3, n);
        }
    }

    private void setSelectedAtColumn(int n, Boolean bl) {
        int[] nArray = this.table_view.getSelectedRows();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            this.table_model.setValueAt(bl, n3, n);
        }
    }

    private void toggleAllAtColumn(int n) {
        int n2 = this.table_model.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Boolean bl = (Boolean)this.table_model.getValueAt(i, n);
            if (bl.booleanValue()) {
                this.table_model.setValueAt(Boolean.FALSE, i, n);
                continue;
            }
            this.table_model.setValueAt(Boolean.TRUE, i, n);
        }
    }

    private void setAllAtColumn(int n, Boolean bl) {
        int n2 = this.table_model.getRowCount();
        for (int i = 0; i < n2; ++i) {
            this.table_model.setValueAt(bl, i, n);
        }
    }

    private URL getURL(String string) {
        return this.getClass().getResource(string);
    }
}

