/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import viewer.legends.LegendComparators;
import viewer.legends.LegendTableModel;

public class OperationStringMenu
extends JPopupMenu {
    private static final long serialVersionUID = 2600L;
    private static String index_order_icon_path = "/images/checkbox/IndexOrder.gif";
    private static String case_sensitive_topo_order_icon_path = "/images/checkbox/CaseSensitiveTopoOrder.gif";
    private JTable table_view;
    private LegendTableModel table_model;
    private int str_column;

    public OperationStringMenu(JTable jTable, int n) {
        this.table_view = jTable;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        this.str_column = n;
        super.setLabel(this.table_model.getColumnName(this.str_column));
        super.setToolTipText(this.table_model.getColumnToolTip(this.str_column));
        this.addMenuItems();
    }

    private void addMenuItems() {
        URL uRL = null;
        uRL = this.getURL(case_sensitive_topo_order_icon_path);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        JMenuItem jMenuItem = new JMenuItem("A...Z a...z", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationStringMenu.this.table_model.arrangeOrder(LegendComparators.CASE_SENSITIVE_ORDER);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(case_sensitive_topo_order_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("z...a Z...A", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationStringMenu.this.table_model.reverseOrder(LegendComparators.CASE_SENSITIVE_ORDER);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(case_sensitive_topo_order_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Aa...Zz", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationStringMenu.this.table_model.arrangeOrder(LegendComparators.CASE_INSENSITIVE_ORDER);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(case_sensitive_topo_order_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("zZ...aA", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationStringMenu.this.table_model.reverseOrder(LegendComparators.CASE_INSENSITIVE_ORDER);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(index_order_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Creation Order", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationStringMenu.this.table_model.arrangeOrder(LegendComparators.INDEX_ORDER);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(index_order_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("Reverse Creation Order", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationStringMenu.this.table_model.reverseOrder(LegendComparators.INDEX_ORDER);
            }
        });
        super.add(jMenuItem);
    }

    private URL getURL(String string) {
        return this.getClass().getResource(string);
    }
}

