/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.Drawable;
import base.drawable.DrawnBox;
import base.drawable.DrawnBoxSet;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.topology.Arrow;
import base.topology.Event;
import base.topology.Line;
import base.topology.State;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Composite
extends Drawable
implements MixedDataIO {
    private static final int INIT_BYTESIZE = 2;
    private Primitive[] primes;
    private int last_prime_idx;

    public Composite() {
        this.primes = null;
    }

    public Composite(int Nprimes) {
        this.primes = new Primitive[Nprimes];
        this.last_prime_idx = this.primes.length - 1;
    }

    public Composite(Category in_type, int Nprimes) {
        super(in_type);
        this.primes = new Primitive[Nprimes];
        this.last_prime_idx = this.primes.length - 1;
    }

    public Composite(int type_idx, double starttime, double endtime, Primitive[] in_primes, byte[] byte_infovals) {
        super(type_idx, byte_infovals);
        super.setEarliestTime(starttime);
        super.setLatestTime(endtime);
        this.primes = in_primes;
    }

    public boolean resolveCategory(Map categorymap) {
        boolean allOK = super.resolveCategory(categorymap);
        if (this.primes != null) {
            for (int idx = this.primes.length - 1; idx >= 0; --idx) {
                Primitive prime = this.primes[idx];
                if (prime == null) continue;
                boolean isOK = prime.resolveCategory(categorymap);
                allOK = allOK && isOK;
            }
        }
        return allOK;
    }

    public int getNumOfPrimitives() {
        if (this.primes != null) {
            return this.primes.length;
        }
        return 0;
    }

    public int getByteSize() {
        int bytesize = super.getCategory() != null ? super.getByteSize() + 2 : 0;
        if (this.primes != null) {
            for (int idx = this.primes.length - 1; idx >= 0; --idx) {
                bytesize += this.primes[idx].getByteSize();
            }
        }
        return bytesize;
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        Arrays.sort(this.primes, Drawable.INCRE_STARTTIME_ORDER);
        super.writeObject(outs);
        int primes_length = this.primes.length;
        outs.writeShort(primes_length);
        for (int idx = 0; idx < primes_length; ++idx) {
            this.primes[idx].writeObject(outs);
        }
    }

    public Composite(MixedDataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        super.readObject(ins);
        short Nprimes = ins.readShort();
        this.primes = new Primitive[Nprimes];
        for (int idx = 0; idx < this.primes.length; idx = (int)((short)(idx + 1))) {
            Primitive prime = new Primitive(ins);
            prime.setParent(this);
            this.primes[idx] = prime;
            super.affectTimeBounds(prime);
        }
        this.last_prime_idx = this.primes.length - 1;
    }

    public void setPrimitive(int prime_idx, Primitive prime) throws ArrayIndexOutOfBoundsException {
        if (prime_idx < 0 || prime_idx >= this.primes.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + prime_idx + ", is out of range, [0.." + this.primes.length + "].");
        }
        this.primes[prime_idx] = prime;
        super.affectTimeBounds(prime);
    }

    public Primitive getPrimitive(int prime_idx) throws ArrayIndexOutOfBoundsException {
        if (prime_idx < 0 || prime_idx >= this.primes.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + prime_idx + ", is out of range, [0.." + this.primes.length + "].");
        }
        return this.primes[prime_idx];
    }

    public void setPrimitives(Primitive[] in_primes) throws IllegalArgumentException {
        if (in_primes.length != this.primes.length) {
            throw new IllegalArgumentException("input array size, " + in_primes.length + ", is " + "different from the original, " + this.primes.length);
        }
        this.primes = in_primes;
        for (int idx = this.primes.length - 1; idx >= 0; --idx) {
            super.affectTimeBounds(this.primes[idx]);
        }
    }

    public Primitive[] getPrimitives() {
        return this.primes;
    }

    public Iterator timeLapIterator(TimeBoundingBox tframe) {
        return new ItrOfPrimes(tframe);
    }

    public SortedSet getSetOfPrimitiveLineIDs() {
        TreeSet lineIDs = new TreeSet();
        for (int idx = 0; idx < this.primes.length; ++idx) {
            lineIDs.addAll(this.primes[idx].getListOfVertexLineIDs());
        }
        return lineIDs;
    }

    public Integer[] getArrayOfLineIDs() {
        SortedSet lineIDset = this.getSetOfPrimitiveLineIDs();
        Integer[] lineIDary = new Integer[lineIDset.size()];
        lineIDset.toArray(lineIDary);
        return lineIDary;
    }

    public void setStartPrimitive(Primitive start_prime) {
        this.primes[0] = start_prime;
        super.affectTimeBounds(start_prime);
    }

    public void setFinalPrimitive(Primitive final_prime) {
        this.primes[this.last_prime_idx] = final_prime;
        super.affectTimeBounds(final_prime);
    }

    public Coord getStartVertex() {
        return this.primes[0].getStartVertex();
    }

    public Coord getFinalVertex() {
        return this.primes[this.last_prime_idx].getFinalVertex();
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("Composite[ " + super.toString() + " ");
        for (int idx = 0; idx < this.primes.length; ++idx) {
            rep.append(this.primes[idx].toString() + " ");
        }
        rep.append("]");
        return rep.toString();
    }

    public boolean isTimeOrdered() {
        if (!super.isTimeOrdered()) {
            System.err.println("**** Violation of Causality ****\nOffending Composite -> " + this);
            return false;
        }
        int primes_length = this.primes.length;
        for (int idx = 0; idx < primes_length; ++idx) {
            Primitive prime = this.primes[idx];
            if (!prime.isTimeOrdered()) {
                System.err.println("**** Internal Primitive Error ****\nIt is number " + idx + " primitive " + "in the composite.");
                return false;
            }
            if (super.covers(prime)) continue;
            System.err.println("**** Out of Composite Time Range ****\nOffending Primitive -> " + this + "\n" + "\t time coordinate " + idx + " is out of range.");
            return false;
        }
        return true;
    }

    public void addPrimitivesToSet(Set prime_set, TimeBoundingBox timeframe) {
        int primes_length = this.primes.length;
        for (int idx = 0; idx < primes_length; ++idx) {
            Primitive prime = this.primes[idx];
            if (!prime.overlaps(timeframe)) continue;
            prime_set.add(prime);
        }
    }

    public int drawState(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        int rowID = super.getRowID();
        float nesting_ftr = super.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        return State.draw((Graphics2D)g, (Color)color, null, (CoordPixelXform)coord_xform, (DrawnBox)drawn_boxes.getLastStatePos(rowID), (double)tStart, (float)rStart, (double)tFinal, (float)rFinal);
    }

    public int drawArrow(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        int iStart = (Integer)map_line2row.get(new Integer(start_vtx.lineID));
        int iFinal = (Integer)map_line2row.get(new Integer(final_vtx.lineID));
        return Arrow.draw((Graphics2D)g, (Color)color, null, (CoordPixelXform)coord_xform, (DrawnBox)drawn_boxes.getLastArrowPos(iStart, iFinal), (double)tStart, (float)iStart, (double)tFinal, (float)iFinal);
    }

    public int drawEvent(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord vtx = this.getStartVertex();
        double tPoint = vtx.time;
        int rowID = (Integer)map_line2row.get(new Integer(vtx.lineID));
        float rPeak = (float)rowID - 0.25f;
        float rStart = (float)rowID - 0.5f;
        float rFinal = rStart + 1.0f;
        return Event.draw((Graphics2D)g, (Color)color, null, (CoordPixelXform)coord_xform, (DrawnBox)drawn_boxes.getLastEventPos(rowID), (double)tPoint, (float)rPeak, (float)rStart, (float)rFinal);
    }

    public boolean isPixelInState(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        int rowID = super.getRowID();
        float nesting_ftr = super.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        return State.containsPixel((CoordPixelXform)coord_xform, (Point)pix_pt, (double)tStart, (float)rStart, (double)tFinal, (float)rFinal);
    }

    public boolean isPixelOnArrow(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        float rStart = ((Integer)map_line2row.get(new Integer(start_vtx.lineID))).floatValue();
        float rFinal = ((Integer)map_line2row.get(new Integer(final_vtx.lineID))).floatValue();
        return Line.containsPixel((CoordPixelXform)coord_xform, (Point)pix_pt, (double)tStart, (float)rStart, (double)tFinal, (float)rFinal);
    }

    public boolean isPixelAtEvent(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord vtx = this.getStartVertex();
        double tPoint = vtx.time;
        int rowID = (Integer)map_line2row.get(new Integer(vtx.lineID));
        float rStart = (float)rowID - 0.5f;
        float rFinal = rStart + 1.0f;
        return Event.containsPixel((CoordPixelXform)coord_xform, (Point)pix_pt, (double)tPoint, (float)rStart, (float)rFinal);
    }

    public boolean containSearchable() {
        return super.getCategory().isVisiblySearchable();
    }

    private class ItrOfPrimes
    implements Iterator {
        private TimeBoundingBox timeframe;
        private Primitive next_primitive;
        private int next_prime_idx;

        public ItrOfPrimes(TimeBoundingBox tframe) {
            this.timeframe = tframe;
            this.next_prime_idx = 0;
            this.next_primitive = Composite.this.primes != null ? this.getNextInQueue() : null;
        }

        private Primitive getNextInQueue() {
            while (this.next_prime_idx < Composite.this.primes.length) {
                if (!Composite.this.primes[this.next_prime_idx].overlaps(this.timeframe)) continue;
                Primitive next_prime = Composite.this.primes[this.next_prime_idx];
                ++this.next_prime_idx;
                return next_prime;
            }
            return null;
        }

        public boolean hasNext() {
            return this.next_primitive != null;
        }

        public Object next() {
            Primitive returning_prime = this.next_primitive;
            this.next_primitive = this.getNextInQueue();
            return returning_prime;
        }

        public void remove() {
        }
    }
}

