/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class PreviewEvent {
    private static double Max_LineSeg2Pt_DistSQ = 10.0;

    public static void setPixelClosenessTolerance(int pix_dist) {
        Max_LineSeg2Pt_DistSQ = pix_dist * pix_dist + 1;
    }

    public static int draw(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos, double point_time, float point_ypos) {
        boolean isPointVtxInImg;
        int iPoint = coord_xform.convertTimeToPixel(point_time);
        if (last_drawn_pos.coversEvent(iPoint)) {
            return 0;
        }
        last_drawn_pos.set(iPoint);
        boolean bl = isPointVtxInImg = iPoint > 0 && iPoint < coord_xform.getImageWidth();
        if (!isPointVtxInImg) {
            return 0;
        }
        int iStart = coord_xform.convertTimeToPixel(start_time);
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        int jPoint = coord_xform.convertRowToPixel(point_ypos);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        Stroke orig_stroke = null;
        if (stroke != null) {
            orig_stroke = g.getStroke();
            g.setStroke(stroke);
        }
        int iCornerLeft = 0;
        int iCornerRight = 0;
        int iWidthLeft = 0;
        int iWidthRight = 0;
        int jHeight = 0;
        g.setColor(color);
        if (jStart != jPoint) {
            jHeight = jPoint - jStart - 1;
            iCornerLeft = iStart;
            iWidthLeft = 2 * (iPoint - iStart);
            g.fillArc(iCornerLeft, jStart, iWidthLeft, jHeight, 90, 180);
            iCornerRight = 2 * iPoint - iFinal;
            iWidthRight = 2 * (iFinal - iPoint);
            g.fillArc(iCornerRight, jStart, iWidthRight, jHeight, 90, -180);
        }
        g.setColor(Color.white);
        g.drawLine(iPoint, jPoint, iPoint, jFinal);
        if (jStart != jPoint) {
            g.drawArc(iCornerLeft, jStart, iWidthLeft, jHeight, 90, 180);
            g.drawArc(iCornerRight, jStart, iWidthRight, jHeight, 90, -180);
        }
        if (stroke != null) {
            g.setStroke(orig_stroke);
        }
        return 1;
    }

    public static boolean containsPixel(CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos, double point_time, float point_ypos) {
        int jPoint;
        int pt_x = pt.x;
        int pt_y = pt.y;
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        if (pt_y < jStart) {
            return false;
        }
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        if (pt_y > jFinal) {
            return false;
        }
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (pt_x < iStart) {
            return false;
        }
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        if (pt_x > iFinal) {
            return false;
        }
        int iPoint = coord_xform.convertTimeToPixel(point_time);
        double distSQ = Line2D.ptSegDistSq(iPoint, jPoint = coord_xform.convertRowToPixel(point_ypos), iPoint, jFinal, pt_x, pt_y);
        if (distSQ < Max_LineSeg2Pt_DistSQ) {
            return true;
        }
        if (jStart != jPoint) {
            double fHalfWidthRight;
            double fCornerRight;
            double fHalfWidthLeft;
            double fCornerLeft;
            double fHalfHeight = (double)(jPoint - jStart) / 2.0;
            if (pt_x < iPoint ? PreviewEvent.isInEllipse(fCornerLeft = (double)iStart, jStart, fHalfWidthLeft = (double)(iPoint - iStart), fHalfHeight, pt_x, pt_y) : PreviewEvent.isInEllipse(fCornerRight = (double)(2 * iPoint - iFinal), jStart, fHalfWidthRight = (double)(iFinal - iPoint), fHalfHeight, pt_x, pt_y)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInEllipse(double xCorner, double yCorner, double xHalfWidth, double yHalfHeight, double pt_x, double pt_y) {
        double xDist = (pt_x - xCorner) / xHalfWidth - 1.0;
        double yDist = (pt_y - yCorner) / yHalfHeight - 1.0;
        return xDist * xDist + yDist * yDist <= 1.0;
    }
}

