/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import logformat.slog2.CategoryMap;
import viewer.legends.CategoryIcon;
import viewer.legends.CategoryIconEditor;
import viewer.legends.CategoryIconRenderer;
import viewer.legends.GenericHeaderRenderer;
import viewer.legends.LegendTableModel;
import viewer.legends.OperationBooleanMenu;
import viewer.legends.OperationNumberMenu;
import viewer.legends.OperationStringMenu;
import viewer.legends.TableColumnHandler;
import viewer.legends.TableHeaderHandler;

public class LegendTable
extends JTable {
    private static final long serialVersionUID = 2500L;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private LegendTableModel table_model;
    private TableColumnModel column_model;
    private JTableHeader table_header;

    public LegendTable(CategoryMap map) {
        this.table_model = new LegendTableModel(map);
        super.setModel(this.table_model);
        super.setDefaultRenderer(CategoryIcon.class, new CategoryIconRenderer());
        super.setDefaultEditor(CategoryIcon.class, new CategoryIconEditor());
        super.setAutoResizeMode(0);
        super.setIntercellSpacing(new Dimension(2, 2));
        super.setShowHorizontalLines(false);
        super.setShowVerticalLines(true);
        this.column_model = super.getColumnModel();
        this.table_header = this.getTableHeader();
        this.setColumnHeaderRenderers();
        this.initColumnSize();
    }

    private void setColumnHeaderRenderers() {
        int column_count = this.table_model.getColumnCount();
        for (int icol = 0; icol < column_count; ++icol) {
            TableColumn column = this.column_model.getColumn(icol);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (icol != 0) {
                JPopupMenu pop_menu;
                renderer = new GenericHeaderRenderer(this, icol);
                ((GenericHeaderRenderer)renderer).initPressablePullDownTab();
                column.setHeaderRenderer(renderer);
                switch (icol) {
                    case 1: {
                        pop_menu = new OperationStringMenu(this, icol);
                        break;
                    }
                    case 2: 
                    case 3: {
                        pop_menu = new OperationBooleanMenu(this, icol);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        pop_menu = new OperationNumberMenu(this, icol);
                        break;
                    }
                    default: {
                        pop_menu = null;
                    }
                }
                MouseAdapter handler = new TableHeaderHandler(this, icol, pop_menu);
                this.table_header.addMouseListener(handler);
                handler = new TableColumnHandler(this, icol, pop_menu);
                this.addMouseListener(handler);
            }
            if (renderer == null) {
                renderer = new GenericHeaderRenderer(this, icol);
                column.setHeaderRenderer(renderer);
                continue;
            }
            ((JComponent)((Object)renderer)).setToolTipText(this.table_model.getColumnToolTip(icol));
        }
    }

    private void initColumnSize() {
        int vport_width = 0;
        int vport_height = 0;
        int row_height = 0;
        Dimension intercell_gap = super.getIntercellSpacing();
        int column_count = this.table_model.getColumnCount();
        for (int icol = 0; icol < column_count; ++icol) {
            int cell_height;
            TableColumn column = this.column_model.getColumn(icol);
            TableCellRenderer renderer = column.getHeaderRenderer();
            Component component = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, -1, icol);
            Dimension header_size = component.getPreferredSize();
            Insets header_insets = ((JComponent)component).getInsets();
            int header_width = header_size.width + intercell_gap.width + header_insets.left + header_insets.right;
            renderer = column.getCellRenderer();
            if (renderer == null) {
                renderer = super.getDefaultRenderer(this.table_model.getColumnClass(icol));
            }
            component = renderer.getTableCellRendererComponent(this, this.table_model.getColumnMaxValue(icol), false, false, 0, icol);
            Dimension cell_size = component.getPreferredSize();
            Insets cell_insets = component instanceof CategoryIconRenderer ? ((JComponent)component).getInsets() : EMPTY_INSETS;
            int cell_width = cell_size.width + cell_insets.left + cell_insets.right;
            if (cell_width > header_width) {
                column.setPreferredWidth(cell_width);
                if (icol < 4) {
                    vport_width += cell_width;
                }
            } else {
                column.setPreferredWidth(header_width);
                if (icol < 4) {
                    vport_width += header_width;
                }
            }
            if ((cell_height = cell_size.height + cell_insets.top + cell_insets.bottom) <= row_height) continue;
            row_height = cell_height;
        }
        super.setRowHeight(row_height);
        int row_count = this.table_model.getRowCount();
        vport_height = row_count > 25 ? row_height * 25 : row_height * row_count;
        super.setPreferredScrollableViewportSize(new Dimension(vport_width, vport_height));
    }
}

