/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Drawable;
import base.drawable.DrawnBoxSet;
import base.drawable.Method;
import base.drawable.NestingStacks;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;
import viewer.common.CustomCursor;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.histogram.StatlineDialog;
import viewer.timelines.InfoDialogForDrawable;
import viewer.timelines.InfoPanelForDrawable;
import viewer.timelines.SearchTreeTrunk;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InitializableDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.Profile;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.SearchableView;
import viewer.zoomable.SummarizableView;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class CanvasTimeline
extends ScrollableObject
implements SearchableView,
SummarizableView {
    private static final long serialVersionUID = 13300L;
    private static final Drawable.Order INCRE_STARTTIME_ORDER = Drawable.INCRE_STARTTIME_ORDER;
    private static final Drawable.Order DECRE_STARTTIME_ORDER = Drawable.DECRE_STARTTIME_ORDER;
    private TreeTrunk treetrunk;
    private YaxisMaps y_maps;
    private YaxisTree tree_view;
    private BoundedRangeModel y_model;
    private Method[] methods;
    private String[] y_colnames;
    private Frame root_frame;
    private TimeBoundingBox timeframe4imgs;
    private ChangeListener change_listener;
    private ChangeEvent change_event;
    private int num_rows;
    private int row_height;
    private NestingStacks nesting_stacks;
    private Map map_line2row;
    private DrawnBoxSet drawn_boxes;
    private boolean isConnectedComposite;
    private SearchTreeTrunk tree_search;
    private Date zero_time;
    private Date init_time;
    private Date final_time;

    public CanvasTimeline(ModelTime time_model, TreeTrunk treebody, BoundedRangeModel yaxis_model, YaxisMaps yaxis_maps, String[] yaxis_colnames, Method[] dobj_methods) {
        super(time_model);
        this.treetrunk = treebody;
        this.y_maps = yaxis_maps;
        this.tree_view = this.y_maps.getTreeView();
        this.y_model = yaxis_model;
        this.y_colnames = yaxis_colnames;
        this.methods = dobj_methods;
        TreeNode treeroot = this.treetrunk.getTreeRoot();
        short depth_max = treeroot.getTreeNodeID().depth;
        this.nesting_stacks = new NestingStacks(this.tree_view);
        this.map_line2row = null;
        this.drawn_boxes = new DrawnBoxSet(this.tree_view);
        this.timeframe4imgs = null;
        short depth_init = (short)(depth_max - Parameters.INIT_SLOG2_LEVEL_READ + 1);
        if (depth_init < 0) {
            depth_init = 0;
        }
        this.treetrunk.growInTreeWindow(treeroot, depth_init, new TimeBoundingBox(treeroot));
        this.treetrunk.setNumOfViewsPerUpdate(6);
        this.isConnectedComposite = false;
        if (this.methods != null && this.methods.length > 0) {
            this.isConnectedComposite = this.methods[0].isConnectCompositeState();
        }
        this.tree_search = new SearchTreeTrunk(this.treetrunk, this.tree_view, this.isConnectedComposite);
        this.root_frame = null;
        this.change_event = null;
        this.change_listener = null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.change_event = new ChangeEvent(this);
        this.change_listener = listener;
    }

    public Dimension getMinimumSize() {
        int min_view_height = 0;
        if (Debug.isActive()) {
            Debug.println("CanvasTimeline: min_size = (0," + min_view_height + ")");
        }
        return new Dimension(0, min_view_height);
    }

    public Dimension getMaximumSize() {
        if (Debug.isActive()) {
            Debug.println("CanvasTimeline: max_size = (32767,32767)");
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getJComponentHeight() {
        int rows_size = this.tree_view.getRowCount() * this.tree_view.getRowHeight();
        int view_size = this.y_model.getMaximum() - this.y_model.getMinimum() + 1;
        if (view_size > rows_size) {
            return view_size;
        }
        return rows_size;
    }

    private void fireChangeEvent() {
        if (this.change_event != null) {
            this.change_listener.stateChanged(this.change_event);
        }
    }

    protected void initializeAllOffImages(TimeBoundingBox imgs_times) {
        if (Profile.isActive()) {
            this.zero_time = new Date();
        }
        if (this.root_frame == null) {
            this.root_frame = (Frame)SwingUtilities.windowForComponent(this);
        }
        if (this.timeframe4imgs == null) {
            this.timeframe4imgs = new TimeBoundingBox(imgs_times);
        }
        Routines.setComponentAndChildrenCursors(this.root_frame, CustomCursor.Wait);
        this.num_rows = this.tree_view.getRowCount();
        this.row_height = this.tree_view.getRowHeight();
        boolean isScrolling = this.treetrunk.updateTimeWindow(this.timeframe4imgs, imgs_times) == 1;
        this.nesting_stacks.initialize(isScrolling);
        if (Profile.isActive()) {
            this.init_time = new Date();
        }
        this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        if (this.map_line2row == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(this.root_frame, "Error in updating YaxisMaps!");
            }
            this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        }
        this.drawn_boxes.initialize();
    }

    protected void finalizeAllOffImages(TimeBoundingBox imgs_times) {
        this.drawn_boxes.finish();
        this.map_line2row = null;
        this.nesting_stacks.finish();
        this.timeframe4imgs.setEarliestTime(imgs_times.getEarliestTime());
        this.timeframe4imgs.setLatestTime(imgs_times.getLatestTime());
        this.fireChangeEvent();
        Routines.setComponentAndChildrenCursors(this.root_frame, CustomCursor.Normal);
        if (Profile.isActive()) {
            this.final_time = new Date();
        }
        if (Profile.isActive()) {
            Profile.println("CanvasTimeline.finalizeAllOffImages(): init. time = " + (this.init_time.getTime() - this.zero_time.getTime()) + " msec.,   total time = " + (this.final_time.getTime() - this.zero_time.getTime()) + " msec.");
        }
    }

    protected void drawOneOffImage(Image offImage, TimeBoundingBox timebounds) {
        if (Debug.isActive()) {
            Debug.println("CanvasTimeline: drawOneOffImage()'s offImage = " + offImage);
        }
        if (offImage != null) {
            Drawable dobj;
            int offImage_width = offImage.getWidth(this);
            int offImage_height = offImage.getHeight(this);
            Graphics2D offGraphics = (Graphics2D)offImage.getGraphics();
            offGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            offGraphics.setPaint((Color)Parameters.BACKGROUND_COLOR.toValue());
            offGraphics.fillRect(0, 0, offImage_width, offImage_height);
            CoordPixelImage coord_xform = new CoordPixelImage(this, this.row_height, timebounds);
            offGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            offGraphics.setColor(Color.cyan);
            for (int irow = 0; irow < this.num_rows; ++irow) {
                if (this.tree_view.isExpanded(irow)) continue;
                int i_Y = coord_xform.convertRowToPixel(irow);
                offGraphics.drawLine(0, i_Y, offImage_width - 1, i_Y);
            }
            if (Debug.isActive() || Profile.isActive()) {
                offGraphics.setColor(Color.gray);
                offGraphics.drawLine(0, 0, 0, this.getHeight());
            }
            this.nesting_stacks.reset();
            this.drawn_boxes.reset();
            Iterator dobjs = this.treetrunk.iteratorOfAllDrawables(timebounds, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
            while (dobjs.hasNext()) {
                dobj = (Drawable)dobjs.next();
                if (!dobj.getCategory().isVisible()) continue;
                dobj.setStateRowAndNesting(coord_xform, this.map_line2row, this.nesting_stacks);
            }
            int N_nestable = 0;
            int N_nestless = 0;
            int N_nestable_drawn = 0;
            int N_nestless_drawn = 0;
            dobjs = this.treetrunk.iteratorOfRealDrawables(timebounds, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
            while (dobjs.hasNext()) {
                dobj = (Drawable)dobjs.next();
                if (!dobj.getCategory().isVisible()) continue;
                N_nestable_drawn += dobj.drawOnCanvas(offGraphics, coord_xform, this.map_line2row, this.drawn_boxes);
                N_nestable += dobj.getNumOfPrimitives();
            }
            Iterator sobjs = this.treetrunk.iteratorOfLowestFloorShadows(timebounds, INCRE_STARTTIME_ORDER, true);
            while (sobjs.hasNext()) {
                Shadow sobj = (Shadow)sobjs.next();
                if (!sobj.getCategory().isVisible()) continue;
                N_nestable_drawn += sobj.drawOnCanvas(offGraphics, coord_xform, this.map_line2row, this.drawn_boxes);
                N_nestable += sobj.getNumOfPrimitives();
            }
            offGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Parameters.ARROW_ANTIALIASING.toValue());
            dobjs = this.treetrunk.iteratorOfAllDrawables(timebounds, INCRE_STARTTIME_ORDER, this.isConnectedComposite, false);
            while (dobjs.hasNext()) {
                dobj = (Drawable)dobjs.next();
                if (!dobj.getCategory().isVisible()) continue;
                N_nestless_drawn += dobj.drawOnCanvas(offGraphics, coord_xform, this.map_line2row, this.drawn_boxes);
                N_nestless += dobj.getNumOfPrimitives();
            }
            if (Profile.isActive()) {
                Profile.println("CanvasTimeline.drawOneOffImage(): R_NestAble = " + N_nestable_drawn + "/" + N_nestable + ",  " + "R_NestLess = " + N_nestless_drawn + "/" + N_nestless);
            }
            offGraphics.dispose();
        }
    }

    public InfoDialog getPropertyAt(Point local_click, TimeBoundingBox vport_timeframe) {
        Drawable clicked_dobj;
        Drawable dobj;
        CoordPixelImage coord_xform = new CoordPixelImage(this, this.row_height, super.getTimeBoundsOfImages());
        double clicked_time = coord_xform.convertPixelToTime(local_click.x);
        Map map_line2treeleaf = this.y_maps.getMapOfLineIDToTreeLeaf();
        Map map_line2row = this.y_maps.getMapOfLineIDToRowID();
        if (map_line2row == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(this.root_frame, "Error in updating YaxisMaps!");
            }
            map_line2row = this.y_maps.getMapOfLineIDToRowID();
        }
        Iterator dobjs = this.treetrunk.iteratorOfAllDrawables(vport_timeframe, DECRE_STARTTIME_ORDER, this.isConnectedComposite, false);
        while (dobjs.hasNext()) {
            dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisible() || (clicked_dobj = dobj.getDrawableAt(coord_xform, map_line2row, local_click)) == null || !clicked_dobj.getCategory().isVisible()) continue;
            return new InfoDialogForDrawable(this.root_frame, clicked_time, map_line2treeleaf, this.y_colnames, clicked_dobj);
        }
        Iterator sobjs = this.treetrunk.iteratorOfLowestFloorShadows(vport_timeframe, DECRE_STARTTIME_ORDER, true);
        while (sobjs.hasNext()) {
            Shadow sobj = (Shadow)sobjs.next();
            if (!sobj.getCategory().isVisible() || (clicked_dobj = sobj.getDrawableAt(coord_xform, map_line2row, local_click)) == null || !clicked_dobj.getCategory().isVisible()) continue;
            return new InfoDialogForDrawable(this.root_frame, clicked_time, map_line2treeleaf, this.y_colnames, clicked_dobj);
        }
        dobjs = this.treetrunk.iteratorOfRealDrawables(vport_timeframe, DECRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        while (dobjs.hasNext()) {
            dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisible() || (clicked_dobj = dobj.getDrawableAt(coord_xform, map_line2row, local_click)) == null || !clicked_dobj.getCategory().isVisible()) continue;
            return new InfoDialogForDrawable(this.root_frame, clicked_time, map_line2treeleaf, this.y_colnames, clicked_dobj);
        }
        return super.getTimePropertyAt(local_click);
    }

    public Rectangle localRectangleForDrawable(Drawable dobj) {
        CoordPixelImage coord_xform = new CoordPixelImage(this, this.row_height, super.getTimeBoundsOfImages());
        int xloc = coord_xform.convertTimeToPixel(dobj.getEarliestTime());
        int width = coord_xform.convertTimeToPixel(dobj.getLatestTime()) - xloc;
        int rowID = dobj.getRowID();
        float nesting_ftr = dobj.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        int yloc = coord_xform.convertRowToPixel(rStart);
        int height = coord_xform.convertRowToPixel(rFinal) - yloc;
        Rectangle local_rect = new Rectangle(xloc, yloc, width, height);
        return local_rect;
    }

    private InfoPanelForDrawable createInfoPanelForDrawable(Drawable dobj) {
        Map map_line2treeleaf = this.y_maps.getMapOfLineIDToTreeLeaf();
        InfoPanelForDrawable info_popup = new InfoPanelForDrawable(map_line2treeleaf, this.y_colnames, dobj);
        return info_popup;
    }

    public SearchPanel searchPreviousComponent(double searching_time) {
        Drawable dobj = this.tree_search.previousDrawable(searching_time);
        if (dobj != null) {
            return this.createInfoPanelForDrawable(dobj);
        }
        return null;
    }

    public SearchPanel searchPreviousComponent() {
        Drawable dobj = this.tree_search.previousDrawable();
        if (dobj != null) {
            return this.createInfoPanelForDrawable(dobj);
        }
        return null;
    }

    public SearchPanel searchNextComponent(double searching_time) {
        Drawable dobj = this.tree_search.nextDrawable(searching_time);
        if (dobj != null) {
            return this.createInfoPanelForDrawable(dobj);
        }
        return null;
    }

    public SearchPanel searchNextComponent() {
        Drawable dobj = this.tree_search.nextDrawable();
        if (dobj != null) {
            return this.createInfoPanelForDrawable(dobj);
        }
        return null;
    }

    public InitializableDialog createSummary(Dialog dialog, TimeBoundingBox timebox) {
        BufForTimeAveBoxes buf4statboxes = this.tree_search.createBufForTimeAveBoxes(timebox);
        return new StatlineDialog(dialog, timebox, this.y_maps.getLineIDMap(), buf4statboxes);
    }
}

