/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.InfoType;
import base.drawable.InfoValue;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.io.DataIO;
import base.io.MixedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class InfoBox
extends TimeBoundingBox
implements DataIO {
    private static final int INIT_BYTESIZE = 6;
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;
    private boolean hasBufBeenDecoded;
    private byte[] infobuffer;
    private InfoValue[] infovals;
    private StringBuffer err_msg;
    private String[] infokeys = null;

    public InfoBox() {
        this.initCategoryToNull();
        this.err_msg = null;
    }

    public InfoBox(int in_type_idx) {
        this.initCategoryToNull();
        this.type_idx = in_type_idx;
        this.err_msg = null;
    }

    public InfoBox(Category in_type) {
        this.setCategory(in_type);
        this.err_msg = null;
    }

    public InfoBox(InfoBox infobox) {
        super(infobox);
        this.setCategory(infobox.type);
        this.err_msg = null;
    }

    public InfoBox(Category in_type, InfoBox infobox) {
        super(infobox);
        this.setCategory(in_type);
        this.err_msg = null;
    }

    private void initCategoryToNull() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
        this.infobuffer = null;
        this.infovals = null;
        this.hasBufBeenDecoded = false;
    }

    private void setCategory(Category in_type) {
        if (in_type != null) {
            this.type = in_type;
            this.type_idx = this.type.getIndex();
            this.infobuffer = null;
            this.infovals = null;
            this.hasBufBeenDecoded = false;
        } else {
            this.initCategoryToNull();
        }
    }

    public boolean resolveCategory(Map categorymap) {
        if (this.type == null) {
            if (this.type_idx != Integer.MIN_VALUE) {
                this.type = (Category)categorymap.get(new Integer(this.type_idx));
                if (this.type != null) {
                    this.type.setUsed(true);
                } else {
                    this.type = new Category(this.type_idx, "UnknownType-" + this.type_idx, Topology.STATE, ColorAlpha.getNextDefaultColor(), 1);
                    categorymap.put(new Integer(this.type.getIndex()), this.type);
                    this.type.setUsed(true);
                }
                return true;
            }
        } else {
            if (!this.type.isUsed()) {
                categorymap.put(new Integer(this.type.getIndex()), this.type);
                this.type.setUsed(true);
                if (this.type.getName() == null) {
                    this.type.setName("UnknownType-" + this.type.getIndex());
                    this.type.setColor(ColorAlpha.getNextDefaultColor());
                }
            }
            return true;
        }
        return false;
    }

    public void releaseCategory() {
        if (this.type != null) {
            this.type.setUsed(false);
            this.type = null;
        }
    }

    public Category getCategory() {
        return this.type;
    }

    public int getCategoryIndex() {
        return this.type_idx;
    }

    private void addErrMsg(String new_msg) {
        if (this.err_msg == null) {
            this.err_msg = new StringBuffer(new_msg);
        } else {
            this.err_msg.append(" " + new_msg);
        }
    }

    public void setInfoBuffer(byte[] byte_infovals) {
        this.infobuffer = byte_infovals;
    }

    private void setInfoValueTypes() {
        if (this.type != null) {
            InfoType[] infotypes = this.type.getInfoTypes();
            if (infotypes != null && infotypes.length > 0) {
                int infotypes_length = infotypes.length;
                this.infovals = new InfoValue[infotypes_length];
                for (int idx = 0; idx < infotypes_length; ++idx) {
                    this.infovals[idx] = new InfoValue(infotypes[idx]);
                }
            } else {
                this.infovals = null;
            }
        }
    }

    private void setInfoValues() {
        this.setInfoValueTypes();
        if (this.infobuffer == null) {
            if (this.infovals != null && this.infovals.length > 0) {
                this.addErrMsg("Missing user byte[] but Non-empty format chars!");
            }
            return;
        }
        if (this.infovals != null) {
            ByteArrayInputStream bary_ins = new ByteArrayInputStream(this.infobuffer);
            MixedDataInputStream data_ins = new MixedDataInputStream(bary_ins);
            try {
                for (int idx = 0; idx < this.infovals.length; ++idx) {
                    this.infovals[idx].readValue(data_ins);
                }
                data_ins.close();
                bary_ins.close();
            }
            catch (IOException ioerr) {
                ioerr.printStackTrace();
                System.exit(1);
            }
        } else {
            this.addErrMsg("Can't decode user byte[] with Missing format chars!");
        }
    }

    private void decodeInfoBuffer() {
        if (!this.hasBufBeenDecoded) {
            this.hasBufBeenDecoded = true;
            this.setInfoValues();
        }
    }

    public int getInfoLength() {
        this.decodeInfoBuffer();
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && this.infokeys.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int infokeys_length = this.infokeys != null ? this.infokeys.length : 0;
                int infovals_length = this.infovals != null ? this.infovals.length : 0;
                int max_length = Math.max(infokeys_length, infovals_length);
                return max_length;
            }
        }
        return 0;
    }

    public String getInfoKey(int idx) {
        this.decodeInfoBuffer();
        if (this.infokeys != null && idx < this.infokeys.length) {
            return this.infokeys[idx];
        }
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && idx < this.infokeys.length) {
                return this.infokeys[idx];
            }
        }
        return null;
    }

    public InfoValue getInfoValue(int idx) {
        this.decodeInfoBuffer();
        if (this.infovals != null && idx < this.infovals.length) {
            return this.infovals[idx];
        }
        return null;
    }

    public int getByteSize() {
        int bytesize = 6;
        if (this.infobuffer != null) {
            bytesize += this.infobuffer.length;
        }
        return bytesize;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeInt(this.type_idx);
        if (this.infobuffer != null && this.infobuffer.length > 0) {
            outs.writeShort(this.infobuffer.length);
            outs.write(this.infobuffer);
        } else {
            outs.writeShort(0);
        }
    }

    public InfoBox(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.type_idx = ins.readInt();
        short infobuf_length = ins.readShort();
        if (infobuf_length > 0) {
            this.infobuffer = new byte[infobuf_length];
            ins.readFully(this.infobuffer);
        } else {
            this.infobuffer = null;
        }
    }

    public String toInfoBoxString() {
        StringBuffer rep = new StringBuffer();
        this.decodeInfoBuffer();
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && this.infokeys.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int infokeys_length = this.infokeys != null ? this.infokeys.length : 0;
                int infovals_length = this.infovals != null ? this.infovals.length : 0;
                int max_length = Math.max(infokeys_length, infovals_length);
                for (int idx = 0; idx < max_length; ++idx) {
                    if (idx < infokeys_length) {
                        rep.append(this.infokeys[idx]);
                    }
                    if (idx >= infovals_length) continue;
                    rep.append(this.infovals[idx]);
                }
            }
        } else if (this.infovals != null) {
            for (int idx = 0; idx < this.infovals.length; ++idx) {
                rep.append(this.infovals[idx] + " ");
            }
        }
        if (this.err_msg != null) {
            rep.append("\n" + this.err_msg);
        }
        return rep.toString();
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("infobox[ " + super.toString() + " ");
        if (this.type != null) {
            rep.append("Category=" + this.type + ": ");
        } else {
            rep.append("Category=" + this.type_idx + ": ");
        }
        this.decodeInfoBuffer();
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && this.infokeys.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int infokeys_length = this.infokeys != null ? this.infokeys.length : 0;
                int infovals_length = this.infovals != null ? this.infovals.length : 0;
                int max_length = Math.max(infokeys_length, infovals_length);
                for (int idx = 0; idx < max_length; ++idx) {
                    if (idx < infokeys_length) {
                        rep.append(this.infokeys[idx]);
                    }
                    if (idx >= infovals_length) continue;
                    rep.append(this.infovals[idx]);
                }
            }
        } else if (this.infovals != null) {
            for (int idx = 0; idx < this.infovals.length; ++idx) {
                rep.append(this.infovals[idx] + " ");
            }
        }
        if (this.err_msg != null) {
            rep.append(" **** " + this.err_msg + " **** ");
        }
        rep.append("]");
        return rep.toString();
    }
}

