#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include  "mp3util.h"
#include "mplinux.h"

void ButtonRelief  (GtkWidget *widget,gpointer data) {

     gtk_button_set_relief(GTK_BUTTON(widget),(GtkReliefStyle)data);

}


void left_treeview_GetSelectedInfo (GtkTreeModel *model,
				    GtkTreePath *path,
				    GtkTreeIter *iter,
				    PlayListEntry** p) {
     PlayListEntry* get;

     gtk_tree_model_get(model,iter,0,&get,-1);
     *p = get;
}



void create_file_info_window() {
     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeSelection* selection;
     PlayListEntry* p = NULL;
     struct mp3_info* m;
     GtkWidget* dialog;
     GtkWidget* temp;
     GtkWidget* temp2;
     GtkWidget* temp3;
     GtkWidget* temp4;
     gchar text[128];
     gint i;
	 gsize bytes_read;
	 gsize bytes_written;
	 
     tv = MW_GET("left_treeview");

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
    gtk_tree_selection_selected_foreach (selection,
				      (GtkTreeSelectionForeachFunc)left_treeview_GetSelectedInfo ,
				      &p);

    if (p == NULL)
	 return;
    m = pl_GetMp3Info(p->name->str);
    if (m == NULL)
	 return;

    //strncpy(text,_("File Info "),12);
    dialog = gtk_dialog_new_with_buttons(_("File Info "),MainWindow,
					     GTK_DIALOG_MODAL & 
					     GTK_DIALOG_DESTROY_WITH_PARENT,
					     GTK_STOCK_CLOSE,GTK_RESPONSE_OK,NULL);
#ifdef NLS							 
    temp2 = gtk_label_new(convert_if_needed(p->name->str));
#else
	temp2 = gtk_label_new(p->name->str);
#endif
	gtk_label_set_line_wrap(GTK_LABEL(temp2),TRUE);	
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),temp2,FALSE,FALSE,5);
    temp = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),temp,TRUE,TRUE,5);

//    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),temp);
    temp2 = gtk_table_new(5,3,FALSE); 
    gtk_table_set_col_spacings(GTK_TABLE(temp2),3);
    temp4 = gtk_frame_new(_("ID3 Tag"));
	gtk_frame_set_shadow_type(GTK_FRAME(temp4),GTK_SHADOW_NONE);
    gtk_container_set_border_width(GTK_CONTAINER(temp4),5);
    gtk_box_pack_start(GTK_BOX(temp),temp4,TRUE,TRUE,0);
    gtk_container_add(GTK_CONTAINER(temp4),temp2);

    temp3 = gtk_table_new(8,2,TRUE); 
    gtk_table_set_row_spacings(GTK_TABLE(temp2),3);
    temp4 = gtk_frame_new(_("MPEG Info"));
    gtk_container_set_border_width(GTK_CONTAINER(temp4),5);
    gtk_box_pack_start(GTK_BOX(temp),temp4,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(temp4),temp3);
	gtk_frame_set_shadow_type(GTK_FRAME(temp4),GTK_SHADOW_NONE);
	
    for(i=0;i<4;i++) {	      
	 GtkWidget* l;
	 GtkWidget* e;
	 gchar* labels[] = {_("Title"),_("Artist"),_("Album"),_("Comment")};
	 gchar* values[] = {m->title,m->artist,m->album,m->comment};
	 
	 l = gtk_label_new(labels[i]);
	 e = gtk_entry_new();
	 if (m->hastag)
#ifdef NLS		 
		 gtk_entry_set_text(GTK_ENTRY(e),convert_if_needed(values[i]));
#else		 
		 gtk_entry_set_text(GTK_ENTRY(e),values[i]);
#endif
	 gtk_table_attach_defaults(GTK_TABLE(temp2),l,0,1,i,i+1);
	 gtk_table_attach_defaults(GTK_TABLE(temp2),e,1,2,i,i+1);
    }

    for(i=0;i<7;i++) {	      
	 GtkWidget* l;
	 GtkWidget* l2;
	 gchar* labels[] = {_("Version"),_("layer"),_("Bitrate"),_("Samplerate"),_("stereo"),_("copyright"),_("size")};
	 gint values[] = {m->version,m->layer,m->bitrate,m->samplerate,m->channels,
			    m->copyright,m->filesize};
	 gchar c[15];
	 
	 l = gtk_label_new(labels[i]);
	 gtk_misc_set_alignment(GTK_MISC(l),0,0.5);

	 if (i == 2)
		  sprintf(c,"%d kbps",values[i]/1000);
	 else if (i == 3)
		  sprintf(c,"%.1f kHz",(float) values[i]/ (float)1000);	
	 else if (i  == 4)
	      sprintf(c,"%s",values[i] == 3 ? _("no"):_("yes"));
	 else if (i  == 5)
	      sprintf(c,"%s",values[i]  ? _("yes"):_("no"));
	 else if (i == 6)
		  sprintf(c,"%d KB",values[i] / 1024);
	 else 
	      sprintf(c,"%d",values[i]);
	  l2 = gtk_label_new(c); 
	 gtk_table_attach_defaults(GTK_TABLE(temp3),l,0,1,i,i+1);
	 gtk_table_attach_defaults(GTK_TABLE(temp3),l2,1,2,i,i+1);
    }
    

     g_signal_connect_swapped (GTK_OBJECT (dialog), "response",
			       G_CALLBACK (gtk_widget_destroy),
			       GTK_OBJECT (dialog));

     gtk_dialog_set_has_separator (GTK_DIALOG(dialog),FALSE);
     gtk_container_foreach(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area),
			   ButtonRelief,(gpointer)GTK_RELIEF_NONE);
     
     gtk_widget_show_all(dialog);
}


void sensitive_callback(GtkWidget* widget,gpointer data) {
    if (GTK_WIDGET_TYPE(widget) == GTK_TYPE_CONTAINER)
        gtk_container_foreach(GTK_CONTAINER(widget),sensitive_callback,data);
    gtk_widget_set_sensitive(widget,(gboolean)data);
}

void active_button_Toggled (GtkToggleButton *togglebutton,
                                 gpointer user_data) {
    
    GtkWidget* container;
    gboolean checked;

    checked =  gtk_toggle_button_get_active(togglebutton);
    container = (GtkWidget*) user_data;
    gtk_widget_set_sensitive(container,checked);
    if (GTK_WIDGET_TYPE(container) == GTK_TYPE_CONTAINER)
        gtk_container_foreach(GTK_CONTAINER(container),sensitive_callback,(gpointer) checked);

}

extern GtkTooltips* tooltips;

void  create_options_window() {
     GtkWidget* dialog;
     GtkWidget* vbox;
     GtkWidget* table;
     GtkWidget* hbox;
     GtkWidget* tabs;
     GtkWidget* tooltext_button;
     GtkWidget* startconnect_button;
     GtkWidget* listload_button;
     GtkWidget* unplugexit_button;
     GtkWidget* play_entry;
     GtkWidget* stop_entry;
     GtkWidget* title_entry;
     GtkWidget* label;
     GtkWidget* customtitle_button;
     GtkWidget* enablelogging_button;
     GtkWidget* changeid_button;
     GtkWidget* logsize_spin;
     GtkWidget* frame;
     GtkWidget* frame2;
     GtkWidget* vendor_entry;
     GtkWidget* productid_entry;
     gchar convert[8];
     gchar* c; 
     gchar* b;

    dialog = gtk_dialog_new_with_buttons(_("Options"),MainWindow,
					     GTK_DIALOG_MODAL & 
					     GTK_DIALOG_DESTROY_WITH_PARENT,
					     GTK_STOCK_CLOSE,GTK_RESPONSE_CLOSE,NULL);
    

     tabs = gtk_notebook_new();
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),tabs,TRUE,TRUE,0);
     gtk_container_set_border_width(GTK_CONTAINER(tabs),5);
     vbox = gtk_vbox_new(FALSE,5);
     gtk_notebook_append_page(GTK_NOTEBOOK(tabs),vbox,gtk_label_new(_("Interface")));
     tooltext_button = gtk_check_button_new_with_label(_("Show toolbar text labels"));
     gtk_box_pack_start(GTK_BOX(vbox),tooltext_button,FALSE,FALSE,5);
     startconnect_button = gtk_check_button_new_with_label(_("Try to connect to device on startup"));
     gtk_box_pack_start(GTK_BOX(vbox),startconnect_button,FALSE,FALSE,5);
     listload_button = gtk_check_button_new_with_label(_("Load default playlist on startup"));
     gtk_box_pack_start(GTK_BOX(vbox),listload_button,FALSE,FALSE,5);
     unplugexit_button = gtk_check_button_new_with_label(_("Exit program when device is unplugged\nrequires hotplug support (/sbin/hotplug)"));
     gtk_box_pack_start(GTK_BOX(vbox),unplugexit_button,FALSE,FALSE,5);

     vbox = gtk_table_new(3,7,FALSE); 
     gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
     gtk_notebook_append_page(GTK_NOTEBOOK(tabs),vbox,gtk_label_new(_("MP3 player")));
     label = gtk_label_new(_("Command to play mp3  (%f = selected filenames)"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,0,1,0,1);
     play_entry = gtk_entry_new();
     gtk_table_attach_defaults(GTK_TABLE(vbox),play_entry,0,2,1,2);
     gtk_table_attach_defaults(GTK_TABLE(vbox),gtk_hseparator_new(),0,2,2,3);
     label = gtk_label_new(_("Command to stop playing mp3"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,0,1,4,5);
     stop_entry = gtk_entry_new();
     gtk_table_attach_defaults(GTK_TABLE(vbox),stop_entry,0,2,5,6);
     
     vbox = gtk_vbox_new(FALSE,0);
     gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
     gtk_notebook_append_page(GTK_NOTEBOOK(tabs),vbox,gtk_label_new(_("Title")));
     customtitle_button = gtk_check_button_new_with_label(_("Use customized track title format"));
     gtk_box_pack_start(GTK_BOX(vbox),customtitle_button,FALSE,FALSE,0);
     frame = gtk_frame_new(_("Title format"));
     gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,5);
     vbox = gtk_table_new(3,6,FALSE);
     gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
     gtk_container_add(GTK_CONTAINER(frame),vbox);
     title_entry = gtk_entry_new();
     gtk_table_attach_defaults(GTK_TABLE(vbox),title_entry,0,2,0,1);
     label = gtk_label_new(_("%f  File name"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,0,1,1,2);
     label = gtk_label_new(_("%p  Performer/artist"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,0,1,2,3);
     label = gtk_label_new(_("%a  Album"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,0,1,3,4);
     label = gtk_label_new(_("%t  Track name"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,1,2,1,2);
     label = gtk_label_new(_("%c  Comment"));
     gtk_misc_set_alignment(GTK_MISC(label),0,1);
     gtk_table_attach_defaults(GTK_TABLE(vbox),label,1,2,2,3);
     g_signal_connect(customtitle_button,"toggled",G_CALLBACK(active_button_Toggled),frame);
     
     vbox = gtk_vbox_new(FALSE,0);
     gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
     gtk_notebook_append_page(GTK_NOTEBOOK(tabs),vbox,gtk_label_new(_("Advanced")));
     changeid_button = gtk_check_button_new_with_label(_("Specify vendor / product ID"));
     gtk_tooltips_set_tip(tooltips,changeid_button,"USE THIS AT YOUR OWN RISK!","");
     gtk_box_pack_start(GTK_BOX(vbox),changeid_button,FALSE,FALSE,0);
     frame2 = gtk_frame_new(_("Device ID"));
     gtk_box_pack_start(GTK_BOX(vbox),frame2,TRUE,TRUE,5);
     table = gtk_table_new(3,3,FALSE);
     gtk_container_set_border_width(GTK_CONTAINER(table),5);
     gtk_container_add(GTK_CONTAINER(frame2),table);
     label = gtk_label_new("Vendor ID");
     gtk_misc_set_alignment(GTK_MISC(label),.8,.5);
     gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,0,1);
     vendor_entry = gtk_entry_new_with_max_length(4);
     gtk_table_attach_defaults(GTK_TABLE(table),vendor_entry,1,2,0,1);
     label = gtk_label_new("Product ID");
     gtk_misc_set_alignment(GTK_MISC(label),.8,.5);
     gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,1,2);
     productid_entry = gtk_entry_new_with_max_length(4);
     gtk_table_attach_defaults(GTK_TABLE(table),productid_entry,1,2,1,2);
     hbox = gtk_hbox_new(FALSE,0);
     gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
     enablelogging_button = gtk_check_button_new_with_label(_("Enable logging"));
     gtk_box_pack_start(GTK_BOX(hbox),enablelogging_button,FALSE,FALSE,0);
     logsize_spin = gtk_spin_button_new_with_range(1,1000,10);
     gtk_tooltips_set_tip(tooltips,logsize_spin,"maximum number of bytes to log in each message","");
     gtk_spin_button_set_value(GTK_SPIN_BUTTON(logsize_spin),50);
     gtk_box_pack_start(GTK_BOX(hbox),logsize_spin,FALSE,FALSE,5);
     g_signal_connect(changeid_button,"toggled",G_CALLBACK(active_button_Toggled),frame2);
     g_signal_connect(enablelogging_button,"toggled",G_CALLBACK(active_button_Toggled),logsize_spin);


     c = cfg_Read("options","tool bar text","1");
     if (atoi(c))
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(tooltext_button),TRUE);
     c = cfg_Read("options","startup connect","1");
     if (atoi(c))
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(startconnect_button),TRUE);
     c = cfg_Read("options","startup load list","1");
     if (atoi(c))
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(listload_button),TRUE);

     c = cfg_Read("options","exit on unplugged","0");
     if (atoi(c))
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(unplugexit_button),TRUE);

     c = cfg_Read("options","mp3 play command","mpg123 %f");
     gtk_entry_set_text(GTK_ENTRY(play_entry),c);
     c = cfg_Read("options","mp3 stop command","killall mpg123");
     gtk_entry_set_text(GTK_ENTRY(stop_entry),c);

     c = cfg_Read("options","use custom titles","0");
     if (atoi(c)) {
         gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(customtitle_button),TRUE);
     } else {
         gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(customtitle_button),FALSE);
         active_button_Toggled((GtkToggleButton*)customtitle_button,(gpointer)frame);
     }
     c = cfg_Read("options","title format","%p - %t");
     gtk_entry_set_text(GTK_ENTRY(title_entry),c);

     c = cfg_Read("options","print debug info","0");
     if (atoi(c)) {
         gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enablelogging_button),TRUE);
         gtk_spin_button_set_value(GTK_SPIN_BUTTON(logsize_spin),atoi(c));
     } else {
         gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enablelogging_button),FALSE);
         active_button_Toggled((GtkToggleButton*)enablelogging_button,(gpointer)logsize_spin);
     }
 
    c = cfg_Read("options","user supplied id","0");
    if (atoi(c)) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(changeid_button),TRUE);
    } else {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(changeid_button),FALSE);
        active_button_Toggled((GtkToggleButton*)changeid_button,(gpointer)frame2);
    }

    gtk_entry_set_text(GTK_ENTRY(productid_entry),cfg_Read("options","supplied product id","0006"));
    gtk_entry_set_text(GTK_ENTRY(vendor_entry),cfg_Read("options","supplied vendor id","0a62"));

     gtk_window_resize(GTK_WINDOW(dialog),400,200); 
     gtk_dialog_set_has_separator (GTK_DIALOG(dialog),FALSE);
     gtk_container_foreach(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area),
			   ButtonRelief,(gpointer)GTK_RELIEF_NONE);

     gtk_widget_show_all(dialog);
     gtk_dialog_run(GTK_DIALOG(dialog));


     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(tooltext_button))) {
	 cfg_Write("options","tool bar text","1");
	 gtk_toolbar_set_style(GTK_TOOLBAR(MW_GET("left_toolbar")),
					   GTK_TOOLBAR_BOTH);
	 gtk_toolbar_set_style(GTK_TOOLBAR(MW_GET("right_toolbar")),
					   GTK_TOOLBAR_BOTH);

     }
     else {
	  cfg_Write("options","tool bar text","0");
	 gtk_toolbar_set_style(GTK_TOOLBAR(MW_GET("left_toolbar")),
					   GTK_TOOLBAR_ICONS);
	 gtk_toolbar_set_style(GTK_TOOLBAR(MW_GET("right_toolbar")),
				   GTK_TOOLBAR_ICONS);
     }

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(startconnect_button)))
	 cfg_Write("options","startup connect","1");
     else
	  cfg_Write("options","startup connect","0");

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(listload_button)))
	  cfg_Write("options","startup load list","1");
     else
	  cfg_Write("options","startup load list","0");

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(unplugexit_button)))
	  cfg_Write("options","exit on unplugged","1");
     else
	  cfg_Write("options","exit on unplugged","0");

     
     cfg_Write("options","mp3 play command",(gchar*)gtk_entry_get_text(GTK_ENTRY(play_entry)));

     cfg_Write("options","mp3 stop command",(gchar*)gtk_entry_get_text(GTK_ENTRY(stop_entry)));

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(customtitle_button)))
	  cfg_Write("options","use custom titles","1");
     else
	  cfg_Write("options","use custom titles","0");
    
     cfg_Write("options","title format",(gchar*)gtk_entry_get_text(GTK_ENTRY(title_entry)));

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(enablelogging_button))) {
         snprintf(convert,5,"%d",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(logsize_spin)));
         cfg_Write("options","print debug info",convert);
         mpl_PrintDebugInfo(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(logsize_spin)));
     }
     else {
         cfg_Write("options","print debug info","0");
         mpl_PrintDebugInfo(0);
     }

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(changeid_button))) {
         cfg_Write("options","user supplied id","1");
         cfg_Write("options","supplied vendor id", c = (gchar*)gtk_entry_get_text(GTK_ENTRY(vendor_entry)));
         cfg_Write("options","supplied product id",b = (gchar*)gtk_entry_get_text(GTK_ENTRY(productid_entry)));
         mpl_set_device_id(1,c,b);
     }
     else {
         cfg_Write("options","user supplied id","0");
         mpl_set_device_id(0,"0000","0000");
     }


     gtk_widget_destroy(dialog);


}

GtkWidget* da;
GdkPixbuf* buffer;

gint expose_cb (GtkWidget	  *widget,
		GdkEventExpose *event,
		gpointer	   data)
{
     GdkPixbuf* frame;
     guchar *pixels;
     int rowstride;

     (gpointer) frame = data;

     rowstride = gdk_pixbuf_get_rowstride (frame);
     pixels = gdk_pixbuf_get_pixels (frame) + rowstride * event->area.y + event->area.x * 4;
     
     gdk_draw_rgb_32_image_dithalign (widget->window,
				      widget->style->black_gc,
				      event->area.x, event->area.y,
				      event->area.width, event->area.height,
				      GDK_RGB_DITHER_NORMAL,
				      pixels, rowstride,
				      event->area.x, event->area.y);
     return TRUE;
}

gint timeout (gpointer data) {
     GdkPixbuf* frame;
     guchar *pixels;
     guchar *source;
     gint i,j;
     int rowstride;
     float para;
     static float  multiplier = 0.0;
     static unsigned char lcolor = 1;

     (gpointer) frame = data;

     rowstride = gdk_pixbuf_get_rowstride (frame);
     pixels = gdk_pixbuf_get_pixels(frame);
     source = gdk_pixbuf_get_pixels(buffer);

     para = 2.0f * ((multiplier - 0.4) * (multiplier - 0.4)) + 0.1;

     for(i=0;i<400;i++)
	  for(j=0;j<rowstride;j = j + lcolor)
	       pixels[i*rowstride + j] =  (source[i*rowstride + j] * para);

     multiplier = multiplier + 0.04;

//     printf("%f\n",multiplier);
     if (multiplier == 0.52f) {
         lcolor++;
         if (lcolor == 3) lcolor++;
         if (lcolor > 4) lcolor = 2;
     }

     if (multiplier > 1.0) {
         multiplier = 0.0;
     }

     gtk_widget_queue_draw (da);
     return TRUE;
}

guint timeout_id;

static void
cleanup_callback (GtkObject *object,
		  gpointer   data)
{
     GdkPixbuf* frame;

     g_source_remove (timeout_id);
  timeout_id = 0;
  
  (gpointer) frame = data;
  g_object_unref(frame);
  g_object_unref(buffer);
  gtk_widget_destroy(GTK_WIDGET(object));
}

void create_easteregg_window() {
     GtkWidget* window;
     GdkPixbuf* frame;
     GdkPixbuf* i;
     GtkWidget* vbox;

     i = MW_GET("mp_icon");
     window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
     gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
     gtk_widget_set_size_request (window, 400,400);
     frame = gdk_pixbuf_new (GDK_COLORSPACE_RGB, gdk_pixbuf_get_has_alpha(i)
			      , gdk_pixbuf_get_bits_per_sample(i) , 400,400);

     g_signal_connect (window, "destroy", G_CALLBACK (cleanup_callback), frame);
      
      buffer = gdk_pixbuf_scale_simple(i,400,400,GDK_INTERP_HYPER);
      da = gtk_drawing_area_new();
      g_signal_connect(da,"expose_event",G_CALLBACK(expose_cb),frame);

      vbox = gtk_vbox_new(FALSE,5);
      gtk_container_add (GTK_CONTAINER (window), vbox);
      gtk_box_pack_start(GTK_BOX(vbox),da,TRUE,TRUE,0);
      gtk_box_pack_start(GTK_BOX(vbox),gtk_label_new("mild7@users.sourceforge.net"),FALSE,FALSE,5);
      gtk_window_set_transient_for (GTK_WINDOW(window),GTK_WINDOW(MainWindow));
      gtk_window_set_title(GTK_WINDOW(window),_("Contgratulations you found an easter egg!"));

      timeout_id = gtk_timeout_add (50, timeout, frame);
      gtk_widget_show_all(window);
}

gboolean   image_button_event   (GtkWidget *widget,
                                            GdkEventButton *event,
				 gpointer user_data) {
     
     if (event->type == GDK_2BUTTON_PRESS) {
	       gtk_dialog_response(GTK_DIALOG(user_data),1);
	       create_easteregg_window();
	       return TRUE;
	  }

     return FALSE;
}

void unset_can_focus(GtkWidget* widget,gpointer data) {

	 g_object_set(widget,"can-focus",FALSE,NULL);
}

void create_about_window() {
     GtkWidget* window1;
     GtkWidget *image1;
     GtkWidget *label1;
     GtkWidget* hbox;
     GtkWidget* ebox;
     GtkWidget* scroller;
     GtkTextBuffer* textbuffer;
     GtkWidget* textview;
     GtkTextMark* mark;
     GtkTextIter end;
     GString* text = g_string_new("");

    window1 = gtk_dialog_new_with_buttons("Mplinuxman",MainWindow,
					  GTK_DIALOG_MODAL & 
					     GTK_DIALOG_DESTROY_WITH_PARENT,
					     GTK_STOCK_CLOSE,GTK_RESPONSE_OK,NULL);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_widget_show(hbox);
   	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window1)->vbox),hbox,FALSE,FALSE,5);
//    gtk_container_add (GTK_CONTAINER(GTK_DIALOG(window1)->vbox), hbox);
	//gtk_dialog_set_has_separator (GTK_DIALOG(window1),FALSE);
    gtk_container_set_border_width(GTK_CONTAINER(window1),5);
    gtk_window_set_default_size(GTK_WINDOW(window1),400,300);
    image1 = gtk_image_new_from_pixbuf(MW_GET("mp_icon"));
    gtk_misc_set_alignment(GTK_MISC(image1),0,0);
    ebox = gtk_event_box_new();
    gtk_container_add(GTK_CONTAINER(ebox),image1);
    g_signal_connect(ebox,"button-press-event",G_CALLBACK(image_button_event),window1);
    gtk_widget_show (image1);
    gtk_widget_show (ebox);
    gtk_box_pack_end(GTK_BOX(hbox),ebox,FALSE,FALSE,0);
    g_string_printf(text, "<span weight=\"bold\" size=\"larger\">Mplinuxman version %s</span>\n"
										,MP_VERSION);
    label1 = gtk_label_new("");
    gtk_label_set_markup(GTK_LABEL(label1), text->str);
    
    gtk_widget_show (label1);
    gtk_box_pack_start(GTK_BOX(hbox),label1,FALSE,FALSE,0);
    	
	scroller = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),
												  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroller),
															GTK_SHADOW_IN);												  
	textbuffer = gtk_text_buffer_new(NULL);
	gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer),"bold", "weight", 
											PANGO_WEIGHT_BOLD, NULL);
	gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer),"blue", "foreground", 
											"blue", NULL);

	gtk_text_buffer_get_iter_at_offset (GTK_TEXT_BUFFER(textbuffer), &end, -1);
												
	gtk_text_buffer_insert(GTK_TEXT_BUFFER(textbuffer), &end , "URL:   ",-1);
	gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "http://mplinuxman.sourceforge.net\n\n",-1, "blue" ,NULL);
	 gtk_text_buffer_insert(GTK_TEXT_BUFFER(textbuffer), &end , "Help:   ",-1);
	 gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "http://mplinuxman.sourceforge.net/index.php?page=2\n\n",-1, "blue" ,NULL);
	gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "Languages\n",-1, "bold" ,NULL);
	gtk_text_buffer_insert(GTK_TEXT_BUFFER(textbuffer), &end ,
	"If you would like to contribute a translation to your "
 	"native language, please email the translation file "
	"to me.\n\n",-1);
	gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "Credits\n",-1, "bold" ,NULL);
	gtk_text_buffer_insert(GTK_TEXT_BUFFER(textbuffer), &end ,
	"Written by Tim O'Brien  ",-1);
	gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "mild7@users.sourceforge.net\n\n",-1, "blue" ,NULL);
	gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "Testing and patches\n",-1, "bold" ,NULL);
	gtk_text_buffer_insert(GTK_TEXT_BUFFER(textbuffer), &end ,
	"Kazutaka Manabe\nChristian von Eichel-Streiber\n"
	"Tholom Kiely\nKris Meeusen\n\n",-1);
	gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER(textbuffer), &end,
	 "Translations\n",-1, "bold" ,NULL);
	gtk_text_buffer_insert(GTK_TEXT_BUFFER(textbuffer), &end ,
										"French		Thomas Jost\n"
										"Spanish		Marcos Mainar\n"
										"Dutch			Bosko Andjelkovic\n"
										"German		Thomas Ritter\n"
										"Japanese		Shimada Hirofumi\n",-1);
										
	textview = gtk_text_view_new_with_buffer(GTK_TEXT_BUFFER(textbuffer));
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview), GTK_WRAP_WORD);
//	gtk_text_view_set_right_margin(GTK_TEXT_VIEW(textview), 80);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(textview), FALSE);

	gtk_container_add(GTK_CONTAINER(scroller), textview);
	//gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window1)->vbox),gtk_hseparator_new(),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window1)->vbox),scroller,TRUE,TRUE,0);
    gtk_dialog_set_has_separator (GTK_DIALOG(window1),FALSE);
    gtk_container_foreach(GTK_CONTAINER(GTK_DIALOG(window1)->action_area),
			  ButtonRelief,(gpointer)GTK_RELIEF_NONE);
	gtk_container_foreach(GTK_CONTAINER(GTK_DIALOG(window1)->action_area),
			  unset_can_focus,(gpointer)NULL);
	
	gtk_widget_show_all(window1);
	
	gtk_text_buffer_get_iter_at_offset (GTK_TEXT_BUFFER(textbuffer), &end, 0);
	gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(textbuffer), &end);
	mark = gtk_text_buffer_create_mark(GTK_TEXT_BUFFER(textbuffer),"start_mark",
														 &end, FALSE);
	gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(textview), mark, 0, TRUE, 0, 0);	
	
    gtk_dialog_run(GTK_DIALOG(window1));
    gtk_widget_destroy(window1);
    g_string_free(text,TRUE);
}
