#include <stdio.h>
#include <sys/stat.h>
#include "mp3util.h"

/*
(15,12)Bitrate index
bits V1,L1 V1,L2 V1,L3 V2,L1 V2, L2 & L3
0000 free free free free free
0001 32 32 32 32 8
0010 64 48 40 48 16
0011 96 56 48 56 24
0100 128 64 56 64 32
0101 160 80 64 80 40
0110 192 96 80 96 48
0111 224 112 96 112 56
1000 256 128 112 128 64
1001 288 160 128 144 80
1010 320 192 160 160 96
1011 352 224 192 176 112
1100 384 256 224 192 128
1101 416 320 256 224 144
1110 448 384 320 256 160
1111 bad bad bad bad bad

NOTES: All values are in kbps

(11,10) Sampling rate frequency index (values are in Hz)
bits MPEG1 MPEG2 MPEG2.5
00 44100 22050 11025
01 48000 24000 12000
10 32000 16000 8000
11 reserv. reserv. reserv.

*/

     
const int mp1_3_bitrates[] = {-1,32000,40000,48000,56000,64000,80000,96000,112000,128000
		     ,160000,192000,224000,256000,320000,-1};
const int mp2_3_bitrates[] = {-1,8000,16000,24000,32000,40000,48000,56000,64000,80000,96000
                                     ,112000,128000,144000,160000,-1};

const int mp1_samplerates[] = {44100,48000,32000,-1};
const int mp2_samplerates[] = {22050,24000,16000,-1};


struct mp3_info Mp3Info;


void  killwhitespace(char* c) {
     while(*c == 32)
	  c--;
     c++;
     *c = '\0';     
}

int mp3_valid(char* filename) {
     FILE*fp = NULL;
     unsigned char buffer[129];
     unsigned char c;
     int nbytes;
     int i = 0;
     int bitrate = 0;
     int samplerate = 0;
     int pad = 0;
     int crc = 0;
     int version = 0;
     int layer = 0;
     int channels = 0;
     int cp = 0;
     int framelen;
     float temp;

     fp = fopen(filename,"r");
     if (!fp) goto error;
 
     nbytes = fread(buffer,1,4,fp);
     if (!nbytes) goto error;

     // skip over stupid windows riff
     if (strncmp(buffer,"RIFF",4 ) == 0) {
	  while (1) {
	       buffer[i] = fgetc(fp); 
	       if (feof(fp)) goto error;
	       if (strncmp(buffer,"data",i + 1) == 0) 
		    i++;
	       else
		    i = 0;
	       if (i ==4){
		    fseek(fp,4,SEEK_CUR);
		    break;
	       }
	  }
     } else fseek(fp,0,SEEK_SET);


     // find first frame
     do {
     c = 0;
     while (1) {
	  if (c == 0xff) {
	       c = fgetc(fp);
	       if (feof(fp)) goto error;
	       version = (c >> 3)  & 0x03;
	       layer = (c >> 1) & 0x03;
	       if ( (version > 1) && (layer == 1) && ((c & 0xe0) == 0xe0) )
		    break;
	  } 
	  else {
	       c = fgetc(fp);
	       if (feof(fp)) goto error;
	  }
     }

     crc = (c & 0x01);
     c = fgetc(fp);
     if (feof(fp)) goto error;
     
     if (version == 3) {
	  bitrate = mp1_3_bitrates[(c >> 4) & 0x0f];
	  samplerate = mp1_samplerates[(c >> 2) & 0x03];
	  pad = (c >> 1) & 0x01;
     }

     if (version == 2) {
	  bitrate = mp2_3_bitrates[(c >> 4) & 0x0f];
	  samplerate = mp2_samplerates[(c >> 2) & 0x03];
	  pad = (c >> 1) & 0x01;
     }

     c = fgetc(fp);
     channels = (c >> 6) & 0x03;
     cp = (c >> 3) & 0x01;

     } while  ((samplerate == -1) || (bitrate == -1));

     // calculate frame length and jump to next frame
     temp = (float) bitrate / (float) samplerate;
     framelen =  (144 * temp) + pad;
     if (version == 2)
	  framelen = framelen - 1;
     fseek(fp,framelen - 4,SEEK_CUR);
     if (version == 3) {
	  c = fgetc(fp);
	  if (feof(fp)) goto error;
     }
     // HACK: how do i calculate mpeg 2 frame lengths correctly?
     if (version == 2) 
	  for(i=0;i<3;i++) {
	       if ((c =fgetc(fp)) == 0xff)
		    break;
	       if (feof(fp)) goto error;
	  }

     if (c != 0xff) goto error;
     c = fgetc(fp);
     if (feof(fp)) goto error;
     if (  !(  (((c >> 3) & 0x03)  > 1)  &&  ( ((c >> 1) & 0x03) == 1)  &&  ((c & 0xe0) == 0xe0)  ) )
	  goto error;


     Mp3Info.samplerate = samplerate;
     Mp3Info.bitrate = bitrate;
     Mp3Info.version = 4 - version;
     Mp3Info.layer = 4 - layer;
     Mp3Info.channels = channels;
     Mp3Info.copyright = cp;

     // get id3 info

     fseek(fp,0,SEEK_END);
     Mp3Info.filesize = ftell(fp);
     fseek(fp,ftell(fp) - 2 * 1024,SEEK_SET);

     i = 0;
     while (1) {
	  buffer[i] = fgetc(fp); 
	  if (feof(fp)) break;
	  if (strncmp(buffer,"TAG",i + 1) == 0) 
	       i++;
	  else
	       i = 0;
	  if (i ==3)  break;
     }

     nbytes = fread(&buffer[3],1,125,fp);

     if ( (nbytes == 125) && (strncmp(buffer,"TAG",3) == 0)  ) {
	  char* c;
	  Mp3Info.hastag = 1;
	  strncpy(Mp3Info.title,&buffer[3],30);
	  strncpy(Mp3Info.artist,&buffer[33],30);
	  strncpy(Mp3Info.album,&buffer[63],30);
	  strncpy(Mp3Info.year,&buffer[93],4);
	  strncpy(Mp3Info.comment,&buffer[97],30);

	  killwhitespace(&Mp3Info.title[strlen(Mp3Info.title) -1]);
	  killwhitespace(&Mp3Info.artist[strlen(Mp3Info.artist) -1]);
	  killwhitespace(&Mp3Info.album[strlen(Mp3Info.album) -1]);
	  killwhitespace(&Mp3Info.comment[strlen(Mp3Info.comment) -1]);

	  Mp3Info.genre = buffer[127];
     } else 
	  Mp3Info.hastag = 0;
	  
     fclose(fp);
     return 1;
	       
error:
     Mp3Info.bitrate = -1;
     if (fp)
	  fclose(fp);
     return 0;
}

// mp3_get_tag , takes half the time of mp3_valid

#define CHECK_BLOCK 2048
#define BUFFER_POS (c - tag_buffer)
#define BUFFER_UNREAD ( (tag_buffer + nbytes) - c)
#define TAG_SIZE 128

int mp3_get_tag(char* filename) {
	FILE* fp;
	int nbytes;
	static char tag_buffer[CHECK_BLOCK];
	struct stat stat_s;
	unsigned int filesize;
	int i;
	char* c = tag_buffer;
	
	Mp3Info.bitrate = 1;
	
	stat(filename, &stat_s);
	filesize = stat_s.st_size;
	
     fp = fopen(filename,"r");
     if (!fp) goto error;

     Mp3Info.filesize = filesize;
     if (filesize < CHECK_BLOCK) 
     	fseek(fp, filesize, SEEK_SET);
     else
	     fseek(fp, filesize - CHECK_BLOCK, SEEK_SET);

	 nbytes = fread(tag_buffer, CHECK_BLOCK, 1, fp);

     i = 0;
     while (1) {
	  if (BUFFER_POS == nbytes) break;
  	  if (BUFFER_UNREAD < TAG_SIZE) break;
	  if (strncmp(c ,"TAG",i + 1) == 0) 
	       i++;
	  else {
	       i = 0;
	       c++;
	  }
	  if (i ==3)  break;
     }


     if ( (BUFFER_UNREAD >= TAG_SIZE) && (i == 3)  ) {
	  Mp3Info.hastag = 1;
	  strncpy(Mp3Info.title,&c[3],30);
	  strncpy(Mp3Info.artist,&c[33],30);
	  strncpy(Mp3Info.album,&c[63],30);
	  strncpy(Mp3Info.year,&c[93],4);
	  strncpy(Mp3Info.comment,&c[97],30);

	  killwhitespace(&Mp3Info.title[strlen(Mp3Info.title) -1]);
	  killwhitespace(&Mp3Info.artist[strlen(Mp3Info.artist) -1]);
	  killwhitespace(&Mp3Info.album[strlen(Mp3Info.album) -1]);
	  killwhitespace(&Mp3Info.comment[strlen(Mp3Info.comment) -1]);

	  Mp3Info.genre = c[127];
     } else 
	  Mp3Info.hastag = 0;
	 
	fclose(fp);
	return 1; 	
	
	error:
	Mp3Info.bitrate = -1;
	if (fp)
		fclose(fp);
	return 0;
}

struct mp3_info* mp3_get_info() {
     if (Mp3Info.bitrate != -1)
	  return &Mp3Info;
     else
	  return NULL;
}
