unit paramstrs;
   {$H+}
interface
uses prefs,define_types;
const
kVers = 'Chris Rorden''s dcm2nii :: '+kMRIcronvers;
{$Include ..\common\isgui.inc}
procedure ProcessParamStrs;
 procedure Testdcm2nii;
procedure RecursiveFolderSearch (lFolderName,lOutDir: string; var lPrefs: TPrefs; lDepth: integer);
implementation

uses
{$IFDEF GUI}gui, {$ENDIF}

{$IFNDEF UNIX}
    Windows,{$ENDIF}dialogsx, Classes,
  inifiles,SysUtils,convert,sortdicom,dicom,parconvert,filename,dicomtypes,
  nii_crop,nii_orient,nii_4dto3d,userdir;

procedure RecursiveFolderSearch (lFolderName,lOutDir: string; var lPrefs: TPrefs; lDepth: integer);
var
 lNewDir,lNewName,lFilename,lExt: String;
 lSearchRec: TSearchRec;
begin
 if (lPrefs.CollapseFolders) then begin //Convert all folders in single step...
    LoadFileList(lFolderName,lOutDir,lPrefs);
    exit;
 end;
 lNewDir := lFolderName+PathDelim;
{$IFDEF UNIX}
 if FindFirst(lNewDir+'*',faAnyFile-faSysFile,lSearchRec) = 0 then begin
{$ELSE}
 if FindFirst(lNewDir+'*.*',faAnyFile-faSysFile,lSearchRec) = 0 then begin
{$ENDIF}
    lFilename := '';
    repeat
      lNewName := lNewDir+lSearchRec.Name;
      if  (lSearchRec.Name <> '.') and (lSearchRec.Name <> '..') then begin
            if DirExists(lNewName) then begin
               if lDepth < lPrefs.RecursiveFolderDepth then begin
                  if (lDepth = 0) and (lPrefs.RecursiveUseNameAppend) then begin
                     lPrefs.NameAppend := extractfilename(lNewName)+'_';
                     Msg('recursive base folder '+lPrefs.NameAppend);
                  end;
                  RecursiveFolderSearch(lNewName,lOutDir,lPrefs,lDepth+1);
               end;
               //exit;//4/4/2008
            end else
                lFilename := lNewname;
      end;
    until (FindNext(lSearchRec) <> 0);
    if lFilename <> '' then begin
	      	lExt := UpCaseExt(lFilename);
                if (lExt = '.REC') or (lExt = '.PAR') then
			LoadFileListPARREC(lFilename,lOutDir,lPrefs)
		else begin
			Msg('recursive conversion '+lFilename);
                        LoadFileList(lFilename,lOutDir,lPrefs);
                end;
                //Msg('recursive conversion '+lPrefs.NameAppend);
                //if  (lPrefs.RecursiveUseNameAppend) then Msg('mx');
     end;
 end;
 FindClose(lSearchRec);
end;

function Bool2YN (lBool: boolean): char;
begin
	if lBool then
		result := 'Y'
	else
		result := 'N';
end;

procedure CharBool (lCh: char; var lBool: boolean);
begin
	if lCh = 'Y' then
		lBool := true;
	if lCh = 'N' then
		lBool := false;
end;

procedure ShowHelp (var lIniName: string; lPrefs: TPrefs);
begin
	 Msg('Either drag and drop or specify command line options:');
	 Msg('  '+FilenameWOExt(paramstr(0))+' <options> <sourcenames>');
	 Msg('OPTIONS:');
	 Msg('-a Anonymize [remove identifying information]: Y,N = '+Bool2YN(lPrefs.Anonymize));
	 Msg('-b load settings from specified inifile, e.g. ''-b C:\set\t1.ini''  ');
	 Msg('-c Collapse input folders: Y,N = '+Bool2YN(lPrefs.CollapseFolders));
	 Msg('-d Date in filename [filename.dcm -> 20061230122032.nii]: Y,N = '+Bool2YN(lPrefs.AppendDate));
	 Msg('-e events (series/acq) in filename [filename.dcm -> s002a003.nii]: Y,N = '+Bool2YN(lPrefs.AppendAcqSeries));
	 Msg('-f Source filename [e.g. filename.par -> filename.nii]: Y,N = '+Bool2YN(lPrefs.AppendFilename));
	 Msg('-g gzip output, filename.nii.gz [ignored if ''-n n'']: Y,N = '+Bool2YN(lPrefs.Gzip));
	 Msg('-i ID  in filename [filename.dcm -> johndoe.nii]: Y,N = '+Bool2YN(lPrefs.AppendPatientName));
	 Msg('-m manually prompt user to specify output format [NIfTI input only]: Y,N = '+Bool2YN(lPrefs.ManualNIfTIConv));
	 Msg('-n output .nii file [if no, create .hdr/.img pair]: Y,N = '+Bool2YN(lPrefs.SingleNIIFile));
	 Msg('-o Output Directory, e.g. ''C:\TEMP'' (if unspecified, source directory is used)');
	 Msg('-p Protocol in filename [filename.dcm -> TFE_T1.nii]: Y,N = '+Bool2YN(lPrefs.AppendProtocolName));
	 Msg('-r Reorient image to nearest orthogonal: Y,N ');
	 Msg('-s SPM2/Analyze not SPM5/NIfTI [ignored if ''-n y'']: Y,N = '+Bool2YN(lPrefs.SPM2));
         Msg('-v Convert every image in the directory: Y,N = '+Bool2YN(lPrefs.EveryFile));
         Msg('-x Reorient and crop 3D NIfTI images: Y,N = '+Bool2YN(lPrefs.Autocrop));
	 Msg('  You can also set defaults by editing '+lIniName);
{$IFDEF UNIX}
	 Msg('EXAMPLE: '+FilenameWOExt(paramstr(0))+' -a y /Users/Joe/Documents/dcm/IM_0116');
{$ELSE}
	 Msg('EXAMPLE: '+FilenameWOExt(paramstr(0))+' -a y -o C:\TEMP C:\DICOM\input1.par C:\input2.par');
	 Msg('Hit <Enter> to exit.');
	 MyReadLn;
{$ENDIF}
end; //proc ShowHelp

 procedure Testdcm2nii;
 var
   lIniName : string;
   lPrefs: TPrefs;
 begin
  lIniName := IniName;//DefaultsDir('')+ParseFileName(ExtractFilename(paramstr(0) ) )+'.ini';
     IniFile(True,lIniName, lPrefs);

     ModifyAnalyze('C:\4d\4d.nii', lPrefs)
 end;

procedure ProcessParamStrs;
var
   lDir,lStr,lOutDir,lExt: String;
   {$IFNDEF UNIX}lStartTime: DWord;{$ENDIF}
   lHelpShown,lAbort,lSilent: boolean;
   lCommandChar: Char;
   lPrefs: TPrefs;
   P,I: integer;
  lIniName : string;
begin
  if (ParamCount > 0) then
       ExitCode := 1;//assume error ... will be set to 0 on successful processing of any files...
  SetDefaultPrefs (lPrefs);
  DecimalSeparator := '.';
  lHelpShown := false;
  lAbort := false;
  lSilent := false;
  lIniName := IniName;//DefaultsDir('')+ParseFileName(ExtractFilename(paramstr(0) ) )+'.ini';
  if fileexists (lIniName) then
     IniFile(True,lIniName, lPrefs)
  else
      IniFile(True,changefileext(paramstr(0),'.init'), lPrefs); //this allows an administrator to create default startup
  lOutDir := '';
  //dcm2nii will open as default, dcm2niiz will default to gzip, dcm2nii3d will make 3d files..
  lStr := UpcaseStr(FilenameWOExt(paramstr(0)));
  I := length(lStr);
  if I > 1 then begin
	lCommandChar := lStr[I];
	if (lCommandChar = 'G') or (lCommandChar = 'R') then
		lPrefs.SingleNIIFile := false
	else if (lCommandChar = 'Z') then
		lPrefs.Gzip := true;
	for P := 1 to I do
		if lStr[P] in ['0'..'9'] then
			lCommandChar := lStr[P];
	if (lCommandChar = '3')  then
		lPrefs.FourD := false
  end;
  //now read filename
  lStr := paramstr(0);
  lStr := extractfilename(lStr);
  lStr := string(StrUpper(PChar(lStr))) ;
  if (ParamCount > 0) then begin
	I := 0;
	repeat
	 lStr := '';
	 repeat
		inc(I);
		if I = 1 then
			lStr := ParamStr(I)
		else begin
			if lStr <> '' then
			   lStr := lStr +' '+ ParamStr(I)
			else
				lStr := ParamStr(I);
		end;
		if (length(lStr)>1) and (lStr[1] = '-') and (ParamCount > I) then begin //special command
		   lCommandChar := UpCase(lStr[2]);
           inc(I);
           lStr := ParamStr(I);
		   {$IFDEF UNIX}
		   if (lCommandChar <> 'O') and (lCommandChar <> 'B') then begin
                      lStr := string(StrUpper(PChar(lStr))) ;  //do not upcase paths...
		   end;
		   {$ELSE}
		   lStr := string(StrUpper(PChar(lStr))) ;
		   {$ENDIF}
		   case lCommandChar of
				'4': CharBool(lStr[1],lPrefs.FourD);
				'A': CharBool(lStr[1],lPrefs.Anonymize);
                                'C': CharBool(lStr[1],lPrefs.CollapseFolders);
				'D': CharBool(lStr[1],lPrefs.AppendDate);
				'E': CharBool(lStr[1],lPrefs.AppendAcqSeries);
				'F': CharBool(lStr[1],lPrefs.AppendFilename);
				'G': CharBool(lStr[1],lPrefs.Gzip);
				'I': CharBool(lStr[1],lPrefs.AppendPatientName);
				'M': CharBool(lStr[1],lPrefs.ManualNIfTIConv);
				'N': CharBool(lStr[1],lPrefs.SingleNIIFile);
				'P': CharBool(lStr[1],lPrefs.AppendProtocolName);
                                'R': CharBool(lStr[1],lPrefs.enablereorient);
				'S': CharBool(lStr[1],lPrefs.SPM2);
				'V': CharBool(lStr[1],lPrefs.EveryFile);
                                'X': CharBool(lStr[1],lPrefs.Autocrop);
				'B': begin //load INI file
					  lIniName := lStr;
					  if fileexists(lIniName) then begin
                                                 IniFile(True,lIniName, lPrefs);
					 end else
		                             Msg('0 ERROR: unable to find '+lIniName);
                                     end;
				'O': begin //output directory
					  lOutDir := '';
					  if direxists(lStr) then begin
						 lOutDir := lStr;
						 if lOutDir[length(lOutDir)] <> pathdelim then
							lOutDir := lOutDir + pathdelim;
					  end;
					 end;
		   end; //case lStr[2]
		   lStr := '';
		end; //special command
	 until (I=ParamCount) or (fileexists(lStr)) or (lAbort);
	 if (not lPrefs.AppendPatientName) and (not lPrefs.AppendProtocolName) and (not lPrefs.AppendAcqSeries) and (not lPrefs.AppendDate) and (not lPrefs.AppendFilename) then begin
		 lPrefs.AppendPatientName := true;
		 lPrefs.AppendProtocolName :=  true;
	       	 lPrefs.AppendDate := true;
		 lPrefs.AppendAcqSeries := true;
	 end;
         if direxists(lStr) then begin
            RecursiveFolderSearch(lStr,lOutDir,lPrefs,0);
            lPrefs.NameAppend := '';
	 end else if fileexists(lStr) then begin
                lDir := ExtractFileDir(lStr);
                if lDir = '' then begin //since fileexists, file is in working directory
                  lDir := GetCurrentDir;
                  Msg('0 files in working directory '+lDir);
                  EnsureDirEndsWithPathDelim(lDir);
                  if fileexists(lDir + lStr) then
                     lStr := lDir+ lStr;
                end;
		lExt := UpCaseExt(lStr);
                if IsNiftiExt(lStr) then begin
{$IFDEF GUI}
        MainForm.ConvertDCM2NII(lStr,lPrefs);
        //Msg('Please drag and drop NIfTI images onto dcm2niigui to convert them')
{$ELSE}
  ModifyAnalyze(lStr,lPrefs);
{$ENDIF}
		end else if (lExt = '.REC') or (lExt = '.PAR') then begin
                    LoadFileListPARREC(lStr,lOutDir,lPrefs);
                    if lPrefs.everyfile then
                       exit;
		end else begin
                    {$IFNDEF UNIX}lStartTime := GetTickCount; {$ENDIF}
                    if  lPrefs.everyfile then 
                        LoadFileList(lStr,lOutDir,lPrefs)
                    else
                        LoadParamFileList(lStr,lOutDir,lPrefs,I);
                    {$IFNDEF UNIX}Msg('Time elapsed '+inttostr( GetTickCount-lStartTime)+'ms'); {$ENDIF}
                    exit; //only process a single file
                end;
	 end else if  not (lSilent) then begin
		Msg('0 '+paramstr(0)+' ERROR: unable to find '+lStr);
		if not lHelpShown then
			Showhelp(lIniName, lPrefs);
		lHelpShown := true;
	 end;
	until I >= ParamCount;
  end else begin //no parameters passed - show help
	  ShowHelp(lIniName, lPrefs);
          IniFile(False,lIniName, lPrefs);//ensure latest version of preferences file is created...
  end;//param count > 0
end;

end.
 
