/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef _DSCENEVIEWERMAIN_H
#define _DSCENEVIEWERMAIN_H

#include <wx/menu.h>
#include <wx/toolbar.h>
#include <wx/frame.h>
#include <wx/timer.h>
#include <wx/statusbr.h>
#include <wx/msgdlg.h>
#include <wx/artprov.h>
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>



class CMyGLCanvas;


#define SCENEVIEWER_VERSION  "1.1"

class _DSceneViewerFrame: public wxFrame
{
	friend class CMyGLCanvas;

    public:

        _DSceneViewerFrame(wxWindow* parent,wxWindowID id = -1);
        virtual ~_DSceneViewerFrame();

    private:

        //(*Handlers(_DSceneViewerFrame)
        void OnQuit(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnNewScene(wxCommandEvent& event);
        void OnOpenFile(wxCommandEvent& event);
        void OntimLoadFileCmdLineTrigger(wxTimerEvent& event);
        void OnbtnAutoplayClicked(wxCommandEvent& event);
        void OnMenuBackColor(wxCommandEvent& event);
        void OnMenuOptions(wxCommandEvent& event);
        void OnPrevious(wxCommandEvent& event);
        void OnNext(wxCommandEvent& event);
        void OnClose(wxCloseEvent& event);
        void OnBtnRecordClicked(wxCommandEvent& event);
        void OnbtnOrthoClicked(wxCommandEvent& event);
        void OnReload(wxCommandEvent& event);
        void OnInsert3DS(wxCommandEvent& event);
        void OnMenuSave(wxCommandEvent& event);
        void OnChangeCameraPose(wxCommandEvent& event);
        void OnTravellingTrigger(wxTimerEvent& event);
        void OnStartCameraTravelling(wxCommandEvent& event);
        void OnClose1(wxCloseEvent& event);
        void OnMenuAddSICK(wxCommandEvent& event);
        void OnMenuDeleteAll(wxCommandEvent& event);
        void OnMenuItem14Selected(wxCommandEvent& event);
        //*)

		void OntimAutoplay(wxTimerEvent& event);

        //(*Identifiers(_DSceneViewerFrame)
        static const long ID_MENUITEM1;
        static const long ID_MENUITEM2;
        static const long ID_MENUITEM5;
        static const long ID_MENUITEM7;
        static const long ID_MENUITEM12;
        static const long idMenuQuit;
        static const long ID_MENUITEM4;
        static const long ID_MENUITEM3;
        static const long ID_MENUITEM11;
        static const long ID_MENUITEM9;
        static const long ID_MENUITEM8;
        static const long ID_MENUITEM6;
        static const long ID_MENUITEM10;
        static const long idMenuAbout;
        static const long ID_STATUSBAR1;
        static const long ID_TOOLBARITEM7;
        static const long ID_TOOLBARITEM1;
        static const long ID_TOOLBARITEM5;
        static const long ID_TOOLBARITEM6;
        static const long ID_TOOLBARITEM11;
        static const long ID_TOOLBARITEM2;
        static const long ID_TOOLBARITEM10;
        static const long ID_TOOLBARITEM8;
        static const long ID_TOOLBARITEM9;
        static const long ID_TOOLBARITEM3;
        static const long ID_TOOLBARITEM4;
        static const long ID_TOOLBAR1;
        static const long ID_TIMER1;
        //*)

        static const long ID_TRAVELLING_TIMER;
        static const long ID_TIMER_AUTOPLAY;

        //(*Declarations(_DSceneViewerFrame)
        wxMenu* MenuItem11;
        wxToolBarToolBase* ToolBarItem5;
        wxStatusBar* StatusBar1;
        wxToolBarToolBase* ToolBarItem11;
        wxToolBarToolBase* ToolBarItem6;
        wxMenu* Menu3;
        wxToolBarToolBase* btnAutoplay;
        wxTimer timLoadFileCmdLine;
        wxToolBarToolBase* ToolBarItem2;
        wxMenuItem* MenuItem9;
        wxToolBarToolBase* ToolBarItem10;
        wxToolBarToolBase* btnOrtho;
        wxToolBar* ToolBar1;
        wxToolBarToolBase* ToolBarItem4;
        wxMenuItem* MenuItem5;
        wxToolBarToolBase* ToolBarItem1;
        wxMenuItem* MenuItem10;
        wxToolBarToolBase* btnRecord;
        wxToolBarToolBase* ToolBarItem3;
        wxMenuItem* MenuItem6;
        wxMenuItem* MenuItem7;
        wxMenuItem* MenuItem8;
        wxMenuItem* MenuItem14;
        //*)

		CMyGLCanvas	*m_canvas;
		wxTimer		*m_autoplayTimer;
        wxTimer 	m_tTravelling;

		int m_nTicksNumber;
		double m_nCurrentAzimuth;
		int maxv;
		void loadFromFile( const std::string &fil, bool isInASequence = false );
		void updateTitle();

        DECLARE_EVENT_TABLE()
};

#ifdef wxUSE_UNICODE
#define _U(x) wxString((x),wxConvUTF8)
#define _UU(x,y) wxString((x),y)
#else
#define _U(x) (x)
#define _UU(x,y) (x)
#endif

#endif // _DSCENEVIEWERMAIN_H
