/***************************************************************
 * Name:      gridmapSimulApp.cpp
 * Purpose:   Code for Application Class
 * Author:    Jose-Luis Blanco (jlblanco@ctima.uma.es)
 * Created:   2008-06-04
 * Copyright: Jose-Luis Blanco ()
 * License:
 **************************************************************/

#include "gridmapSimulApp.h"

//(*AppHeaders
#include "gridmapSimulMain.h"
#include <wx/image.h>
//*)
#include <wx/stdpaths.h>
#include <wx/log.h>


IMPLEMENT_APP(gridmapSimulApp)

#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::slam;
using namespace mrpt::opengl;
using namespace mrpt::system;
using namespace mrpt::math;
using namespace mrpt::utils;
using namespace std;


// This is to avoid a warning due to a conflict btw wxWidgets and opencv 1.1.0
//   http://article.gmane.org/gmane.comp.lib.opencv/24516
bool gridmapSimulApp::Initialize( int& argc, wxChar **argv )
{
	bool res(false);

	{
		wxLogNull logNo;
		res = wxApp::Initialize( argc, argv );
	}

	return res;
}


bool gridmapSimulApp::OnInit()
{
/*    // Process cmd line arguments (for the case of opening a file):
    if (argc>1)
        global_fileToOpen = wxString(wxApp::argv[1]).mb_str();
*/

    //(*AppInitialize
    bool wxsOK = true;
    wxInitAllImageHandlers();
    if ( wxsOK )
    {
    	gridmapSimulFrame* Frame = new gridmapSimulFrame(0);
    	Frame->Show();
    	SetTopWindow(Frame);
    }
    //*)
    return wxsOK;

}

int gridmapSimulApp::OnExit()
{
    return 0;
}
