/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef opengl_CCylinder_H
#define opengl_CCylinder_H

#include <mrpt/opengl/CRenderizable.h>

namespace mrpt	{
namespace opengl	{
	class MRPTDLLIMPEXP CCylinder;
	// This must be added to any CSerializable derived class:
	DEFINE_SERIALIZABLE_PRE_CUSTOM_BASE(CCylinder,CRenderizable)
	/** A cylinder or cone whose base lies in the XY plane.
	  * \sa opengl::COpenGLScene
	  */
	class MRPTDLLIMPEXP CCylinder:public CRenderizable	{
		DEFINE_SERIALIZABLE(CCylinder)
	protected:
		float mBaseRadius,mTopRadius,mHeight;
		uint32_t mSlices,mStacks;
		bool mHasTopBase,mHasBottomBase;
	public:
		static CCylinderPtr Create(const float baseRadius=1,const float topRadius=1,const float height=1,const int slices=10,const int stacks=10)	{
			return CCylinderPtr(new CCylinder(baseRadius,topRadius,height,slices,stacks));
		}
		static CCylinderPtr Create(const float radius=1,const float height=1,const int slices=10,const int stacks=10)	{
			return CCylinderPtr(new CCylinder(radius,radius,height,slices,stacks));
		}
		/** Render
		  */
		void render() const;
		virtual bool traceRay(const mrpt::poses::CPose3D &o,float &dist) const;
		inline void setHasBases(bool top=true,bool bottom=true)	{
			mHasTopBase=top;
			mHasBottomBase=bottom;
		}
		inline bool hasTopBase() const	{
			return mHasTopBase;
		}
		inline bool hasBottomBase() const	{
			return mHasBottomBase;
		}
		inline void setRadius(float radius)	{
			mBaseRadius=mTopRadius=radius;
		}
		inline void setRadii(float bottom,float top)	{
			mBaseRadius=bottom;
			mTopRadius=top;
		}
		inline void setHeight(float height)	{
			mHeight=height;
		}
		inline float getBottomRadius() const	{
			return mBaseRadius;
		}
		inline float getTopRadius() const	{
			return mTopRadius;
		}
		inline float getHeight() const	{
			return mHeight;
		}
		inline void setSlicesCount(uint32_t slices)	{
			mSlices=slices;
		}
		inline void setStacksCount(uint32_t stacks)	{
			mStacks=stacks;
		}
		inline uint32_t getSlicesCount() const	{
			return mSlices;
		}
		inline uint32_t getStacksCount() const	{
			return mStacks;
		}
	private:
		CCylinder():mBaseRadius(1),mTopRadius(1),mHeight(1),mSlices(10),mStacks(10),mHasTopBase(true),mHasBottomBase(true)	{};
		CCylinder(const float baseRadius,const float topRadius,const float height,const int slices,const int stacks):mBaseRadius(baseRadius),mTopRadius(topRadius),mHeight(height),mSlices(slices),mStacks(stacks),mHasTopBase(true),mHasBottomBase(true)	{};
		virtual ~CCylinder() {};
	};
}
}
#endif
