;  Robot parameter file

Section General settings
Class Pioneer            ; general type of robot
Subclass pionat          ; specific type of robot
RobotRadius 330          ; radius in mm
RobotDiagonal 120        ; half-height to diagonal of octagon
RobotWidth 400           ; width in mm
RobotLength 500          ; length in mm of the whole robot
RobotLengthFront 0       ; length in mm to the front of the robot (if this is 0
                         ; (or non existant) this value will be set to half of
                         ; RobotLength)
RobotLengthRear 0        ; length in mm to the rear of the robot (if this is 0
                         ; (or non existant) this value will be set to half of
                         ; RobotLength)
Holonomic true           ; turns in own radius
MaxRVelocity 100         ; absolute maximum degrees / sec
MaxVelocity 500          ; absolute maximum mm / sec
HasMoveCommand false     ; has built in move command
RequestIOPackets false   ; automatically request IO packets
RequestEncoderPackets false ; automatically request encoder packets
SwitchToBaudRate 0       ; switch to this baud if non-0 and supported on robot

Section Conversion factors
AngleConvFactor 0.0061359 ; radians per angular unit (2PI/4096)
DistConvFactor 0.07      ; multiplier to mm from robot units
VelConvFactor 2.5332     ; multiplier to mm/sec from robot units
RangeConvFactor 0.1734   ; multiplier to mm from sonar units
DiffConvFactor 0.00333333 ; ratio of angular velocity to wheel velocity (unused
                         ; in newer firmware that calculates and returns this)
Vel2Divisor 4            ; divisor for VEL2 commands
GyroScaler 1.626         ; Scaling factor for gyro readings

Section Accessories the robot has
TableSensingIR false     ; if robot has upwards facing table sensing IR
NewTableSensingIR false  ; if table sensing IR are sent in IO packet
FrontBumpers false       ; if robot has a front bump ring
NumFrontBumpers 0        ; number of front bumpers on the robot
RearBumpers false        ; if the robot has a rear bump ring
NumRearBumpers 0         ; number of rear bumpers on the robot

Section IR parameters
IRNum 0                  ; number of IRs on the robot
;  IRUnit <IR Number> <IR Type> <Persistance, cycles> <x position, mm> <y
;  position, mm>

Section Sonar parameters
SonarNum 7               ; number of sonar on the robot
;  SonarUnit <sonarNumber> <x position, mm> <y position, mm> <heading of disc,
;  degrees>
SonarUnit 0 100 100 90
SonarUnit 1 120 80 30
SonarUnit 2 130 40 15
SonarUnit 3 130 0 0
SonarUnit 4 130 -40 -15
SonarUnit 5 120 -80 -30
SonarUnit 6 100 -100 -90

Section Laser parameters
LaserPossessed false     ; if there is a laser on the robot
LaserPort                ; port the laser is on
LaserFlipped false       ; if the laser is upside-down or not
LaserPowerControlled true ; if the power to the laser is controlled by serial
LaserX 0                 ; x location of laser, mm
LaserY 0                 ; y location of laser, mm
LaserTh 0                ; rotation of laser, deg
LaserIgnore              ; Readings within a degree of the listed degrees
                         ; (separated by a space) will be ignored

Section Movement control parameters
;  if these are 0 the parameters from robot flash will be used, otherwise these
;  values will be used
SettableVelMaxes true    ; if TransVelMax and RotVelMax can be set
TransVelMax 400          ; maximum desired translational velocity for the robot
RotVelMax 100            ; maximum desired rotational velocity for the robot
SettableAccsDecs false   ; if the accel and decel parameters can be set
TransAccel 0             ; translational acceleration
TransDecel 0             ; translational deceleration
RotAccel 0               ; rotational acceleration
RotDecel 0               ; rotational deceleration
