//=============================================================================
//  MusE Score
//  Linux Music Score Editor
//  $Id: bsymbol.h 1840 2009-05-20 11:57:51Z wschweer $
//
//  Copyright (C) 2002-2009 Werner Schweer and others
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=============================================================================

#ifndef __BSYMBOL_H__
#define __BSYMBOL_H__

#include "element.h"

//---------------------------------------------------------
//   BSymbol
//    base class for Symbol and Image
//---------------------------------------------------------

class BSymbol : public Element {
      QList<Element*> _leafs;

   public:
      BSymbol(Score* s) : Element(s) {}
      BSymbol(const BSymbol&);

      BSymbol &operator=(const BSymbol&);

      virtual void add(Element*);
      virtual void remove(Element*);
      virtual void collectElements(QList<const Element*>& el) const;
      virtual bool acceptDrop(Viewer*, const QPointF&, int, int) const;
      virtual Element* drop(const QPointF&, const QPointF&, Element*);
      virtual void layout();
      virtual QRectF drag(const QPointF& pos);
      virtual bool isMovable() const { return true; }

      const QList<Element*>& getLeafs() const { return _leafs; }
      };

#endif

