{ MSEgui Copyright (c) 1999-2008 by Martin Schreiber

    See the file COPYING.MSE, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}
unit msegraphutils;
{$ifdef FPC}{$mode objfpc}{$h+}{$endif}
interface
uses
 msetypes,msestrings,mseerr;
 
const
 redmask = $ff0000;
 redshift = 16;
 greenmask = $00ff00;
 greenshift = 8;
 bluemask = $0000ff;
 blueshift = 0;
 
type
 pixelty = cardinal;

 colorty = type longword;
 pcolorty = ^colorty;
 colorarty = array of colorty;
 
 rgbtriplety = packed record
  blue: byte;
  green: byte;
  red: byte;
  res: byte;
 end;
 prgbtriplety = ^rgbtriplety;
 rgbtripleaty = array[0..0] of rgbtriplety;
 prgbtripleaty = ^rgbtripleaty;

 colormapsty = (cm_rgb,cm_functional,cm_mapped,cm_namedrgb,cm_user);
 colormapty = array[colormapsty] of cardinalarty;
 
 colorinfoty = record
                name: string;
                rgb: rgbtriplety;
               end;
 pcolorinfoty = ^colorinfoty;
 colorinfoarty = array of colorinfoty;
 
const
 speccolormask =         $f0000000;
 speccolorshift = 28;
 cl_functional = colorty($80000000);
 cl_mapped =     colorty($90000000);
 cl_namedrgb =   colorty($a0000000);
 cl_user =       colorty($b0000000);

 cl_invalid =                cl_functional + 0; 
                 //can not be used as default value
 cl_default =                cl_functional + 1;
 cl_parent =                 cl_functional + 2;
 cl_transparent =            cl_functional + 3;
 cl_brush =                  cl_functional + 4;
 cl_brushcanvas =            cl_functional + 5;
 cl_none =                   cl_functional + 6; cl_nonenum = 6;
 cl_font =                   cl_functional + 7; //use color of current font
 cl_lastfunctional =         cl_functional + 8;

 cl_dkshadow =               cl_mapped + 0;
 cl_shadow =                 cl_mapped + 1;
 cl_mid =                    cl_mapped + 2;
 cl_light =                  cl_mapped + 3;
 cl_highlight =              cl_mapped + 4;
 cl_background =             cl_mapped + 5;
 cl_foreground =             cl_mapped + 6;
 cl_active =                 cl_mapped + 7;
 cl_noedit =                 cl_mapped + 8;
 cl_text =                   cl_mapped + 9;
 cl_selectedtext =           cl_mapped + 10;
 cl_selectedtextbackground = cl_mapped + 11;
 cl_infobackground =         cl_mapped + 12;
 cl_glyph =                  cl_mapped + 13;
 cl_activegrip =             cl_mapped + 14;
 cl_lastmapped =             cl_mapped + 15;

 cl_0 =                      cl_namedrgb + 0; //select colorbackground for monochrome bitmaps
 cl_1 =                      cl_namedrgb + 1; //select colorforeground
 cl_black =                  cl_namedrgb + 2;
 cl_dkgray =                 cl_namedrgb + 3;
 cl_gray =                   cl_namedrgb + 4;
 cl_ltgray =                 cl_namedrgb + 5;
 cl_white =                  cl_namedrgb + 6;

 cl_red =                    cl_namedrgb + 7;
 cl_green =                  cl_namedrgb + 8;
 cl_blue =                   cl_namedrgb + 9;
 cl_cyan =                   cl_namedrgb + 10;
 cl_magenta =                cl_namedrgb + 11;
 cl_yellow =                 cl_namedrgb + 12;

 cl_dkred =                  cl_namedrgb + 13;
 cl_dkgreen =                cl_namedrgb + 14;
 cl_dkblue =                 cl_namedrgb + 15;
 cl_dkcyan =                 cl_namedrgb + 16;
 cl_dkmagenta =              cl_namedrgb + 17;
 cl_dkyellow =               cl_namedrgb + 18;

 cl_ltred =                  cl_namedrgb + 19;
 cl_ltgreen =                cl_namedrgb + 20;
 cl_ltblue =                 cl_namedrgb + 21;
 cl_ltcyan =                 cl_namedrgb + 22;
 cl_ltmagenta =              cl_namedrgb + 23;
 cl_ltyellow =               cl_namedrgb + 24;

 cl_lastnamedrgb =           cl_namedrgb + 25;
 
 cl_user0 =                  cl_user     + 0;
 cl_user1 =                  cl_user     + 1;
 cl_user2 =                  cl_user     + 2;
 cl_user3 =                  cl_user     + 3;
 cl_user4 =                  cl_user     + 4;
 cl_user5 =                  cl_user     + 5;
 cl_user6 =                  cl_user     + 6;
 cl_user7 =                  cl_user     + 7;
 cl_user8 =                  cl_user     + 8;
 cl_user9 =                  cl_user     + 9;
 cl_user10 =                 cl_user     + 10;
 cl_user11 =                 cl_user     + 11;
 cl_user12 =                 cl_user     + 12;
 cl_user13 =                 cl_user     + 13;
 cl_user14 =                 cl_user     + 14;
 cl_user15 =                 cl_user     + 15;
 cl_user16 =                 cl_user     + 16;
 cl_user17 =                 cl_user     + 17;
 cl_user18 =                 cl_user     + 18;
 cl_user19 =                 cl_user     + 19;
 
 cl_lastuser =               cl_user     + 20;

 functionalcolorcount = integer(cl_lastfunctional)-integer(cl_functional);
 mappedcolorcount = integer(cl_lastmapped)-integer(cl_mapped);
 namedrgbcolorcount = integer(cl_lastnamedrgb)-integer(cl_namedrgb);
 usercolorcount = integer(cl_lastuser)-integer(cl_user);
 mapcolorcounts: array[colormapsty] of integer = (
              0,
              functionalcolorcount,
              mappedcolorcount,
              namedrgbcolorcount,
              usercolorcount
            );

 defaultfunctional: array[0..functionalcolorcount-1]
                     of colorinfoty =
   (
    (name: 'cl_invalid';  rgb:               (blue: $00; green: $00; red: $00; res: $00)), //0
    (name: 'cl_default'; rgb:                (blue: $00; green: $00; red: $00; res: $00)), //1
    (name: 'cl_parent';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //2
    (name: 'cl_transparent'; rgb:            (blue: $00; green: $00; red: $00; res: $00)), //3
    (name: 'cl_brush';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //4
    (name: 'cl_brushcanvas'; rgb:            (blue: $00; green: $00; red: $00; res: $00)), //5
    (name: 'cl_none';  rgb:                  (blue: $00; green: $00; red: $00; res: $00)), //6
    (name: 'cl_font';  rgb:                  (blue: $00; green: $00; red: $00; res: $00))  //7
//    (name: 'cl_mask'; rgb:                   (blue: $00; green: $00; red: $00; res: $00))
//    (name: 'cl_grayed'; rgb:                 (blue: $80; green: $80; red: $80; res: $00))
   );

 defaultmapped: array[0..mappedcolorcount-1]
                     of colorinfoty =
   (
    (name: 'cl_dkshadow'; rgb:               (blue: $00; green: $00; red: $00; res: $00)), //0
    (name: 'cl_shadow'; rgb:                 (blue: $80; green: $80; red: $80; res: $00)), //1
    (name: 'cl_mid'; rgb:                    (blue: $c0; green: $c0; red: $c0; res: $00)), //2
    (name: 'cl_light'; rgb:                  (blue: $e0; green: $e0; red: $e0; res: $00)), //3
    (name: 'cl_highlight'; rgb:              (blue: $ff; green: $ff; red: $ff; res: $00)), //4
    (name: 'cl_background';  rgb:            (blue: $d0; green: $d0; red: $d0; res: $00)), //5
    (name: 'cl_foreground';  rgb:            (blue: $ff; green: $ff; red: $ff; res: $00)), //6
    (name: 'cl_active';  rgb:                (blue: $e0; green: $e0; red: $e0; res: $00)), //7
    (name: 'cl_noedit';  rgb:                (blue: $e0; green: $e0; red: $e0; res: $00)), //8
                                //canvas defaultcolors
    (name: 'cl_text';  rgb:                  (blue: $00; green: $00; red: $00; res: $00)), //9
    (name: 'cl_selectedtext'; rgb:           (blue: $ff; green: $ff; red: $ff; res: $00)), //10
    (name: 'cl_selectedtextbackground'; rgb: (blue: $c0; green: $00; red: $00; res: $00)), //11
    (name: 'cl_infobackground'; rgb:         (blue: $e0; green: $ff; red: $ff; res: $00)), //12
    (name: 'cl_glyph'; rgb:                  (blue: $00; green: $00; red: $00; res: $00)), //13
    (name: 'cl_activegrip'; rgb:             (blue: $90; green: $20; red: $20; res: $00))  //14
   );

 defaultnamedrgb: array[0..namedrgbcolorcount-1]
                     of colorinfoty =
   (
    (name: 'cl_0';  rgb:                     (blue: $00; green: $00; red: $00; res: $00)), //0
    (name: 'cl_1';  rgb:                     (blue: $ff; green: $ff; red: $ff; res: $00)), //1

    (name: 'cl_black'; rgb:                  (blue: $00; green: $00; red: $00; res: $00)), //2
    (name: 'cl_dkgray';  rgb:                (blue: $80; green: $80; red: $80; res: $00)), //3
    (name: 'cl_gray';  rgb:                  (blue: $c0; green: $c0; red: $c0; res: $00)), //4
    (name: 'cl_ltgray';  rgb:                (blue: $e0; green: $e0; red: $e0; res: $00)), //5
    (name: 'cl_white';  rgb:                 (blue: $ff; green: $ff; red: $ff; res: $00)), //6

    (name: 'cl_red';   rgb:                  (blue: $00; green: $00; red: $ff; res: $00)), //7
    (name: 'cl_green'; rgb:                  (blue: $00; green: $ff; red: $00; res: $00)), //8
    (name: 'cl_blue';  rgb:                  (blue: $ff; green: $00; red: $00; res: $00)), //9
    (name: 'cl_cyan';  rgb:                  (blue: $ff; green: $ff; red: $00; res: $00)), //10
    (name: 'cl_magenta';  rgb:               (blue: $ff; green: $00; red: $ff; res: $00)), //11
    (name: 'cl_yellow';  rgb:                (blue: $00; green: $ff; red: $ff; res: $00)), //12

    (name: 'cl_dkred';   rgb:                (blue: $00; green: $00; red: $c0; res: $00)), //13
    (name: 'cl_dkgreen'; rgb:                (blue: $00; green: $c0; red: $00; res: $00)), //14
    (name: 'cl_dkblue';  rgb:                (blue: $c0; green: $00; red: $00; res: $00)), //15
    (name: 'cl_dkcyan';  rgb:                (blue: $80; green: $80; red: $00; res: $00)), //16
    (name: 'cl_dkmagenta';  rgb:             (blue: $80; green: $00; red: $80; res: $00)), //17
    (name: 'cl_dkyellow';  rgb:              (blue: $00; green: $80; red: $80; res: $00)), //18

    (name: 'cl_ltred';   rgb:                (blue: $a0; green: $a0; red: $ff; res: $00)), //19
    (name: 'cl_ltgreen'; rgb:                (blue: $a0; green: $ff; red: $a0; res: $00)), //20
    (name: 'cl_ltblue';  rgb:                (blue: $ff; green: $a0; red: $a0; res: $00)), //21
    (name: 'cl_ltcyan';  rgb:                (blue: $ff; green: $ff; red: $a0; res: $00)), //22
    (name: 'cl_ltmagenta';  rgb:             (blue: $ff; green: $a0; red: $ff; res: $00)), //23
    (name: 'cl_ltyellow';  rgb:              (blue: $a0; green: $ff; red: $ff; res: $00))  //24
   );

 defaultuser: array[0..usercolorcount-1]
                     of colorinfoty =
   (
    (name: 'cl_user0';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //0
    (name: 'cl_user1';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //1
    (name: 'cl_user2';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //2
    (name: 'cl_user3';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //3
    (name: 'cl_user4';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //4
    (name: 'cl_user5';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //5
    (name: 'cl_user6';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //6
    (name: 'cl_user7';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //7
    (name: 'cl_user8';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //8
    (name: 'cl_user9';  rgb:                 (blue: $00; green: $00; red: $00; res: $00)), //9
    (name: 'cl_user10';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //10
    (name: 'cl_user11';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //11
    (name: 'cl_user12';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //12
    (name: 'cl_user13';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //13
    (name: 'cl_user14';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //14
    (name: 'cl_user15';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //15
    (name: 'cl_user16';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //16
    (name: 'cl_user17';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //17
    (name: 'cl_user18';  rgb:                (blue: $00; green: $00; red: $00; res: $00)), //18
    (name: 'cl_user19';  rgb:                (blue: $00; green: $00; red: $00; res: $00))  //19
   );
   
type
 graphicdirectionty = (gd_right,gd_up,gd_left,gd_down,gd_none);
 graphicdirectionsty = set of graphicdirectionty;
 
 fontstylety = (fs_bold,fs_italic,fs_underline,fs_strikeout,fs_selected);
                      //order fix
 fontstylesty = set of fontstylety;

 pointty = record
            x,y: integer;
           end;
 ppointty = ^pointty;
 pointarty = array of pointty;
 ppointarty = ^pointarty;
 pointaty = array[0..0] of pointty;
 ppointaty = ^pointaty;

 segmentty = record a,b: pointty end;
 segmentarty = array of segmentty;

 graphicvectorty = record
  start: pointty;
  direction: graphicdirectionty;
  length: integer;
 end;

 sizety = record
            cx,cy: integer;
          end;

 rectty = record
           case integer of
            0: (x,y,cx,cy: integer);
            1: (pos: pointty; size: sizety);
          end;
 framety = record
            case integer of
             0: (left,top,right,bottom: integer);
             1: (topleft,bottomright: sizety);
           end;
 pframety = ^framety;
 prectty = ^rectty;
 rectarty = array of rectty;
 prectarty = ^rectarty;

const
 nullpoint: pointty = (x: 0; y: 0);
 nullsize: sizety = (cx: 0; cy: 0);
 nullrect: rectty = (x: 0; y: 0; cx: 0; cy: 0);
 nullframe: framety = (left: 0; top: 0; right: 0; bottom: 0);
 minimalframe: framety = (left: 1; top: 1; right: 1; bottom: 1);

type
 gdierrorty = (gde_ok,
               gde_invalidgc,
               gde_notruecolor,
               gde_invalidcolor,
               gde_invalidsaveindex,
               gde_parameter,
               gde_font,
               gde_pixmap,gde_freepixmap,
               gde_invalidcopymode,gde_mustbebitmap,
               gde_notmonochrome,gde_unmatchedmonochrome,
               gde_fontmetrics,gde_image,gde_invalidrect,gde_invalidfileformat,
               gde_invalidindex,
               gde_notimplemented
              );
              
 egdi = class(eerror)
  private
   ferror1: gdierrorty;
  public
   constructor create(aerror: gdierrorty; atext: string);
   property error: gdierrorty read ferror1;
 end;


procedure gdierror(error: gdierrorty; const text: string = ''); overload;
procedure gdierror(error: gdierrorty; sender: tobject; text: string = ''); overload;
 
function stringtocolor(value: string): colorty;
function colortostring(value: colorty): string;
function getcolornames: msestringarty;
function getcolorvalues: colorarty;

function makepoint(const x,y: integer): pointty;
function makesize(const cx,cy: integer): sizety;
function makerect(const x,y,cx,cy: integer): rectty; overload;
function makerect(const pos: pointty; const size: sizety): rectty; overload;

function isnullpoint(const point: pointty): boolean;
function isnullsize(const size: sizety): boolean;
function isnullrect(const rect: rectty): boolean;
function isnullframe(const frame: framety): boolean;
function pointisequal(const a,b: pointty): boolean;
function sizeisequal(const a,b: sizety): boolean;
function rectisequal(const a,b: rectty): boolean;
function frameisequal(const a,b: framety): boolean;

function addpoint(const a,b: pointty): pointty; //result:= a+b
procedure addpoint1(var dest: pointty; const point: pointty);
function subpoint(const a,b: pointty): pointty; //result:= a-b
procedure subpoint1(var dest: pointty; const point: pointty);
function distance(const a,b: pointty): integer;

function addsize(const a,b: sizety): sizety; //result:= a+b
procedure addsize1(var dest: sizety; const size: sizety);
function subsize(const a,b: sizety): sizety; //result:= a-b
procedure subsize1(var dest: sizety; const size: sizety);

function rectcenter(const arect: rectty): pointty;
procedure centerrect(apos: pointty; asize: integer; out rect: rectty);
function inflaterect(const rect: rectty; value: integer): rectty; overload;
function inflaterect(const rect: rectty; const frame: framety): rectty; overload;
procedure inflaterect1(var rect: rectty; value: integer); overload;
procedure inflaterect1(var rect: rectty; const frame: framety); overload;
function deflaterect(const rect: rectty; const frame: framety): rectty;
procedure deflaterect1(var rect: rectty; const frame: framety);

function addframe(const a,b: framety): framety;
procedure addframe1(var dest: framety; const frame: framety);
function subframe(const a,b: framety): framety;
procedure subframe1(var dest: framety; const frame: framety);

procedure inflateframe(var frame: framety; value: integer);
function inflateframe1(const frame: framety; value: integer): framety;
function moverect(const rect: rectty; const dist: pointty): rectty;
procedure moverect1(var rect: rectty; const dist: pointty);
function removerect(const rect: rectty; const dist: pointty): rectty;
procedure removerect1(var rect: rectty; const dist: pointty);
procedure shiftinrect(var rect: rectty; const outerrect: rectty);
procedure centerinrect(var rect: rectty; const outerrect: rectty);
function changerectdirection(const arect: rectty;
                const olddirction,newdirection: graphicdirectionty): rectty;
function rotateframe(const aframe: framety; const olddirection,
                  newdirection: graphicdirectionty): framety;
procedure rotateframe1(var aframe: framety; const olddirection,
                  newdirection: graphicdirectionty);
                
function intersectrect(const a,b: rectty; out dest: rectty): boolean; overload;
function intersectrect(const a,b: rectty): rectty; overload;
function testintersectrect(const a,b: rectty): boolean;
     //true on intersection
function clipinrect(const point: pointty; const boundsrect: rectty): pointty; overload;
function clipinrect(const rect: rectty; const boundsrect: rectty): rectty; overload;
procedure clipinrect1(var point: pointty; const boundsrect: rectty); overload;
procedure clipinrect1(var rect: rectty; const boundsrect: rectty); overload;

function pointinrect(const point: pointty; const rect: rectty): boolean;
     //true if point is in rect
function rectinrect(const inner,outer: rectty): boolean;
     //true if inner in outer

function segment(const a,b: pointty): segmentty;

procedure vectortoline(const vector: graphicvectorty; out a,b: pointty);

function rotatedirection(const olddest,newvalue,
                            oldvalue: graphicdirectionty): graphicdirectionty;

implementation
uses
 mseglob,SysUtils,mseformatstr,classes,msestreaming;
const
 errortexts: array[gdierrorty] of string = (
   '',
   'Invalid GC',
   'Color mode must be truecolor',
   'Invalid color',
   'Invalid saveindex',
   'Invalid parameter',
   'Invalid font',
   'Invalid pixmap',
   'Can not free pixmap',
   'Invalid copymode',
   'Must be bitmap',
   'Must be monochrome',
   'Unmatched monochrome',
   'Invalid fontmetrics',
   'Can not create image',
   'Invalid rect',
   'Invalid file format',
   'Invalid index',
   'Not implemented'
 );

function stringtocolor(value: string): colorty;
var
 ca1: cardinal;
begin
 result:= cl_none;
 try
  result:= colorty(strtohex(value));
  if cardinal(result) > $00ffffff then begin
   gdierror(gde_invalidcolor);
  end;
 except
  value:= lowercase(value);
  for ca1:= 0 to mapcolorcounts[cm_namedrgb] - 1 do begin
   if defaultnamedrgb[ca1].name = value then begin
    result:= colorty(ca1 + cardinal(cl_namedrgb));
    exit;
   end;
  end;
  for ca1:= 0 to mapcolorcounts[cm_mapped] - 1 do begin
   if defaultmapped[ca1].name = value then begin
    result:= colorty(ca1 + cardinal(cl_mapped));
    exit;
   end;
  end;
  for ca1:= 0 to mapcolorcounts[cm_functional] - 1 do begin
   if defaultfunctional[ca1].name = value then begin
    result:= colorty(ca1 + cardinal(cl_functional));
    exit;
   end;
  end;
  for ca1:= 0 to mapcolorcounts[cm_user] - 1 do begin
   if defaultuser[ca1].name = value then begin
    result:= colorty(ca1 + cardinal(cl_user));
    exit;
   end;
  end;
  gdierror(gde_invalidcolor);
 end;
end;

function colortostring(value: colorty): string;
begin
 if cardinal(value) <= $00ffffff then begin
  result:= '$'+hextostr(cardinal(value),6);
 end
 else begin
  if (cardinal(value) >= cardinal(cl_namedrgb)) and
       (cardinal(value) < cardinal(cl_lastnamedrgb)) then begin
   result:= defaultnamedrgb[cardinal(value) - cardinal(cl_namedrgb)].name;
  end
  else begin
   if (cardinal(value) >= cardinal(cl_mapped)) and
        (cardinal(value) < cardinal(cl_lastmapped)) then begin
    result:= defaultmapped[cardinal(value) - cardinal(cl_mapped)].name;
   end
   else begin
    if (cardinal(value) >= cardinal(cl_functional)) and
         (cardinal(value) < cardinal(cl_lastfunctional)) then begin
     result:= defaultfunctional[cardinal(value) - cardinal(cl_functional)].name;
    end
    else begin
     if (cardinal(value) >= cardinal(cl_user)) and
          (cardinal(value) < cardinal(cl_lastuser)) then begin
      result:= defaultuser[cardinal(value) - cardinal(cl_user)].name;
     end
     else begin
      result:= 'Invalid ($'+hextostr(cardinal(value),8)+')';
     end;
    end;
   end;
  end;
 end;
end;

function getcolornames: msestringarty;
var
 int1,int2: integer;
begin
 setlength(result,namedrgbcolorcount+mappedcolorcount+
          functionalcolorcount+usercolorcount-1);
 for int1:= 0 to high(defaultnamedrgb) do begin
  result[int1]:= defaultnamedrgb[int1].name;
 end;
 int2:= namedrgbcolorcount;
 for int1:= 0 to high(defaultmapped) do begin
  result[int1+int2]:= defaultmapped[int1].name;
 end;
 inc(int2,mappedcolorcount);
 result[int2]:= defaultfunctional[cl_nonenum].name;
 for int1:= 1 to cl_nonenum-1 do begin
  result[int1+int2]:= defaultfunctional[int1].name;
 end;
 for int1:= cl_nonenum + 1 to functionalcolorcount-1 do begin
  result[int1-1+int2]:= defaultfunctional[int1].name;
 end;
 {
 for int1:= cl_nonenum+1 to high(defaultfunctional) do begin
  result[int1+int2-1]:= defaultfunctional[int1].name;
 end;
 }
 inc(int2,functionalcolorcount-1);
 for int1:= 0 to high(defaultuser) do begin
  result[int1+int2]:= defaultuser[int1].name;
 end;
end;

function getcolorvalues: colorarty;
var
 int1,int2: integer;
begin
 setlength(result,namedrgbcolorcount+mappedcolorcount+
                     functionalcolorcount+usercolorcount-1);
 for int1:= 0 to high(defaultnamedrgb) do begin
  result[int1]:= cl_namedrgb + cardinal(int1);
 end;
 int2:= namedrgbcolorcount;
 for int1:= 0 to high(defaultmapped) do begin
  result[int1+int2]:= cl_mapped + cardinal(int1);
 end;
 inc(int2,mappedcolorcount);
 result[int2]:= cl_functional+cl_nonenum;
 for int1:= 1 to cl_nonenum-1 do begin
  result[int1+int2]:= cl_functional + cardinal(int1);
 end;
 for int1:= cl_nonenum+1 to functionalcolorcount-1 do begin
  result[int1+int2]:= cl_functional + cardinal(int1);
 end;
 {
 for int1:= cl_nonenum + 1 to high(defaultfunctional) do begin
  result[int1+int2-1]:= cl_functional + cardinal(int1);
 end;
 }
 inc(int2,functionalcolorcount-1);
 for int1:= 0 to high(defaultuser) do begin
  result[int1+int2]:= cl_user + cardinal(int1);
 end;
end;


function rotateframe(const aframe: framety; const olddirection,
                  newdirection: graphicdirectionty): framety;
begin
 result:= aframe;
 rotateframe1(result,olddirection,newdirection);
end;

procedure rotateframe1(var aframe: framety; const olddirection,
                  newdirection: graphicdirectionty);
var
 int1: integer;
 frame1: framety;
begin
 if olddirection <> newdirection then begin
  frame1:= aframe;
  int1:= (ord(newdirection) - ord(olddirection)) and $3;
  case int1 of
   1: begin
    aframe.top:= frame1.right;
    aframe.left:= frame1.top;
    aframe.bottom:= frame1.left;
    aframe.right:= frame1.bottom;
   end;
   2: begin
    aframe.left:= frame1.right;
    aframe.bottom:= frame1.top;
    aframe.right:= frame1.left;
    aframe.top:= frame1.bottom;
   end;
   3: begin
    aframe.bottom:= frame1.right;
    aframe.right:= frame1.top;
    aframe.top:= frame1.left;
    aframe.left:= frame1.bottom;
   end;
  end;
 end;
end;

function rotatedirection(const olddest,newvalue,
                    oldvalue: graphicdirectionty): graphicdirectionty;
begin
 result:= graphicdirectionty(((ord(olddest)+ord(newvalue)-ord(oldvalue)) and $3));
end;

procedure shiftinrect(var rect: rectty; const outerrect: rectty);
var
 int1: integer;
begin
 with rect do begin
  int1:= outerrect.x + outerrect.cx - (x + cx);
  if int1 < 0 then begin
   inc(x,int1);
  end;
  int1:= outerrect.y + outerrect.cy - (y + cy);
  if int1 < 0 then begin
   inc(y,int1);
  end;
  if x < outerrect.x then begin
   x:= outerrect.x;
  end;
  if y < outerrect.y then begin
   y:= outerrect.y;
  end;
 end;
end;

procedure centerinrect(var rect: rectty; const outerrect: rectty);
begin
 with outerrect do begin
  rect.x:= x + (cx - rect.cx) div 2;
  rect.y:= y + (cy - rect.cy) div 2;
 end;
end;

function changerectdirection(const arect: rectty;
                const olddirction,newdirection: graphicdirectionty): rectty;
begin
 result.pos:= arect.pos;
 if (olddirction in [gd_left,gd_right]) xor 
                (newdirection in [gd_left,gd_right]) then begin
  result.cx:= arect.cy;
  result.cy:= arect.cx;
 end
 else begin
  result.size:= arect.size;
 end;
end;

function makepoint(const x,y: integer): pointty;
begin
 result.x:= x;
 result.y:= y;
end;

function makesize(const cx,cy: integer): sizety;
begin
 result.cx:= cx;
 result.cy:= cy;
end;

function makerect(const x,y,cx,cy: integer): rectty;
begin
 result.x:= x;
 result.y:= y;
 result.cx:= cx;
 result.cy:= cy;
end;

function makerect(const pos: pointty; const size: sizety): rectty; overload;
begin
 result.pos:= pos;
 result.size:= size;
end;

function isnullpoint(const point: pointty): boolean;
begin
 with point do begin
  result:= (x = 0) and (y = 0);
 end;
end;

function isnullsize(const size: sizety): boolean;
begin
 with size do begin
  result:= (cx = 0) and (cy = 0);
 end;
end;

function isnullrect(const rect: rectty): boolean;
begin
 with rect do begin
  result:= (x = 0) and (y = 0) and (cx = 0) and (cy = 0);
 end;
end;

function isnullframe(const frame: framety): boolean;
begin
 with frame do begin
  result:= (left = 0) and (top = 0) and (right = 0) and (bottom = 0);
 end;
end;

function pointisequal(const a,b: pointty): boolean;
begin
 result:= comparemem(@a,@b,sizeof(pointty));
end;

function sizeisequal(const a,b: sizety): boolean;
begin
 result:= comparemem(@a,@b,sizeof(sizety));
end;

function rectisequal(const a,b: rectty): boolean;
begin
 result:= comparemem(@a,@b,sizeof(rectty));
end;

function frameisequal(const a,b: framety): boolean;
begin
 result:= comparemem(@a,@b,sizeof(framety));
end;

function addpoint(const a,b: pointty): pointty; //result:= a-b
begin
 result.x:= a.x+b.x;
 result.y:= a.y+b.y;
end;

procedure addpoint1(var dest: pointty; const point: pointty);
begin
 inc(dest.x,point.x);
 inc(dest.y,point.y);
end;

function subpoint(const a,b: pointty): pointty; //result:= a-b
begin
 result.x:= a.x-b.x;
 result.y:= a.y-b.y;
end;

procedure subpoint1(var dest: pointty; const point: pointty);
begin
 dec(dest.x,point.x);
 dec(dest.y,point.y);
end;

function distance(const a,b: pointty): integer;
begin
 result:= abs(a.x-b.x) + abs(a.y-b.y);
end;

function addsize(const a,b: sizety): sizety; //result:= a+b
begin
 result.cx:= a.cx+b.cx;
 result.cy:= a.cy+b.cy;
end;

procedure addsize1(var dest: sizety; const size: sizety);
begin
 inc(dest.cx,size.cx);
 inc(dest.cy,size.cy);
end;

function subsize(const a,b: sizety): sizety; //result:= a-b
begin
 result.cx:= a.cx-b.cx;
 result.cy:= a.cy-b.cy;
end;

procedure subsize1(var dest: sizety; const size: sizety);
begin
 dec(dest.cx,size.cx);
 dec(dest.cy,size.cy);
end;

function segment(const a,b: pointty): segmentty;
begin
 result.a:= a;
 result.b:= b;
end;

procedure vectortoline(const vector: graphicvectorty; out a,b: pointty);
begin
 with vector do begin
  a:= start;
  case direction of
   gd_right: begin
    b.x:= start.x+length;
    b.y:= start.y;
   end;
   gd_up: begin
    b.x:= start.x;
    b.y:= start.y - length;
   end;
   gd_left: begin
    b.x:= start.x - length;
    b.y:= start.y;
   end;
   gd_down: begin
    b.x:= start.x;
    b.y:= start.y + length;
   end;
  end;
 end;
end;

function deflaterect(const rect: rectty; const frame: framety): rectty;
begin
 result.x:= rect.x + frame.left;
 result.cx:= rect.cx - frame.left - frame.right;
 result.y:= rect.y + frame.top;
 result.cy:= rect.cy - frame.top - frame.bottom;
end;

procedure deflaterect1(var rect: rectty; const frame: framety);
begin
 inc(rect.x,frame.left);
 dec(rect.cx,frame.left);
 inc(rect.y,frame.top);
 dec(rect.cy,frame.top);
 dec(rect.cx,frame.right);
 dec(rect.cy,frame.bottom);
end;

function addframe(const a,b: framety): framety;
begin
 with result do begin
  left:= a.left + b.left;
  top:= a.top + b.top;
  right:= a.right + b.right;
  bottom:= a.bottom + b.bottom;
 end;
end;

procedure addframe1(var dest: framety; const frame: framety);
begin
 with dest do begin
  left:= left + frame.left;
  top:= top + frame.top;
  right:= right + frame.right;
  bottom:= bottom + frame.bottom;
 end;
end;

function subframe(const a,b: framety): framety;
begin
 with result do begin
  left:= a.left - b.left;
  top:= a.top - b.top;
  right:= a.right - b.right;
  bottom:= a.bottom - b.bottom;
 end;
end;

procedure subframe1(var dest: framety; const frame: framety);
begin
 with dest do begin
  left:= left - frame.left;
  top:= top - frame.top;
  right:= right - frame.right;
  bottom:= bottom - frame.bottom;
 end;
end;

function pointinrect(const point: pointty; const rect: rectty): boolean;
     //true if point is in rect
begin
 result:= (point.x >= rect.x) and (point.x < rect.x + rect.cx) and
          (point.y >= rect.y) and (point.y < rect.y + rect.cy);
end;

function rectcenter(const arect: rectty): pointty;
begin
 with arect do begin
  result.x:= x + cx div 2;
  result.y:= y + cy div 2;
 end;
end;

procedure centerrect(apos: pointty; asize: integer; out rect: rectty);
var
 int1: integer;
begin
 int1:= asize div 2;
 with rect do begin
  x:= apos.x - int1;
  y:= apos.y - int1;
  cx:= asize;
  cy:= asize;
 end;
end;

function inflaterect(const rect: rectty; value: integer): rectty;
begin
 with rect do begin
  result.x:= x - value;
  result.y:= y - value;
  result.cx:= cx + value + value;
  result.cy:= cy + value + value;
 end;
end;

function inflaterect(const rect: rectty; const frame: framety): rectty;
begin
 result.x:= rect.x - frame.left;
 result.cx:= rect.cx + frame.left + frame.right;
 result.y:= rect.y - frame.top;
 result.cy:= rect.cy + frame.top + frame.bottom;
end;

procedure inflaterect1(var rect: rectty; value: integer);
begin
 with rect do begin
  dec(x,value);
  dec(y,value);
  inc(cx,value);
  inc(cx,value);
  inc(cy,value);
  inc(cy,value);
 end;
end;

procedure inflaterect1(var rect: rectty; const frame: framety);
begin
 dec(rect.x,frame.left);
 inc(rect.cx,frame.left);
 dec(rect.y,frame.top);
 inc(rect.cy,frame.top);
 inc(rect.cx,frame.right);
 inc(rect.cy,frame.bottom);
end;


procedure inflateframe(var frame: framety; value: integer);
begin
 inc(frame.left,value);
 inc(frame.top,value);
 inc(frame.right,value);
 inc(frame.bottom,value);
end;

function inflateframe1(const frame: framety; value: integer): framety;
begin
 result.left:= frame.left + value;
 result.top:= frame.top + value;
 result.right:= frame.right + value;
 result.bottom:= frame.bottom + value;
end;


function moverect(const rect: rectty; const dist: pointty): rectty;
begin
 result.x:= rect.x + dist.x;
 result.y:= rect.y + dist.y;
 result.size:= rect.size;
end;

procedure moverect1(var rect: rectty; const dist: pointty);
begin
 inc(rect.x,dist.x);
 inc(rect.y,dist.y);
end;

function removerect(const rect: rectty; const dist: pointty): rectty;
begin
 result.x:= rect.x - dist.x;
 result.y:= rect.y - dist.y;
 result.size:= rect.size;
end;

procedure removerect1(var rect: rectty; const dist: pointty);
begin
 dec(rect.x,dist.x);
 dec(rect.y,dist.y);
end;

function intersectrect(const a,b: rectty; out dest: rectty): boolean;
var
 rect1: rectty;
begin
 with rect1 do begin
  if a.x > b.x then begin
   x:= a.x;
   if a.x + a.cx > b.x + b.cx then begin
    cx:= b.x + b.cx - a.x;
   end
   else begin
    cx:= a.cx;
   end;
  end
  else begin
   x:= b.x;
   if b.x + b.cx > a.x + a.cx then begin
    cx:= a.x + a.cx - b.x;
   end
   else begin
    cx:= b.cx;
   end;
  end;
  if a.y > b.y then begin
   y:= a.y;
   if a.y + a.cy > b.y + b.cy then begin
    cy:= b.y + b.cy - a.y;
   end
   else begin
    cy:= a.cy;
   end;
  end
  else begin
   y:= b.y;
   if b.y + b.cy > a.y + a.cy then begin
    cy:= a.y + a.cy - b.y;
   end
   else begin
    cy:= b.cy;
   end;
  end;
  if (cx <= 0) or (cy <= 0) then begin
   result:= false;
   dest:= nullrect;
  end
  else begin
   result:= true;
   dest:= rect1;
  end;
 end;
end;

function intersectrect(const a,b: rectty): rectty;
begin
 intersectrect(a,b,result);
end;

function testintersectrect(const a,b: rectty): boolean;
     //true on intersection
var
 rect1: rectty;
begin
 result:= intersectrect(a,b,rect1);
end;

function rectinrect(const inner,outer: rectty): boolean;

 procedure normalize(const rect: rectty; out topleft,bottomright: pointty);
 begin
  with rect do begin
   if cx < 0 then begin
    topleft.x:= x + cx;
    bottomright.x:= x;
   end
   else begin
    topleft.x:= x;
    bottomright.x:= x + cx;
   end;
   if cy < 0 then begin
    topleft.y:= y + cy;
    bottomright.y:= y;
   end
   else begin
    topleft.y:= y;
    bottomright.y:= y + cy;
   end;
  end;
 end;

var
 itopleft,ibottomright: pointty;
 otopleft,obottomright: pointty;
begin
 normalize(inner,itopleft,ibottomright);
 normalize(outer,otopleft,obottomright);
 result:= (itopleft.x >= otopleft.x) and (ibottomright.x <= obottomright.x) and
          (itopleft.y >= otopleft.y) and (ibottomright.y <= obottomright.y);
end;

procedure clipinrect1(var point: pointty; const boundsrect: rectty);
begin
 with boundsrect do begin
  if point.x < x then begin
   point.x:= x;
  end;
  if point.x >= x + cx then begin
   point.x:= x + cx - 1;
  end;
  if point.y < y then begin
   point.y:= y;
  end;
  if point.y >= y + cy then begin
   point.y:= y + cy - 1;
  end;
 end;
end;

function clipinrect(const point: pointty; const boundsrect: rectty): pointty;
begin
 result:= point;
 clipinrect1(result,boundsrect);
end;

procedure clipinrect1(var rect: rectty; const boundsrect: rectty);
begin
 with boundsrect do begin
  if rect.x < x then begin
   rect.x:= x;
  end;
  if rect.x + rect.cx > x + cx then begin
   rect.x:= x + cx - rect.cx;
   if rect.x < x then begin
    rect.x:= x;
    rect.cx:= cx;
   end;
  end;
  if rect.y < y then begin
   rect.y:= y;
  end;
  if rect.y + rect.cy > y + cy then begin
   rect.y:= y + cy - rect.cy;
   if rect.y < y then begin
    rect.y:= y;
    rect.cy:= cy;
   end;
  end;
 end;
end;

function clipinrect(const rect: rectty; const boundsrect: rectty): rectty;
begin
 result:= rect;
 clipinrect1(result,boundsrect);
end;

procedure gdierror(error: gdierrorty; const text: string = ''); overload;
begin
 if error = gde_ok then begin
  exit;
 end;
 raise egdi.create(error,text);
end;

procedure gdierror(error: gdierrorty; sender: tobject;
                       text: string = ''); overload;
begin
 if error = gde_ok then begin
  exit;
 end;
 if sender <> nil then begin
  text:= sender.classname + ' ' + text;
  if sender is tcomponent then begin
   text:= text + ' ' + fullcomponentname(tcomponent(sender));
  end;
 end;
 gdierror(error,text);
end;

{ egdi }

constructor egdi.create(aerror: gdierrorty; atext: string);
begin
 inherited create(integer(aerror),atext,errortexts);
end;

end.

