/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/*----------------------------------------------------------------------*
 * Originally written:
 *    2002      Alexis <materm@tele2.fr>
 * $Id: xresources.h,v 1.6 2004/08/15 16:12:10 alexis Exp $
 *----------------------------------------------------------------------*/

#ifndef _XRESOURCES_H_
#define _XRESOURCES_H_


void list_options ();
void version (int type);
void usage (int type);
void get_options (int argc, char *argv[]);
int my_strcasecmp (const char *s1, const char *s2);
Bool define_key (XrmDatabase * database, 
  XrmBindingList bindings, XrmQuarkList quarks, 
  XrmRepresentation * type, XrmValue * value, 
  XPointer closure);
int parse_keysym (char *str, char *arg);
void get_xdefaults (FILE * stream, const char *name);
void extract_resources (Display * display, const char *name);
void load_resources_from_db(XrmDatabase db);
void get_resources();
void parse_command_line(int argc, char *argv[]);
void display_options();
void set_vt_resources();
#if defined(BACKGROUND_IMAGE) || defined(TRANSPARENT)
void set_background();
#endif

#endif /* _XRESOURCES_H_ */
