import os.path
import zope.interface

from multibuild.builder.hooks import interfaces, register, support

class Hook(support.Hook):
    zope.interface.implements(interfaces.IHookBuildResult)

    name = "print-packages"
    default_priority = 30

    def result(self, build):
        files = self.get_files(build)
        paths = []
        for f in files:
            if f.endswith(".deb") or f.endswith(".udeb"):
                paths.append((f, os.path.join(build.environment.build_dir, f)))

        for file, path in paths:
            build.log.write("%s:\n" % file)
            f = build.environment.run(["dpkg-deb", "--info", path])
            for i in f:
                build.log.write(i)
            f.close()
            build.log.write("\n")

        for file, path in paths:
            build.log.write("%s:\n" % file)
            f = build.environment.run(["dpkg-deb", "--contents", path])
            for i in f:
                build.log.write(i)
            f.close()
            build.log.write("\n")

register(Hook)
