//clients.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _MUROARD_CLIENTS_H_
#define _MUROARD_CLIENTS_H_

#define CLIENT_STATE_UNUSED        0
#define CLIENT_STATE_NEW           1
#define CLIENT_STATE_OLD           2
#define CLIENT_STATE_EXECED        3
#define CLIENT_STATE_CLOSING       4


struct muroard_client {
 int state;
 int sock;
 int stream;
} g_client[MUROAR_MAX_CLIENTS];

int client_init(void);
int client_free(void);
int client_new(int sock);
int client_delete(int id);
int client_handle(int id);
int client_exec(int id);

int client_handle_new_stream(int id, struct muroard_message * mes);

#ifdef MUROAR_FEATURE_CMD_ATTACH
int client_handle_attach(int id, struct muroard_message * mes);
#endif
#ifdef MUROAR_FEATURE_CMD_SERVER_OINFO
int client_handle_server_oinfo(int id, struct muroard_message * mes);
#endif
#ifdef MUROAR_FEATURE_CMD_PASSFH
int client_handle_passfh(int id, struct muroard_message * mes);
#endif
#ifdef MUROAR_FEATURE_CMD_LIST_CLIENTS
int client_handle_list_clients(int id, struct muroard_message * mes);
#endif
#ifdef MUROAR_FEATURE_CMD_LIST_STREAMS
int client_handle_list_streams(int id, struct muroard_message * mes);
#endif
#ifdef MUROAR_FEATURE_CMD_GET_CLIENT
int client_handle_get_client(int id, struct muroard_message * mes);
#endif
#ifdef MUROAR_FEATURE_CMD_GET_STREAM
int client_handle_get_stream(int id, struct muroard_message * mes);
#endif

#define client_get_sock(id)      (g_client[(id)].state == CLIENT_STATE_UNUSED ? -1 : g_client[(id)].sock)
#define client_get_stream(id)    (g_client[(id)].state == CLIENT_STATE_UNUSED ? -1 : g_client[(id)].stream)
#define client_set_stream(id, s) (g_client[(id)].state == CLIENT_STATE_UNUSED || g_client[(id)].stream != -1 ? \
                                  -1 : (g_client[(id)].stream = (s)) && 0)

#endif

//ll
