//features.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

/*
 * This header contains the user configuration for RoarD.
 */

#ifndef _MUROARD_FEATURES_H_
#define _MUROARD_FEATURES_H_

/*********************************************************/
/* below you find general/misc features                  */
/*********************************************************/

// Support help text? (--help/-h):
#define MUROARD_FEATURE_HELP_TEXT

// Support progress arguments (argv[]):
#define MUROAR_FEATURE_ARGV

// Add uneeded code that optimzire CPU load?:
// This may make the binary a bit bigger but faster
#define MUROAR_FEATURE_OPTIMIZE

// Include signal handling?:
#define MUROAR_FEATURE_SIGNALS

// Support to daemonize?:
#define MUROAR_FEATURE_DAEMONIZE


/*********************************************************/
/* below you find the default audio settings             */
/*********************************************************/

// Sample rate for the server:
// The server will reject all streams with a diffrent rate.
#define MUROAR_DEFAULT_RATE               44100

// nummber of channels:
#define MUROAR_DEFAULT_CHANNELS           2

// size of the internal cycle:
#define MUROAR_DEFAULT_FRAMES_PER_CYCLE   (g_sa_rate/10) /* 100ms */


/*********************************************************/
/* below you find the settings for DSP features          */
/*********************************************************/

// Enable support for upmix signals from mono?:
// This may be buggy.
#define MUROAR_FEATURE_UPMIX_INPUT

// Enable support for downmix signals to mono?:
// This may be buggy.
#define MUROAR_FEATURE_DOWNMIX_OUTPUT

// Enable support fo upscale signals from 8 to 16 bit?:
#define MUROAR_FEATURE_UPSCALE_INPUT

// Enable support fo downscale signals from 8 to 16 bit?:
#define MUROAR_FEATURE_DOWNSCALE_OUTPUT

// Enable support to convert between diffrent byte orders?:
#define MUROAR_FEATURE_BYTE_SWAP


/*********************************************************/
/* below you find the stream  settings                   */
/*********************************************************/

// Should we support MONITOR streams?
#define MUROAR_FEATURE_MONITOR


/*********************************************************/
/* below you find client and stream options              */
/*********************************************************/

// Maximum number of clients on this server:
#define MUROAR_MAX_CLIENTS                8

// Maximum number of streams on this server:
#define MUROAR_MAX_STREAMS                8


/*********************************************************/
/* below you find driver options                         */
/*********************************************************/

// Which driver should we build?
#define MUROAR_FEATURE_DRIVER             DRIVER_OSS

// Default device for OSS:
// Comment this out for no default device.
#define MUROAR_DEFAULT_DRIVER_OSS_DEV     "/dev/audio"

// Support setting of OSS fragment size?
// This is recommneted as it will lead in extra-high latency
// on some systems if not enabled.
#define MUROAR_FEATURE_DRIVER_OSS_SETFRAGMENT


/*********************************************************/
/* below you find protocol options                       */
/*********************************************************/

// This is the maximum size of the data part of a
// RoarAudio protocol message:
#define MUROAR_MAX_MSGSIZE                256


/*********************************************************/
/* below you find command options                        */
/*********************************************************/

// Handle some commands we do not support as noops?:
// Some of the commands can safely be handel as noop.
// This may help with random clients, must be considered
// a workarounds.
#define MUROAR_FEATURE_NOOP_SIUCMDS

// Support WHOAMI command?:
// This command is not used by much clients but not much
// code is needed to implemeent this.
// keep enabled if you do not require to safe every byte
// you can.
#define MUROAR_FEATURE_CMD_WHOAMI

// Support EXIT command?:
// This enables the EXIT command. If you want to support
// the termination option of this command, too, you need to
// enable MUROAR_FEATURE_TERMINATE in addition to this option.
#define MUROAR_FEATURE_CMD_EXIT

// Support terminate feature?:
// This will clients enable to set the server into
// termination state. In termination state it will
// terminate as soon as the last client disconnects.
// while in termination state the server will not accept
// new connections and closes the listening socket so a
// new instance of the server can re-open it.
#define MUROAR_FEATURE_TERMINATE

// Support ATTACH command?:
// This will enable simple attaches.
// it will not work with background streams but will
// enable the use-execed workaround of libroar.
#define MUROAR_FEATURE_CMD_ATTACH

// Support GET_STANDBY command?:
// As this server does not support standby will
// allways return 'server active' to client.
#define MUROAR_FEATURE_CMD_GET_STANDBY

// Support SERVER_OINFO?:
// This command is used by the client to get infos on
// native format of server. This may be very helpfull
// as we do not support much formats.
#define MUROAR_FEATURE_CMD_SERVER_OINFO

// Support PSSFH command?:
// This enables the client for passive streams and multi-stream
// architectures.
#define MUROAR_FEATURE_CMD_PASSFH

// Support GET_VOL command?:
// this is just a dummy at the moment, returning a volume of
// 0dB (100%).
#define MUROAR_FEATURE_CMD_GET_VOL

// Support to list clients?:
// this will implement the LIST_CLIENTS command.
// you will most probably also want to enable
// the GET_CLIENT command.
#define MUROAR_FEATURE_CMD_LIST_CLIENTS

// Support to list streams?:
// this will implement the LIST_STREAMS command.
// you will most probably also want to enable
// the GET_STREAMS command.
#define MUROAR_FEATURE_CMD_LIST_STREAMS

// Support to get infos on a client?:
// this implements the GET_CLIENT command.
#define MUROAR_FEATURE_CMD_GET_CLIENT

// Support to get infos on a stream?:
// this implements the GET_STREAM command.
#define MUROAR_FEATURE_CMD_GET_STREAM

// Support KICK command?:
// This enables clients to ckick streams and clients.
#define MUROAR_FEATURE_CMD_KICK


/*********************************************************/
/* below you find network options                        */
/*********************************************************/

// support for client socket passing:
#define MUROAR_FEATURE_CLIENT_FH

// support to listen on sockets:
#define MUROAR_FEATURE_SOCKET_LISTEN

// support for IPv4 sockets:
#define MUROAR_FEATURE_SOCKET_INET

// support for UNIX sockets:
#define MUROAR_FEATURE_SOCKET_UNIX

// default type for listen sockets:
// ensure that this type is enabled above!
#define MUROAR_DEFAULT_LISTEN_TYPE        NETWORK_TYPE_UNIX

// default address of UNIX socket to listen on:
#define MUROAR_DEFAULT_LISTEN_ADDR_UNIX   "/tmp/muroard"

// default address of IPv4 host to listen on:
#define MUROAR_DEFAULT_LISTEN_ADDR_INET   "localhost"

// default port (only IPv4) to listen on:
// port 16002 is RoarAudio default
#define MUROAR_DEFAULT_LISTEN_PORT        16002

// File Mode to set on opened UNIX Sockets:
// undef to not use this.
#define MUROAR_DEFAULT_LISTEN_CHMOD       0770


/*********************************************************/
/* below you find features which are not yet implemented */
/*********************************************************/

/*
 * #define MUROAR_FEATURE_UNSIGNED_8BIT
 * #define MUROAR_FEATURE_UNSIGNED_16BIT
 * #define MUROAR_FEATURE_UNSIGNED
 * #define MUROAR_FEATURE_UPMIX
 * #define MUROAR_FEATURE_DOWNMIX
 * #define MUROAR_FEATURE_CMD_BEEP
 * #define MUROAR_FEATURE_CMD_CON_STREAM
 * #define MUROAR_FEATURE_VOLUME_CONTROL
 * #define MUROAR_FEATURE_META_DATA
 * #define MUROAR_FEATURE_STREAM_FLAGS
 * #define MUROAR_FEATURE_STANDBY
*/

#endif

//ll
