//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audioprefetch.h,v 1.3.2.1 2005/06/04 19:25:15 spamatica Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIOPREFETCH_H__
#define __AUDIOPREFETCH_H__

#include "thread.h"

//---------------------------------------------------------
//   AudioPrefetch
//---------------------------------------------------------

class AudioPrefetch : public Thread {
      unsigned writePos;
      unsigned seekPos; // remember last seek to optimize seeks

      virtual void processMsg1(const void*);
      void prefetch();
      void seek(unsigned pos);

   public:
      AudioPrefetch(int prio, const char* name);
      ~AudioPrefetch();
      virtual void start();

      void msgTick();
      void msgSeek(unsigned samplePos, bool force=false);
      volatile bool seekDone;
      };

extern AudioPrefetch* audioPrefetch;

#endif
