#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qfile.h>
#include <qlistview.h>
#include <qdatetime.h>
#include "mainwindow.h"
#include "table.h"
#include "loglistviewitem.h"
#include "include/sql.h"

void Table::slot_close()
{
	parentWidget()->close();
}

void Table::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is Table"));
}

void Table::slot_fire()
{
	if(table->text().isEmpty())
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter table name you will create."));
		return;
	}

	if(database->currentText() == QString("mysql"))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Can't create table in mysql database."));
		return;
	}
	
	mysql_select_db(mysql, database->currentText());

	QString sql;

	sql += "CREATE TABLE " + table->text() + " (";

	QListViewItemIterator s(field1);

	for(; s.current(); s++)
	{
		QString z = s.current()->text(0) + " " + s.current()->text(1) + " " + s.current()->text(2) + " " + s.current()->text(3) + " " + s.current()->text(4);
		sql += QString("\n\t") + z.simplifyWhiteSpace() + ",";
	}
	
	QListViewItemIterator z(key);

	for(; z.current(); z++)
		sql += QString("\n\t") + z.current()->text(1) + " " + z.current()->text(0) + " " + "(" + z.current()->text(2) + ")" + ",";

	if(sql.at(sql.length() - 1) == ',')
		sql = sql.left(sql.length() - 1);

	sql += "\n) ";

	sql += "TYPE = " + table_type->currentText() + " ";
	sql += QString("COMMENT =") +  "\'" + comment->text() + "\'";

	sql += ";";

	switch(QMessageBox::warning(this, tr("MySQL Navigator"), tr("The following query will create table. are you sure?") + "\n\n" + sql, "&Yes", "&No", "&Edit", 0, 1 ))
	{
			case 1: 
				return;
				break;
			case 2:
				((MainWindow *)qApp->mainWidget())->slot_query2(sql, database->currentText());
				return;
	}

	//debug(sql.latin1());
	
	if(SQL::sql_query(sql.latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
	}
	else
	{
		emit signal_schema();

		QMessageBox::warning(this, tr("MySQL Navigator"), QString(tr("Table ")) + table->text() + QString(tr(" in ")) + database->currentText() + QString(tr(" has been successfully created.")));
	}
}

void Table::slot_field_new()
{
	field1->clearSelection();
	field_name->setText("");
	field_type->setCurrentItem(0);
	field_sign->setCurrentItem(0);
	field_length->setText("");
	field_null->setCurrentItem(0);
	field_default->setText("");
	field_extra->setCurrentItem(0);
	
	TabWidget2->setCurrentPage(0);
	field_name->setFocus();
}

void Table::reset_key_field()
{
	QCheckListItem *a = NULL;
	field2->clear();
	QListViewItemIterator s(field1);
	for(; s.current(); s++)
	{
		QCheckListItem *z = new QCheckListItem(field2, s.current()->text(0), QCheckListItem::CheckBox);
		z->moveItem(a);
		a = z;
	}
}

void Table::slot_field_save()
{
	if(field_name->text().isEmpty())
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter field name you will create.\n"));
		return;
	}

	QListViewItem *z = NULL;

	if(field1->selectedItem() != NULL)
	{
		z = field1->selectedItem();

			z->setText(0, field_name->text());

		if(field_length->text().isEmpty())
			z->setText(1, field_type->currentText() + " " + field_sign->currentText());
		else
			z->setText(1, field_type->currentText() + "(" + field_length->text() + ") " + field_sign->currentText());
	
		z->setText(2, field_null->currentText());
		
		if(field_default->text().isEmpty() == FALSE)
			z->setText(3, QString("DEFAULT ") + "\'" + field_default->text() + "\'");
		else
			z->setText(3, "");

		z->setText(4, field_extra->currentText());

		reset_key_field();
		
		struct value data;
		data.type = field_type->currentItem();
		sprintf(data.length, "%s", field_length->text().latin1());
		data.sign = field_sign->currentItem();
		data.null = field_null->currentItem();
		sprintf(data.default_, "%s", field_default->text().latin1());
		data.extra = field_extra->currentItem();
		map.replace(z->text(0), data);

		slot_field_new();

		return;
	}

	if(is_exist(FLAG_FIELD, field_name->text()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Same field name already exists."));
			return;
	}

	z = new QListViewItem(field1, get_last(FLAG_FIELD));

	z->setText(0, field_name->text());

	if(field_length->text().isEmpty())
		z->setText(1, field_type->currentText() + " " + field_sign->currentText());
	else
		z->setText(1, field_type->currentText() + "(" + field_length->text() + ") " + field_sign->currentText());
	
	z->setText(2, field_null->currentText());
		
	if(field_default->text().isEmpty() == FALSE)
		z->setText(3, QString("DEFAULT ") + "\'" + field_default->text() + "\'");
	else
		z->setText(3, "");

	z->setText(4, field_extra->currentText());

	reset_key_field();

	struct value data;
	data.type = field_type->currentItem();
	sprintf(data.length, "%s", field_length->text().latin1());
	data.sign = field_sign->currentItem();
	data.null = field_null->currentItem();
	sprintf(data.default_, "%s", field_default->text().latin1());
	data.extra = field_extra->currentItem();
	map.replace(z->text(0), data);

	slot_field_new();
}

void Table::slot_field_drop()
{
	QListViewItem *s = field1->selectedItem();

	if(s == NULL)
		return;

	map.remove(s->text(0));

	field1->removeItem(s);
	field1->clearSelection();

	reset_key_field();
}

void Table::slot_field_up()
{
	if(field1->selectedItem() == NULL)
		return;

	if(field1->firstChild() == NULL)
		return;

	QListViewItem *z = field1->selectedItem()->itemAbove();

	if(z == NULL)
	{
		return;
	}

	z = z->itemAbove();

	if(z == NULL)
	{
		field1->firstChild()->moveItem(field1->selectedItem());
		return;
	}

	field1->selectedItem()->moveItem(z);
}

void Table::slot_field_down()
{
	if(field1->selectedItem() == NULL)
		return;

	if(field1->firstChild() == NULL)
		return;
	
	QListViewItem *z = field1->selectedItem()->itemBelow();

	if(z == NULL)
	{
		return;
	}

	field1->selectedItem()->moveItem(z);
}

QListViewItem *Table::get_last(bool flag)
{
	QListViewItem *z;
	QListViewItem *last;

	if(flag == FLAG_FIELD)
		z = field1->firstChild();
	else
		z = key->firstChild();

	if(z == NULL)
	{
		return NULL;
	}

	last = z;
	
	while(TRUE)
	{
		z = z->itemBelow();

		if(z == NULL)
		{
			break;
		}

		last = z;
	}

	return last;
}


void Table::slot_database()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();

	database->slot_value(value);

	return;
}

void Table::slot_database(const QString &value)
{
	for(int s = 0; s < database->count(); s++)
	{
		if(database->text(s) == value)
		{
			database->setCurrentItem(s);
			database->data  = value;
			return;
		}
	}
}

void Table::slot_field(QListViewItem *z)
{
	if(z == NULL)
		return;

	if(map.find(z->text(0)) == map.end())
		return;

	struct value data = map.find(z->text(0)).data();

	field_name->setText(z->text(0));
	field_type->setCurrentItem(data.type);
	field_length->setText(data.length);
	field_sign->setCurrentItem(data.sign);
	field_null->setCurrentItem(data.null);
	field_default->setText(data.default_);
	field_extra->setCurrentItem(data.extra);
}

QString Table::get_length(QString type)
{
	QString sql;

	bool flag = FALSE;

	for(unsigned int s = 0; s < type.length(); s++)
	{
		if(flag)
		{
			if(type.at(s) != ')')
				sql += QChar(type.at(s));
		}

		if(type.at(s) == '(')
			flag = TRUE;

		if(type.at(s) == ')')
		{
			break;
		}
	}

	//debug(sql.latin1());

	return sql;
}

int Table::get_type(QString sql)
{
	char type[25][20] = {"TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "VARCHAR", "TINYBLOB", "TINYTEXT", "TEXT", "BLOB", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT", "ENUM", "SET"};

	sql = sql.upper();

	for(int l = 0; l < 25; l++)
	{
		if(strncmp(sql.latin1(), type[l], strlen(type[l])) == 0)
		{
			//debug(type[l]);
			return l;
		}
	}

	return 0;
}

void Table::slot_key_new()
{
	key_name->setText("");
	key_type->setCurrentItem(0);

	reset_key_field();

	TabWidget2->setCurrentPage(1);
	key_name->setFocus();
}

void Table::slot_key_save()
{
	if(key_name->text().isEmpty())
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter key name you will create.\n"));
		return;
	}

	if(is_exist(FLAG_KEY, key_name->text()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Same key name already exists."));
			return;
	}

	QListViewItemIterator s(field2);
	QString value;
	for(; s.current(); s++)
	{
		if(((QCheckListItem *)s.current())->isOn())
		{
			value += s.current()->text(0);
			value += ",";
		}
	}

	if(value.isEmpty())
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please choose fields."));
		return;
	}

	if(value.at(value.length() - 1) == ',')
		value = value.left(value.length()  - 1);
	
	QListViewItem *z = NULL;

	z = new QListViewItem(key, get_last(FLAG_KEY));
	z->setText(0, key_name->text());
	z->setText(1, key_type->currentText());
	z->setText(2, value);

	slot_key_new();
}

void Table::slot_key_drop()
{
	key->removeItem(key->selectedItem());
	key->clearSelection();
}

void Table::slot_key_up()
{
	if(key->firstChild() == NULL)
		return;

	QListViewItem *z = key->selectedItem()->itemAbove();

	if(z == NULL)
	{
		return;
	}

	z = z->itemAbove();

	if(z == NULL)
	{
		key->firstChild()->moveItem(key->selectedItem());
		return;
	}

	key->selectedItem()->moveItem(z);
}

void Table::slot_key_down()
{
	if(key->firstChild() == NULL)
		return;
	
	QListViewItem *z = key->selectedItem()->itemBelow();

	if(z == NULL)
	{
		return;
	}

	key->selectedItem()->moveItem(z);
}

void Table::slot_key(QListViewItem *)
{
}

bool Table::is_exist(bool flag, QString name)
{
	if(flag == FLAG_FIELD)
	{
		QListViewItemIterator s(field1);

		for(; s.current(); s++)
		{
			if(s.current()->text(0) == name)
				return TRUE;
		}

		return FALSE;
	}
	else
	{
		QListViewItemIterator s(key);

		for(; s.current(); s++)
		{
			if(s.current()->text(0) == name)
				return TRUE;
		}

		return FALSE;
	}

	return FALSE;
}

void Table::slot_clear()
{
	slot_field_new();
	slot_key_new();
	key->clear();
	field1->clear();
	field2->clear();
	database->setCurrentItem(0);
	table->setText("");
	table_type->setCurrentItem(0);
	comment->setText(0);

	TabWidget2->setCurrentPage(0);
	field_new->setFocus();
}

void Table::slot_clicked(int)
{
	QListViewItemIterator s(field2);
	for(; s.current(); s++)
	{
		if(flag)
			((QCheckListItem *)s.current())->setOn(TRUE);
		else
			((QCheckListItem *)s.current())->setOn(FALSE);
	}

	if(flag)
		flag = FALSE;
	else
		flag = TRUE;
}