#ifndef __GRID_VIEW_H__
#define __GRID_VIEW_H__


#include "sqlide/grid_view_model.h"
namespace mforms
{
  class Menu;
};

class GridView : public Gtk::TreeView
{
  public:
    static GridView * create(bec::GridModel::Ref model, bool fixed_row_height = true);
    GridView(bec::GridModel::Ref model, bool fixed_row_height = true);
    ~GridView();

    void set_context_menu(mforms::Menu* menu);
    void set_context_menu_responder(const sigc::slot<void>& slot);

    typedef std::map<int, bec::NodeId> SelectedNodes;
    void get_selected_nodes(SelectedNodes *nodes);

    void model(bec::GridModel::Ref value);

    int refresh(bool reset_columns);

    void scroll_to(const int whence); // whence == 0 seeks to start, whence == 1 seeks to end

    bec::NodeId current_cell(int &row, int &col);
    bec::NodeId current_node();
    int current_row();

    void delete_selected_rows();

    void on_column_header_clicked(Gtk::TreeViewColumn *column, int column_index);
    void sort_by_column(int column_index, int sort_direction, bool retaining);

    int row_count() const;
    void row_numbers_visible(bool value) { _view_model->row_numbers_visible(value); }


    sigc::signal<void, const Glib::ustring&, const Glib::ustring&> signal_cell_edited() { return _signal_cell_edited; }
    //sigc::slot<void, const Glib::ustring&, const Glib::ustring&> slot_cell_edited() { return _signal_cell_edited.make_slot(); }
    sigc::signal<void> signal_row_count_changed() { return _signal_row_count_changed; }
    sigc::signal<void, int, int, bool> signal_sort_by_column;

    void on_cell_edited(const Glib::ustring &path_string, const Glib::ustring &new_text);
    void on_cell_editing_started(Gtk::CellEditable* e, const Glib::ustring &path, Gtk::TreeViewColumn* column);
    void on_cell_editing_done();

    void set_ellipsize(const int column, const bool on) {_view_model->set_ellipsize(column, on);}
    GridViewModel::Ref view_model() {return _view_model;}

    void sync_row_count();
  protected:

    virtual bool on_key_press_event(GdkEventKey *event);
    virtual bool on_button_release_event(GdkEventButton *event);

    void reset_sorted_columns();

  private:
    virtual void init();

    sigc::signal<void, const Glib::ustring&, const Glib::ustring&> _signal_cell_edited;
    sigc::signal<void> _signal_row_count_changed;

    void add_node_for_path(const Gtk::TreeModel::Path &path, SelectedNodes *rows);
    void activate_popup_menu_item(const std::string &action, const std::vector<int> &rows, int clicked_column);


    bec::GridModel::Ref _model;
    GridViewModel::Ref  _view_model;
    int _row_count;

    Gtk::TreePath          _path_edited;
    Gtk::TreeViewColumn   *_column_edited;
    Gtk::CellEditable     *_cell_editable;

    mforms::Menu          *_context_menu;
    sigc::slot<void>       _context_menu_responder;
};


#endif // __GRID_VIEW_H__
