/* 
 * Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _MFORMS_TABSWITCHER_H_
#define _MFORMS_TABSWITCHER_H_

#include <vector>

#include "cairo/cairo.h"

#include "base/drawing.h"
#include "mforms/base.h"
#include "mforms/drawbox.h" 
#include "mforms/tabview.h"
#include "base/trackable.h"

namespace mforms
{
#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
   struct TabItem {
    std::string title;
    std::string sub_title;
    cairo_surface_t *icon;
    cairo_surface_t *alt_icon;
    int width;
    int text_width;             // The width of the widest entry (either main caption or sub caption).
    int text_height;            // The height of the entire text.
    int text_y_advance;         // Vertical offset from the main caption to the sub caption.

    TabItem() : icon(0), alt_icon(0), width(0) {}
    ~TabItem() { if (icon) cairo_surface_destroy(icon); if (alt_icon) cairo_surface_destroy(alt_icon); }
  };
#endif // !SWIG
#endif

  enum TabElementPart {
    TabBackground  = 0,
    TabMainCaption = 1,
    TabSubCaption  = 2,
    TabLineColor   = 3
  };
  
  class MFORMS_EXPORT TabSwitcher : public DrawBox, public base::trackable
  {
  public:
    TabSwitcher();
    virtual ~TabSwitcher();
    
    void attach_to_tabview(TabView *tabView);
    
    int add_item(const std::string &title, const std::string &sub_title,
                  const std::string &icon_path, const std::string &alt_icon_path);
    void set_icon(int index, const std::string &icon_path, const std::string &alt_icon_path);

    void set_color(TabElementPart parts, MySQL::Drawing::Color new_color);
    
    void set_selected(int index);
    int get_selected() { return _selected; }
    void set_needs_relayout();
    
#ifndef SWIG
    boost::signals2::signal<void ()>* signal_changed() { return &_signal_changed; };

#ifndef DOXYGEN_SHOULD_SKIP_THIS
    virtual int get_preferred_height();
    virtual void set_layout_dirty();
    
    virtual void repaint(cairo_t *cr, int x, int y, int w, int h);
    virtual void mouse_down(int button, int x, int y);
    virtual void mouse_up(int button, int x, int y);
    virtual void mouse_click(int button, int x, int y);
#endif
#endif
  private:
    boost::signals2::signal<void ()> _signal_changed;
    TabView *_tabView;
    MySQL::Drawing::Color _colors[4];
    int _selected;
    int _last_clicked;

    std::vector<TabItem*> _items;
    bool _needs_relayout;
    
    // Patterns for drawing the selected tab visual cues.
    cairo_pattern_t* _background_pattern;
    cairo_pattern_t* _line_pattern;

    void prepare_patterns();
    void destroy_patterns();
    void layout(cairo_t *cr);
    int index_from_point(int x, int y);
    void tab_changed();
  };
};

#endif


