
#ifndef _SQLGENERATOR_IF_H_
#define _SQLGENERATOR_IF_H_

#include <grtpp_module_cpp.h>
#include "grts/structs.h"

// diff sql generation interface definition header

class SQLGeneratorInterfaceImpl : public grt::InterfaceImplBase
{
public:
  DECLARE_REGISTER_INTERFACE(SQLGeneratorInterfaceImpl,
                             DECLARE_INTERFACE_FUNCTION(SQLGeneratorInterfaceImpl::getTargetDBMSName),
                             DECLARE_INTERFACE_FUNCTION(SQLGeneratorInterfaceImpl::generateSQL),
                             DECLARE_INTERFACE_FUNCTION(SQLGeneratorInterfaceImpl::generateReport),
                             DECLARE_INTERFACE_FUNCTION(SQLGeneratorInterfaceImpl::makeCreateScriptForObject),
                             DECLARE_INTERFACE_FUNCTION(SQLGeneratorInterfaceImpl::makeSQLExportScript),
                             DECLARE_INTERFACE_FUNCTION(SQLGeneratorInterfaceImpl::makeSQLSyncScript));

  virtual std::string getTargetDBMSName()= 0;
  
  virtual int generateSQL(grt::Ref<GrtNamedObject>, const grt::DictRef& options, const std::string &/*, const grt::DictRef& result*/)= 0;
  virtual grt::StringRef generateReport(grt::Ref<GrtNamedObject> org_object, const grt::DictRef& options, const std::string &address1)= 0;
  virtual int makeSQLExportScript(grt::Ref<GrtNamedObject>, const grt::DictRef& options, const grt::DictRef& objectCreateSQL, const grt::DictRef& objectDropSQL)= 0;
  virtual int makeSQLSyncScript(const grt::DictRef& options,
                                const grt::StringListRef& sql_list,
                                const grt::ListRef<GrtNamedObject>& obj_list)= 0;
  virtual std::string makeCreateScriptForObject(GrtNamedObjectRef object)= 0;
};

#endif /* _SQLGENERATOR_IF_H_ */

