#ifndef _MYSQL_DB_PUBLIC_INTERFACE_H_
#define _MYSQL_DB_PUBLIC_INTERFACE_H_

#ifdef _WIN32

#ifdef WBPLUGINDBMYSQLBE_EXPORTS
#define WBPLUGINDBMYSQLBE_PUBLIC_FUNC __declspec(dllexport)
#else
#define WBPLUGINDBMYSQLBE_PUBLIC_FUNC __declspec(dllimport)
#endif

#else
#define WBPLUGINDBMYSQLBE_PUBLIC_FUNC
#endif

#include <string>
#include <map>

#include "grts/structs.db.mysql.h"

typedef std::map<std::string, GrtNamedObjectRef> CatalogMap;

WBPLUGINDBMYSQLBE_PUBLIC_FUNC 
void update_all_old_names(db_mysql_CatalogRef cat, bool update_only_empty, CatalogMap& map);

WBPLUGINDBMYSQLBE_PUBLIC_FUNC
void build_catalog_map(db_mysql_CatalogRef catalog, CatalogMap& map);

#endif // _MYSQL_DB_PUBLIC_INTERFACE_H_
