## -*- coding: utf-8 -*-
#
# «themes» - MCC Themes enablement plugin
#
# Copyright (C) 2009, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
from gtk import SENSITIVE

from mythbuntu_common.dictionaries import *

class ThemesPlugin(MCCPlugin):
    """Theme enablement"""

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "Themes"
        information["icon"] = "gtk-select-color"
        information["ui"] = "tab_themes"
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        #Dictionaries
        self.dictionary_state={}
        for list in get_theme_dictionary(self), \
                    get_artwork_dictionary(self):
            for item in list:
                self.dictionary_state[list[item]]=self.query_installed(item)

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        #Load the detected dictionary
        for item in self.dictionary_state:
            item.set_active(self.dictionary_state[item])

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        #Prepare for state capturing
        MCCPlugin.clearParentState(self)

        #Installable items
        for list in get_theme_dictionary(self), \
                    get_artwork_dictionary(self):
            for item in list:
                if list[item].get_active() != self.dictionary_state[list[item]]:
                    if list[item].get_active():
                        self._markInstall(item)
                    else:
                        self._markRemove(item)

    def toggle_meta(self,widget):
        """Toggles a large set of options at once"""
        if widget is not None:
            list=get_theme_dictionary(self)
            toggle=widget.get_active()
            for item in list:
                if list[item].flags() & SENSITIVE:
                    list[item].set_active(toggle)
