#!/usr/bin/python
# Mythbuntu-Log-Grabber core.py
# Copyright (C) 2008, Thomas Mashos <thomas@weilandhomes.com>
# Copyright (C) 2008, Nick Fox <nfox@foxmediasystems.com>
# This provides all the core features of Mythbuntu-Log-Grabber
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
import sys
import subprocess
import time
import logging
import logging.handlers

try:
	import gtk

except:
	sys.exit(1)

class MythbuntuLogGrabber:

	log_path = os.path.join(os.getenv("HOME"), '.mythtv')
	loglocation = os.path.join(log_path,"errorlogs.log")
	err_log = "/tmp/mythbuntu-log-grabber"
	logging.basicConfig(filename=err_log,level=logging.DEBUG,)

	if os.path.exists(loglocation):
		os.remove(loglocation)
	elif not os.path.exists(log_path):
		try:
			os.mkdir(log_path)
		except IOError:
			logging.Debug('An Exception occured while we tried to create the log gathering location.')
	SUBMITTED = False
	GATHERED = False


	def __init__(self):


		#Initialize GUI & Terminal
		self.builder = gtk.Builder()
		self.builder.add_from_file("/usr/share/mythbuntu-log-grabber/SubmitWindow.ui")

		#make widgets referencable from top level
		for widget in self.builder.get_objects():
			if not isinstance(widget, gtk.Widget):
				continue
			setattr(self, widget.get_name(), widget)

		#connect signals
		self.builder.connect_signals(self)

		#Get the Main Window, and connect the "destroy" event
		self.builder.get_object("MainWindow").connect("destroy", gtk.main_quit)

		if not self.GATHERED:
			self.btnpost.set_sensitive(False)
			self.btnview.set_sensitive(False)

		self.statusbar = self.builder.get_object("statusbar")

	def gather_logs_button_clicked(self, widget):
		## Gather all the logs and ready them for submitting

		self.SUBMITTED = False
		self.GATHERED = True

		os.system("tail -n 100 /var/log/mythtv/*.log /var/log/syslog /var/log/Xorg.0.log ~/.xsession-errors > "+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lsb_release -a <==" >> '+self.loglocation)
		os.system('lsb_release -a >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> df -h <==" >> '+self.loglocation)
		os.system('df -h >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> uname -a <==" >> '+self.loglocation)
		os.system('uname -a >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lspci <==" >> '+self.loglocation)
		os.system('lspci >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lsusb <==" >> '+self.loglocation)
		os.system('lsusb >> '+self.loglocation)

		if os.path.exists("/proc/driver/nvidia/"):
			os.system('tail -n 100 /proc/driver/nvidia/* >> '+self.loglocation)
			os.system('tail -n 100 /proc/driver/nvidia/cards/* >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lshw <==" >> '+self.loglocation)
		os.system('lshw -sanitize >> '+self.loglocation)

		if self.GATHERED:
			self.btnpost.set_sensitive(True)
			self.btnview.set_sensitive(True)

	def on_btnpost_clicked(self, widget):
		if self.GATHERED == True:
			if self.SUBMITTED == False:
				pastebinlocation = subprocess.Popen(["pastebinit", "-b", "http://mythbuntu.pastebin.com", "-i", self.loglocation],stdout=subprocess.PIPE).communicate()[0]
				self.Entry.set_text(pastebinlocation.strip())
				self.SUBMITTED = True
				self.btnpost.set_sensitive(False)
		else:
			self.Entry.set_text("Logs not gathered.  Please gather your logs.")

	def on_btnview_clicked(self, widget):
		i = 0
		if os.path.exists('/usr/bin/mousepad') and i < 1:
			subprocess.Popen(["mousepad", self.loglocation])
			i = i + 1
		elif os.path.exists('/usr/bin/gedit') and i < 1:
			subprocess.Popen(["gedit", self.loglocation])
			i = i + 1
		elif os.path.exists('/usr/bin/kate') and i < 1:
			subprocess.Popen(["kate", self.loglocation])
			i = i + 1
		else:
			subprocess.Popen(["nano", self.loglocation])

	def run(self):
		self.MainWindow.show()
		gtk.main()
