/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NACORE_DL_H
#define _NACORE_DL_H

#ifdef __cplusplus
extern "C" {
#endif

/* Dynamically loaded module handle */
typedef struct _nacore_dl_module * nacore_dl_module_t;

/*
 * Loads a dynamic module, returns NULL on failure.
 *
 * file is its filename (absolute path)
 */
nacore_dl_module_t nacore_dl_open(const char *file);

/*
 * Retrieves the address where a symbol is loaded or NULL in case of failure.
 *
 * handle is the dynamic module handle
 * symbol is the symbol name
 */
void * nacore_dl_sym(nacore_dl_module_t handle, const char *symbol);

/*
 * Unloads a dynamic module.
 *
 * handle is the dynamic module handle
 */
void nacore_dl_close(nacore_dl_module_t handle);

/*
 * Convenience function to filter dynamic modules based on their filenames when
 * scanning paths.
 *
 * file is the filename to filter
 */
char nacore_dl_filename_filter(const char *file);

#ifdef __cplusplus
}
#endif

#endif /* !_NACORE_DL_H */
