/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NACORE_MANIFEST_H
#define _NACORE_MANIFEST_H

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Prints the list of known Turtle prefixes in the file represented by fp.
 *
 * fp is the file handle
 */
void nacore_manifest_print_subject_prefixes(FILE *fp);

/*
 * Prints the triple "<URI> a lv2_Plugin ." corresponding to the given
 * descriptor in the file represented by fp.
 *
 * desc is the plugin descriptor
 * fp is the file handle
 */
void nacore_manifest_print_subject_triple(struct nacore_descriptor *desc,
					  FILE *fp);

/*
 * Prints all Turtle data (including prefixes) regarding a plugin in the file
 * represented by fp.
 *
 * desc is the plugin descriptor
 * fp is the file handle
 * binary is the value to print for the lv2:binary property (excluding < and >)
 */
void nacore_manifest_print_data(struct nacore_descriptor *desc, FILE *fp,
				const char *binary);

#ifdef __cplusplus
}
#endif

#endif /* !_NACORE_MANIFEST_H */
