/********************************************************************************
 *                              Nepenthes
 *                        - finest collection -
 *
 *
 *
 * Copyright (C) 2005  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

 /* $Id: OPTIXBindDialogue.cpp 1644 2005-07-14 16:19:15Z dp $ */

#include "vuln-optix.hpp"
#include "OPTIXBindDialogue.hpp"
#include "OPTIXDownloadHandler.hpp"

#include "SocketManager.hpp"
#include "Message.hpp"
#include "DownloadManager.hpp"
#include "LogManager.hpp"

#include "Utilities.hpp"

#include "DialogueFactoryManager.hpp"

#ifdef STDTAGS 
#undef STDTAGS 
#endif
#define STDTAGS l_mod

using namespace nepenthes;

/**
 * Dialogue::Dialogue(Socket *)
 * construktor for the OPTIXBindDialogue, creates a new OPTIXBindDialogue
 * 
 * 
 * 
 * @param socket the Socket the Dialogue has to use
 */
OPTIXBindDialogue::OPTIXBindDialogue(Socket *socket, OPTIXDownloadHandler *handler)
{
	m_Socket = socket;
    m_DialogueName = "OPTIXBindDialogue";
	m_DialogueDescription = "Optix Bindport Dialogue so we can handle timeouts";

	m_ConsumeLevel = CL_ASSIGN;
	m_DownloadHandler = handler;
}

OPTIXBindDialogue::~OPTIXBindDialogue()
{
	m_DownloadHandler->setDialogue(NULL);
	m_DownloadHandler->setSocket(NULL);
}

/**
 * Dialogue::incomingData(Message *)
 * 
 * @param msg the Message the Socker received.
 * 
 * 
 * @return CL_ASSIGN
 */
ConsumeLevel OPTIXBindDialogue::incomingData(Message *msg)
{
	return CL_ASSIGN;
}

/**
 * Dialogue::outgoingData(Message *)
 * as we are not interested in these socket actions 
 * we simply return CL_DROP to show the socket
 * 
 * @param msg
 * 
 * @return CL_DROP
 */
ConsumeLevel OPTIXBindDialogue::outgoingData(Message *msg)
{
	return m_ConsumeLevel;
}

/**
 * Dialogue::handleTimeout(Message *)
 * as we are not interested in these socket actions 
 * we simply return CL_DROP to show the socket
 * 
 * @param msg
 * 
 * @return CL_DROP
 */
ConsumeLevel OPTIXBindDialogue::handleTimeout(Message *msg)
{
	return CL_DROP;
}

/**
 * Dialogue::connectionLost(Message *)
 * as we are not interested in these socket actions 
 * we simply return CL_DROP to show the socket
 * 
 * @param msg
 * 
 * @return CL_DROP
 */
ConsumeLevel OPTIXBindDialogue::connectionLost(Message *msg)
{
	return CL_DROP;
}

/**
 * Dialogue::connectionShutdown(Message *)
 * as we are not interested in these socket actions 
 * we simply return CL_DROP to show the socket
 * 
 * @param msg
 * 
 * @return CL_DROP
 */
ConsumeLevel OPTIXBindDialogue::connectionShutdown(Message *msg)
{
	return CL_DROP;
}


