/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * LogoutPanel.java
 *
 * Created on Jan 27, 2010, 12:36:21 PM
 */

package org.netbeans.modules.kenai.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.Kenai.Status;

/**
 *
 * @author Jan Becicka
 */
public class LogoutPanel extends javax.swing.JPanel {

    private CheckListSupport support;

    /** Creates new form LogoutPanel */
    public LogoutPanel() {
        initComponents();
        kenaiList.setCellRenderer(new KenaiListRenderer());
        kenaiList.setModel(new KenaiComboModel(false, Status.ONLINE, Status.LOGGED_IN));
        support = new CheckListSupport(kenaiList);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        kenaiList = new javax.swing.JList();
        labelServers = new javax.swing.JLabel();

        setName("Form"); // NOI18N

        scrollPane.setName("scrollPane"); // NOI18N

        kenaiList.setName("kenaiList"); // NOI18N
        scrollPane.setViewportView(kenaiList);
        kenaiList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LogoutPanel.class, "LogoutPanel.kenaiList.AccessibleContext.accessibleDescription")); // NOI18N

        labelServers.setLabelFor(kenaiList);
        org.openide.awt.Mnemonics.setLocalizedText(labelServers, org.openide.util.NbBundle.getMessage(LogoutPanel.class, "LogoutPanel.labelServers.text")); // NOI18N
        labelServers.setName("labelServers"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 308, Short.MAX_VALUE)
                    .addComponent(labelServers))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(labelServers)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 87, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList kenaiList;
    private javax.swing.JLabel labelServers;
    private javax.swing.JScrollPane scrollPane;
    // End of variables declaration//GEN-END:variables

    public Collection<Kenai> getSelectedKenais() {
        Collection<Kenai> result = new ArrayList<Kenai>();
        for (int i=0;i<kenaiList.getModel().getSize(); i++) {
            if (support.getSelectionModel().isSelectedIndex(i)) {
                result.add((Kenai) kenaiList.getModel().getElementAt(i));
            }
        }
        return result;
    }

}
