/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_WINDOW_H_
#define _NL_WINDOW_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>

#define NL_TYPE_WINDOW (nl_window_get_type ())

#define NL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_WINDOW, NlWindow))

#define NL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_WINDOW, NlWindowClass))

#define NL_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_WINDOW))

#define NL_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_WINDOW))

#define NL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_WINDOW, NlWindowClass))

typedef struct _NlWindow        NlWindow;
typedef struct _NlWindowClass   NlWindowClass;
typedef struct _NlWindowPrivate NlWindowPrivate;
 
struct _NlWindow
{
  GtkWindow        parent;	

  NlWindowPrivate *priv;
};

struct _NlWindowClass
{
  GtkWindowClass   parent_class;
};

GType       nl_window_get_type    (void) G_GNUC_CONST;

GtkWidget * nl_window_get_default (void);

gboolean    nl_window_is_valid    (GtkWidget *window);

void        nl_window_set_transient (NlWindow *self, GtkWindow *window);

#endif /* _NL_WINDOW_H_ */

