Index: network-manager-0.9.1.90/src/nm-device.c
===================================================================
--- network-manager-0.9.1.90.orig/src/nm-device.c	2011-10-06 11:54:08.987680879 -0400
+++ network-manager-0.9.1.90/src/nm-device.c	2011-10-06 11:55:45.787682184 -0400
@@ -1861,6 +1861,10 @@
 		priv->ip6_ready = TRUE;
 		ret = NM_ACT_STAGE_RETURN_STOP;
 	} else if (ip6_method_matches (connection, NM_SETTING_IP6_CONFIG_METHOD_MANUAL)) {
+		/* Make sure there is an (unused) ip6_manager set, so we still
+		 * try to remove routes once the device is deactivated */
+		priv->ip6_manager = nm_ip6_manager_get ();
+
 		/* Router advertisements shouldn't be used in manual mode */
 		if (priv->ip6_accept_ra_path)
 			nm_utils_do_sysctl (priv->ip6_accept_ra_path, "0\n");
