/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddValueDN.cpp: implementation of the DlgAddValueDN class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddValueDN.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddValueDN, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddValueDN::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddValueDN::OnCancel)
END_EVENT_TABLE()


DlgAddValueDN::DlgAddValueDN(wxWindow * wParent, const DnSpecs & Value):wxDialog(wParent, (wxWindowID)-1, (Value?_("Modify DN Value"):_("Add DN Value")), wxDefaultPosition)
{
	m_IsOK = false;

	m_Value = Value;

	m_IsOK = false;
	DlgAddValueDN_SetWindow(this);

	if(m_Value)
	{
		char val[15];

		((wxTextCtrl *)FindWindow(IDC_NAME))->SetValue(m_Value.get_name().c_str());
		((wxTextCtrl *)FindWindow(IDC_DEFAULT))->SetValue(m_Value.get_default().c_str());
		((wxTextCtrl *)FindWindow(IDC_COMMENT))->SetValue(m_Value.get_comment().c_str());
		sprintf(val, "%ld", m_Value.get_min());
		((wxTextCtrl *)FindWindow(IDC_MIN))->SetValue(val);
		sprintf(val, "%ld", m_Value.get_max());
		((wxTextCtrl *)FindWindow(IDC_MAX))->SetValue(val);
	}

	CenterOnScreen();
	ShowModal();
}

DlgAddValueDN::~DlgAddValueDN()
{
}


const DnSpecs & DlgAddValueDN::GetValue()
{
	return m_Value;
}

bool DlgAddValueDN::IsOK()
{
	return m_IsOK;
}

void DlgAddValueDN::OnOk(wxCommandEvent& event)
{
	wxString Value;
	long uintValue;
	
	Value = ((wxTextCtrl *)FindWindow(IDC_NAME))->GetValue();
	if(!Value.Len()) return;
	m_Value.set_name(Value.GetData());

	Value = ((wxTextCtrl *)FindWindow(IDC_DEFAULT))->GetValue();	
	m_Value.set_default(Value.GetData());

	Value = ((wxTextCtrl *)FindWindow(IDC_COMMENT))->GetValue();
	m_Value.set_comment(Value.GetData());

	if(((wxTextCtrl *)FindWindow(IDC_MIN))->GetValue().Len())
		sscanf( ((wxTextCtrl *)FindWindow(IDC_MIN))->GetValue().GetData(), "%ld", &uintValue);
	else
		uintValue = 0;
	m_Value.set_min(uintValue);

	if(((wxTextCtrl *)FindWindow(IDC_MAX))->GetValue().Len())
		sscanf( ((wxTextCtrl *)FindWindow(IDC_MAX))->GetValue().GetData(), "%ld", &uintValue);
	else
		uintValue = 0;
	m_Value.set_max(uintValue);

	m_IsOK = true;
	Close(TRUE);
}
void DlgAddValueDN::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}
