/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgExtWizard.h: interface for the DlgExtWizard class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGEXTWIZARD_H
#define DLGEXTWIZARD_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/dialog.h>
#include <wx/notebook.h>

#include <openssl/x509v3.h>
#include <HashTable/HashTable_String.h>

class DlgExtWizard: public wxDialog
{
public:
	DlgExtWizard(wxWindow * wParent, HashTable_String * Exts);
	virtual ~DlgExtWizard();
	void OnPageChanged(wxNotebookEvent & event);
	void OnPageChanging(wxNotebookEvent & event);
	void OnAddNsCertTypeUsageValue(wxCommandEvent &event);
	void OnDelNsCertTypeValue(wxCommandEvent &event);
	void OnDelExtKeyUsageValue(wxCommandEvent& event);
	void OnAddExtKeyUsageValue(wxCommandEvent& event);
	void OnDelKeyUsageValue(wxCommandEvent& event);
	void OnAddKeyUsageValue(wxCommandEvent& event);
	void OnDelAuthInfoValue(wxCommandEvent& event);
	void OnAddAuthInfoValue(wxCommandEvent& event);
	void OnDelCrldpValue(wxCommandEvent& event);
	void OnAddCrldpValue(wxCommandEvent& event);
	void OnDelSubjAltValue(wxCommandEvent& event);
	void OnAddSubjAltValue(wxCommandEvent& event);
	void OnDelIssuAltValue(wxCommandEvent& event);
	void OnAddIssuAltValue(wxCommandEvent& event);

	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent& event);

	bool IsOK();
private:
	void WriteListExtension(char * ExtensioName, int crit_uid, int list_uid);
	void ListExtension(char * ExtensioName, int crit_uid, int list_uid);
	bool loading;
	void * GetExtensionInternal(const char * Name, const char * Value, bool & critical);
	void ParsePhase1();
	void ParsePhase2();
	void ParsePhase3();
	void ParsePhase4();
	void ModifyPhase1();
	void ModifyPhase2();
	void ModifyPhase3();
	void ModifyPhase4();


	HashTable_String m_SavedExts;
	HashTable_String * m_Exts;

	wxNotebook * Frame;
	bool v3_check_critical(char **value);
	bool m_IsOK;
	DECLARE_EVENT_TABLE()
};

#endif
