/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageUsers.cpp: implementation of the DlgManageUsers class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddUser.h"
#include "DlgGetNewPassword.h"
#include "DlgMessage.h"

#include "DlgManageUsers.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManageUsers, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManageUsers::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgManageUsers::OnCancel)
    EVT_BUTTON(IDC_ADD_USER, DlgManageUsers::OnAddUser)
    EVT_BUTTON(IDC_UPDATE_USER, DlgManageUsers::OnUpdateUser)
    EVT_BUTTON(IDC_CHANGE_PASSWORD, DlgManageUsers::OnChangePassword)
END_EVENT_TABLE()

DlgManageUsers::DlgManageUsers(wxWindow * wParent, PkiClient * ClientPKI):wxDialog(wParent, (wxWindowID)-1, _("Manage Users"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_ClientPKI = ClientPKI;
	m_OK = false;
	DlgManageUsers_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(ID_LISTCTRL));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Users_GetBitmap(IDB_USER_SMALL));
	m_imageListSmall->Add( ico );


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("User ID"), wxLIST_FORMAT_LEFT, 50);
	m_listCtrl->InsertColumn(1, _("Username"), wxLIST_FORMAT_LEFT, 150);
	m_listCtrl->InsertColumn(2, _("Active"), wxLIST_FORMAT_LEFT, 50);

	if(!ReloadList())
	{
		Close(TRUE);
		return;
	}


	CenterOnScreen();
	ShowModal();
	
}

DlgManageUsers::~DlgManageUsers()
{
	if(m_imageListSmall) delete m_imageListSmall;
}


bool DlgManageUsers::IsOK()
{
	return m_OK;
}

bool DlgManageUsers::ReloadList()
{
	size_t i;
	char tmpDatas[50];

	DlgMessage dlg(this);

	m_listCtrl->DeleteAllItems();
	m_users.clear();

	dlg.wShow(_("Loading User(s) List..."));
	if(!m_ClientPKI->EnumUsers(m_users))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return false;
	}
	dlg.wHide();

	for(i=0; i<m_users.size(); i++)
	{
		sprintf(tmpDatas, "%ld", m_users[i].get_userId());

		m_listCtrl->InsertItem(i, tmpDatas, 0);
		m_listCtrl->SetItemData(i, (long)i);

		m_listCtrl->SetItem(i, 1, m_users[i].get_userInfo().get_name().c_str());
		m_listCtrl->SetItem(i, 2, (m_users[i].get_userInfo().get_activated()?"True":"False"));
	}
	return true;
}

void DlgManageUsers::OnAddUser(wxCommandEvent& event)
{
	DlgAddUser Dlg(this, UserEntry::EmptyInstance);
	const UserEntry & mVal = Dlg.GetUserInfos();
	if(!mVal) return;


	DlgMessage dlgMsg(this);

	dlgMsg.wShow(_("Creating User..."));
	if(!m_ClientPKI->CreateUser(mVal.get_userInfo()))
	{
		dlgMsg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlgMsg.wHide();

	ReloadList();
}

void DlgManageUsers::OnUpdateUser(wxCommandEvent& event)
{
	size_t Index;
	long SelectedItem;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	Index = (size_t)m_listCtrl->GetItemData(SelectedItem);
	
	DlgAddUser Dlg(this, m_users[Index]);
	const UserEntry& mVal = Dlg.GetUserInfos();

	DlgMessage dlgMsg(this);
	dlgMsg.wShow(_("Updating User..."));
	if(!m_ClientPKI->UpdateUser(mVal))
	{
		dlgMsg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlgMsg.wHide();

	ReloadList();
}

void DlgManageUsers::OnChangePassword(wxCommandEvent& event)
{
	size_t Index;
	ChangeUserPasswd NewPwd;
	long SelectedItem;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	Index = (size_t)m_listCtrl->GetItemData(SelectedItem);
	
	DlgGetNewPassword Dlg(this);
	if(!Dlg.IsOK()) return;

	const mString & password = Dlg.GetPassword();
	if(!password.size()) return;

	DlgMessage dlgMsg(this);

	NewPwd.set_userId(m_users[Index].get_userId());
	NewPwd.set_password(password);

	dlgMsg.wShow(_("Updating Password..."));
	if(!m_ClientPKI->ChangeUserPassword(NewPwd))
	{
		dlgMsg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlgMsg.wHide();
}

void DlgManageUsers::OnOk(wxCommandEvent& event)
{
	m_OK = true;
	Close(TRUE);
}

void DlgManageUsers::OnCancel(wxCommandEvent& event)
{
	m_OK = false;
	Close(TRUE);
}

