/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgPublishCSR.h: interface for the DlgPublishCSR class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGPUBLISHCSR_H
#define DLGPUBLISHCSR_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/dialog.h>


/*!
	Cette classe se charge de gnrer une demande de certificat
*/
#include <stdio.h>
#include "Error.h"
#include <PkiClient.h>
#include "DlgMessage.h"
#include "DlgCsrProperties.h"

#include <sys/stat.h>


class DlgPublishCSR: public wxDialog 
{
public:
	void OnImport(wxCommandEvent& event);
	/*!
		Le constructeur<BR>
			<B>HINSTANCE hInstance</B>	: L'instance de l'application<BR>
			<B>HWND ParentWindow</B>	: La handle de la fenetre parente
	*/
	DlgPublishCSR(wxWindow * wParent, PkiClient * ClientPki);

	/*!
		Le destructeur
	*/
	virtual ~DlgPublishCSR();

	void OnShow(wxCommandEvent& event);
	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent &event);
	bool IsOk();

private:
	bool m_IsOk;
	PkiClient * m_ClientPki;
	PKI_CSR mCsr;
	DECLARE_EVENT_TABLE()
};

#endif
