/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Connection.h: interface for the Connection class.
//
//////////////////////////////////////////////////////////////////////

#ifndef CONNECTION_H
#define CONNECTION_H

#include "NewPKI.h"
#include "UnixWinSock.h"
#include "PKI_ERR.h"

#include <openssl/bio.h>
#include <openssl/err.h>

#include <mString.h>

#include "ASN1/Asn1Req.h"
#include "ASN1/Asn1Resp.h"

/*!
	This class represents a client connection
*/
class Connection  
{
public:
	/*! \brief This is the constructor.
	 */
	Connection();

	/*! \brief This is the destructor.
	 */
	virtual ~Connection();

	/*! \brief This function sets the host to connect to.
	 *  \param host [IN] The host.
	 */
	void set_host(const mString & host);
	
	/*! \brief This function sets the port to connect to.
	 *  \param port [IN] The port.
	 */
	void set_port(unsigned short port);
	
	/*! \brief This function return the host.
	 *  \return The host.
	 */
	const mString & get_host() const;
	
	/*! \brief This function return the port.
	 *  \return The port.
	 */
	unsigned short get_port() const;
	
	/*! \brief This function is called to establish the connection.
	 *  \return true on success, false on failure.
	 */
	virtual bool connect()=0;
	
	/*! \brief This function closes the connection.
	 */
	virtual void close()=0;
	
	/*! \brief This function sends a request.
	 *  \param request [IN] The request.
	 *  \param response [OUT] The response.
	 *  \param ReadTimeout [IN] An optional timeout.
	 *  \return true on success, false on failure.
	 */
	virtual bool SendRequest(const AdminRequest & request, AdminResponse & response, int ReadTimeout = 0)=0;
	
	/*! \brief This function returns the socket.
	 *  \return The socket.
	 */
	SOCKET get_socket() const;
	
	/*! \brief This function returns the entity certificate.
	 *  \return The certificate.
	 */
	const PKI_CERT & get_EntityCert() const;

protected:
	/*! \brief This function closes the connection.
	 */
	void do_close();

	/*! \brief This function does the connection.
	 */
	bool do_connection();

	/*! \brief This function sends a request.
	 *  \param connection [IN] The connection.
	 *  \param request [IN] The request.
	 *  \param response [OUT] The response.
	 *  \param ReadTimeout [IN] An optional timeout.
	 *  \return true on success, false on failure.
	 */
	bool do_send(BIO *connection, const AdminRequest &request, AdminResponse &response, int ReadTimeout);

	SOCKET m_socket; //!< The socket connection
	mString m_host; //!< The host
	unsigned short m_port;	//!< The port
	PKI_CERT m_entity_cert;	//!< The entity cert
};

#endif
