/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/





// PKI_PASSWD.h: interface for the PKI_PASSWD class.
//
//////////////////////////////////////////////////////////////////////

#ifndef PKI_PASSWD_H
#define PKI_PASSWD_H

#include <stdio.h>
#include <string.h>

#include <openssl/rand.h>
#include <openssl/sha.h>
#include <mString.h>


/*!
	This class handles passwords 
*/
class PKI_PASSWD  
{
public:
	/*! \brief This is the constructor.
	 */
	PKI_PASSWD();

	/*! \brief This is the destructor.
	 */
	virtual ~PKI_PASSWD();

	/*! \brief This function verifies as password.
	 *  \param Password [IN] The password in clear text.
	 *  \param Sha1Password [IN] The crypted password.
	 *  \return true on success, false on failure.
	 */
	bool VerifySHA1Password(const mString & Password, const mString & Sha1Password);

	/*! \brief This function generates a crypted password.
	 *  \param Password [IN] The password in clear text.
	 *  \return The generated password, or NULL on failure.
	 */
	char * CalcSHA1Password(const mString & Password);
private:
	#define SALT_LEN 8
	char hex_password[(SALT_LEN + SHA_DIGEST_LENGTH)*2 + 1];
};

#endif
