/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// ReadersWriter.cpp: implementation of the ReadersWriter class.
//
//////////////////////////////////////////////////////////////////////

#include "ReadersWriter.h"
#include <assert.h>
#include <string.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ReadersWriter::ReadersWriter()
{
	write_ctr = 0;
	read_ctr = 0;
	m_WriterWantsLockCount = 0;
	#ifdef _DEBUG
		m_stIndex = 0;
		memset(&m_stLockers, 0, sizeof(m_stLockers));
	#endif
}

ReadersWriter::~ReadersWriter()
{

}

void ReadersWriter::LockRead() const
{
	std::map< NEWPKI_THREAD_ID, long >::iterator entry;
	NEWPKI_THREAD_ID thread_id;

	thread_id = NewpkiThread::CurrentThreadId();

	LockerAcc.EnterCS();
	((ReadersWriter*)this)->read_ctr++;
	//Am I the first reader ?
	if(read_ctr == 1)
	{
		write_lock.Wait();	//Take ownership
	}
	entry = ((ReadersWriter*)this)->m_ReadersList.find(thread_id);
	if(entry == ((ReadersWriter*)this)->m_ReadersList.end())
		((ReadersWriter*)this)->m_ReadersList[thread_id] = 1;
	else
		entry->second++;
	LockerAcc.LeaveCS();
}

#ifdef _DEBUG
void ReadersWriter::DoLockWrite(const char * file, int line)
#else
void ReadersWriter::LockWrite()
#endif
{
	std::map< NEWPKI_THREAD_ID, long >::iterator entry;
	NEWPKI_THREAD_ID thread_id;

	thread_id = NewpkiThread::CurrentThreadId();

	LockerAcc.EnterCS();

	/*
	 *	Am I the first writer for this thread ?
	 */
	if(write_ctr <= 0)
	{
		/*
		 *	Do I already have a Read access for this thread ?
		 *	If yes it means we're trying to upgrade our access
		 */
		entry = m_ReadersList.find(thread_id);
		if(entry != m_ReadersList.end())
		{
			/*
			 *	Save up the current threads number of readers
			 */
			m_UnlockedReadersList[thread_id] = entry->second;
			read_ctr -= entry->second;
			m_ReadersList.erase(entry);
			if(m_ReadersList.size())
			{
				/*
				 *	Yes, before trying to take the Lock I need
				 *	to wait for all other threads to have release
				 *	their Read Access
				 */
				while( m_ReadersList.size() )
				{
					LockerAcc.LeaveCS();
					NewpkiThread::Sleep(50);
					LockerAcc.EnterCS();
				}
			}
			else
			{
				/*
				 *	We must release the Lock
				 *	that was acquired in LockRead
				 */
				write_lock.Post();
			}
		}
		else
		{
			/*
			 *	Another thread has a Read access,
			 *	we must make sure it's done before acquiring the Lock
			 */
			while( read_ctr )
			{
				LockerAcc.LeaveCS();
				NewpkiThread::Sleep(50);
				LockerAcc.EnterCS();
			}
		}
	}
	write_ctr++;
	write_lock.Wait();	//Take ownership

#ifdef _DEBUG
	m_stLockers[m_stIndex].file = file;
	m_stLockers[m_stIndex].line = line;
	m_stIndex++;
#endif
}

void ReadersWriter::UnlockWrite() const
{
	long i;
	std::map< NEWPKI_THREAD_ID, long >::iterator entry;

	assert(write_ctr > 0);
	if (write_ctr > 0)
	{
		((ReadersWriter*)this)->write_ctr--;
#ifdef _DEBUG
		assert(m_stIndex > 0);
		((ReadersWriter*)this)->m_stIndex--;
#endif
		write_lock.Post(); //Release ownership
		/*
		 *	I released all my Writer accesses.
		 *	If I unlocked some of my readers,
		 *	I need to regain them
		 */
		if(write_ctr == 0)
		{
			entry = ((ReadersWriter*)this)->m_UnlockedReadersList.find(NewpkiThread::CurrentThreadId());
			if(entry != ((ReadersWriter*)this)->m_UnlockedReadersList.end())
			{
				for(i=0; i<entry->second; i++)
					LockRead();
				((ReadersWriter*)this)->m_UnlockedReadersList.erase(entry);
			}
		}
		LockerAcc.LeaveCS();
	}
}

void ReadersWriter::UnlockRead() const
{
	std::map< NEWPKI_THREAD_ID, long >::iterator entry;

	LockerAcc.EnterCS();

	assert(read_ctr > 0);
	if(read_ctr > 0)
	{
		((ReadersWriter*)this)->read_ctr--;
		// Am I the last reader ?
		if (read_ctr == 0)
			write_lock.Post(); //Release ownership

		entry = ((ReadersWriter*)this)->m_ReadersList.find(NewpkiThread::CurrentThreadId());
		assert(entry != ((ReadersWriter*)this)->m_ReadersList.end());
		if(entry != ((ReadersWriter*)this)->m_ReadersList.end())
		{
			if(entry->second == 1)
				((ReadersWriter*)this)->m_ReadersList.erase(entry);
			else
				entry->second--;
		}
	}
	LockerAcc.LeaveCS();
}
