/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#if defined(_WIN32) && !defined(NO_BIO_MS_SSL)

#include "SspiConnection.h"

SspiConnection::SspiConnection():Connection()
{
	m_certificate = NULL;
	m_connection = NULL;
}

SspiConnection::~SspiConnection()
{
	if(m_certificate)
	{
		CertFreeCertificateContext(m_certificate);
		m_certificate = NULL;
	}
	close();
}

bool SspiConnection::set_certificate(PCCERT_CONTEXT cert)
{
	if(m_certificate)
	{
		CertFreeCertificateContext(m_certificate);
	}
	if(! (m_certificate = CertDuplicateCertificateContext(cert)) )
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	return true;
}

bool SspiConnection::connect()
{
	BIO * sbio;
	if(!m_certificate)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_PARAM);
		return false;
	}

	close();
	if(!do_connection())
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	sbio = BIO_new_socket(m_socket, BIO_NOCLOSE);
	if(!sbio)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	m_connection = BIO_new_ms_ssl(sbio, (PCERT_CONTEXT)m_certificate);
	if(!m_connection)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		BIO_free_all(sbio);
		return false;
	}
	if(!BIO_ms_ssl_connect(m_connection))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		BIO_free_all(sbio);
		return false;
	}
	return true;
}

void SspiConnection::close()
{
	if(m_connection)
	{
		BIO_free_all(m_connection);
		m_connection = NULL;
	}
	do_close();
}


bool SspiConnection::GetPeerCertificate(PKI_CERT &PeerCert)
{
	X509 * cert;
	if(!m_certificate)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_PARAM);
		return false;
	}
	if(! (cert = BIO_ms_ssl_get_peer(m_connection)) )
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!PeerCert.SetCert(cert))
	{
		X509_free(cert);
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	X509_free(cert);
	return true;
}

bool SspiConnection::SendRequest(const AdminRequest &request, AdminResponse &response, int ReadTimeout)
{
	if(!do_send(m_connection, request, response, ReadTimeout))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

#endif
