/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// mVector.h: interface for the mVector class.
//
//////////////////////////////////////////////////////////////////////

#ifndef MVECTOR_H
#define MVECTOR_H

#include <vector>
using namespace std;



/*!
	This class represents a vector.
*/
template<class _Ty>
	class mVector : public vector<_Ty>
{
public:
	/*! \brief This is the constructor.
	 */
	mVector():vector<_Ty>()
	{
	}

	/*! \brief This is the destructor.
	 */
	~mVector()
	{
	}

	/*! \brief This function inserts an entry in the vector.
	 *  \param _PP [IN] the position to insert the entry.
	 *  \param _XX [IN] the entry to insert.
	 *  \return The newly inserted iterator.
	 */
	typename std::vector<_Ty>::iterator insert(typename std::vector<_Ty>::iterator _PP, const _Ty& _XX = _Ty())
	{
		return vector<_Ty>::insert(_PP, _XX);
	}
	
	/*! \brief This function inserts an entry in the vector.
	 *  \param _PP [IN] the position to insert the entry.
	 *  \param _FF [IN] the first iterator to insert.
	 *  \param _LL [IN] the last iterator to insert.
	 */
	void insert(typename std::vector<_Ty>::iterator _PP, typename std::vector<_Ty>::const_iterator _FF, typename std::vector<_Ty>::const_iterator _LL)
	{
		vector<_Ty>::insert(_PP, _FF, _LL);
	}
	
	/*! \brief This member is an empty instance of mVector.
	 */
	static mVector<_Ty> EmptyInstance;
};

template <class _Ty> mVector<_Ty> mVector<_Ty>::EmptyInstance;

#endif
