/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Transitions
*/

#ifndef __TRANSITIONS_H_INCLUDED__
#define __TRANSITIONS_H_INCLUDED__

struct Transition
{
	unsigned short	*screen1;
	unsigned short	*screen2;
	int		pitch1;
	int		pitch2;
	SDL_Surface	*tempScreen;
	SDL_Surface	*saveScreen;
	
	Transition();
	virtual ~Transition();
	
	void grab(unsigned short *target);
	void begin();
	void end();
	void updateScreen();
	
	void beginPlay();

	virtual void play()=0;
};

struct RevealTransition : public Transition
{
	RevealTransition();
	virtual ~RevealTransition();
	
	virtual void play();
};

struct LinesTransition : public Transition
{
	LinesTransition();
	virtual ~LinesTransition();
	
	virtual void play();
};

struct MosaicTransition : public Transition
{
	MosaicTransition();
	virtual ~MosaicTransition();
	
	void bar(int x1, int y1, int x2, int y2, int color);
	void applyMosaic(int size, unsigned short *from, int pitch);
	
	virtual void play();
};

struct DoubleLinesTransition : public Transition
{
	DoubleLinesTransition();
	virtual ~DoubleLinesTransition();
	
	virtual void play();
};

Transition *createRandomTransition();

#endif

