#include <cppunit/extensions/HelperMacros.h>

#include <sstream>

#include "../TargetRetrieverARC1.h"

#define TESTEXTRACTTARGETS

static Arc::Logger testLogger(Arc::Logger::getRootLogger(), "TargetRetrieverARC1Test");

class TargetRetrieverARC1Test
  : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(TargetRetrieverARC1Test);
#ifdef TESTEXTRACTTARGETS
  CPPUNIT_TEST(TestExtractTargets);
#endif
  CPPUNIT_TEST_SUITE_END();

public:
  TargetRetrieverARC1Test() {};

  void setUp() {}
  void tearDown() {}

#ifdef TESTEXTRACTTARGETS
  void TestExtractTargets();
#endif
};


#ifdef TESTEXTRACTTARGETS
void TargetRetrieverARC1Test::TestExtractTargets()
{
  Arc::XMLNode response("<Response>"
  "<ComputingService CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\"  BaseType=\"Service\">"
    "<Name>NIIF PGS CE</Name>"
    "<OtherInfo>warning: frequent reconfiguration</OtherInfo>"
    "<Capability>executionmanagement.jobexecution</Capability>"
    "<Type>org.nordugrid.arex</Type>"
    "<QualityLevel>pre-production</QualityLevel>"
    "<StatusInfo>http://arex.niif.hu/status</StatusInfo>"
    "<Complexity>endpointType=1,share=2,resource=1</Complexity>"
    "<Location CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
      "<Name>Budapest, Hungary</Name>"
      "<Address>Victor Hugo 11</Address>"
      "<Place>Budapest</Place>"
      "<Country>Hungary</Country>"
      "<PostCode>HU-1200</PostCode>"
      "<Latitude>47.51</Latitude>"
      "<Longitude>19.05</Longitude>"
    "</Location>"
    "<Contact CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
      "<Name>PGS CE support</Name>"
      "<OtherInfo>Only for NIIF users</OtherInfo>"
      "<Detail>mailto:pgs-support@niif.hu</Detail>"
      "<Type>usersupport</Type>"
    "</Contact>"
    "<Contact CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
      "<Name>NIIF security contact</Name>"
      "<OtherInfo>Please only security related issues</OtherInfo>"
      "<Detail>mailto:security@niif.hu</Detail>"
      "<Type>security</Type>"
    "</Contact>"
    "<TotalJobs>36</TotalJobs>"
    "<RunningJobs>3</RunningJobs>"
    "<WaitingJobs>6</WaitingJobs>"
    "<StagingJobs>7</StagingJobs>"
    "<SuspendedJobs>4</SuspendedJobs>"
    "<PreLRMSWaitingJobs>16</PreLRMSWaitingJobs>"
    "<ComputingEndpoint CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\" BaseType=\"Endpoint\">"
      "<Name>AREX</Name>"
      "<URL>https://ce01.niif.hu:60000/arex</URL>"
      "<Capability>executionmanagement.jobexecution</Capability>"
      "<Technology>webservice</Technology>"
      "<InterfaceName>OGSA-BES</InterfaceName>"
      "<InterfaceVersion>1.0</InterfaceVersion>"
      "<InterfaceVersion>2.0</InterfaceVersion>"
      "<InterfaceExtension>http://nordugrid.org/ws/bes-ng</InterfaceExtension>"
      "<InterfaceExtension>http://nordugrid.org/ws/bes++</InterfaceExtension>"
      "<WSDL>https://ce01.niif.hu:60000/arex/?wsdl</WSDL>"
      "<SupportedProfile>http://www.ws-i.org/Profiles/BasicProfile-1.0.html</SupportedProfile>"
      "<SupportedProfile>urn:ogf:specs:HPC-BP</SupportedProfile>"
      "<Semantics>http://www.nordugrid.org/documents/arex.pdf</Semantics>"
      "<Implementor>NorduGrid</Implementor>"
      "<ImplementationName>ARC</ImplementationName>"
      "<ImplementationVersion>0.9</ImplementationVersion>"
      "<QualityLevel>testing</QualityLevel>"
      "<HealthState>ok</HealthState>"
      "<HealthStateInfo>normal operation</HealthStateInfo>"
      "<ServingState>draining</ServingState>"
      "<StartTime>2008-04-12T09:47:53Z</StartTime>"
      "<IssuerCA>/O=Grid/O=NorduGrid/CN=NorduGrid Certification Authority</IssuerCA>"
      "<TrustedCA>/O=Grid/O=NorduGrid/CN=NorduGrid Certification Authority</TrustedCA>"
      "<TrustedCA>/C=HU/O=NIIF/OU=Certificate Authorities/CN=NIIF Root CA</TrustedCA>"
      "<DowntimeAnnounce>2008-03-12T09:59:56Z</DowntimeAnnounce>"
      "<DowntimeStart>2008-04-29T09:57:56Z</DowntimeStart>"
      "<DowntimeEnd>2008-04-30T09:59:56Z</DowntimeEnd>"
      "<DowntimeInfo>Opsys update</DowntimeInfo>"
      "<Staging>staginginout</Staging>"
      "<JobDescription>nordugrid:xrsl</JobDescription>"
      "<JobDescription>jsdl:1.0</JobDescription>"
      "<TotalJobs>36</TotalJobs>"
      "<RunningJobs>3</RunningJobs>"
      "<WaitingJobs>6</WaitingJobs>"
      "<StagingJobs>7</StagingJobs>"
      "<SuspendedJobs>4</SuspendedJobs>"
      "<PreLRMSWaitingJobs>16</PreLRMSWaitingJobs>"
    "</ComputingEndpoint>"
    "<ComputingShare CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\" BaseType=\"Share\">"
      "<Name>Atlas production</Name>"
      "<Description>a share set up for Atlas users</Description>"
      "<MappingQueue>pbs-short</MappingQueue>"
      "<MaxWallTime>12000</MaxWallTime>"
      "<MaxMultiSlotWallTime>12000</MaxMultiSlotWallTime>"
      "<MinWallTime>2000</MinWallTime>"
      "<DefaultWallTime>9000</DefaultWallTime>"
      "<MaxCPUTime>12000</MaxCPUTime>"
      "<MaxTotalCPUTime>48000</MaxTotalCPUTime>"
      "<MinCPUTime>2000</MinCPUTime>"
      "<DefaultCPUTime>11</DefaultCPUTime>"
      "<MaxTotalJobs>500</MaxTotalJobs>"
      "<MaxRunningJobs>50</MaxRunningJobs>"
      "<MaxWaitingJobs>200</MaxWaitingJobs>"
      "<MaxPreLRMSWaitingJobs>400</MaxPreLRMSWaitingJobs>"
      "<MaxUserRunningJobs>8</MaxUserRunningJobs>"
      "<MaxSlotsPerJob>4</MaxSlotsPerJob>"
      "<MaxStateInStreams>3</MaxStateInStreams>"
      "<MaxStageOutStreams>2</MaxStageOutStreams>"
      "<SchedulingPolicy>fairshare</SchedulingPolicy>"
      "<MaxMainMemory>2048</MaxMainMemory>"
      "<GuaranteedMainMemory>1000</GuaranteedMainMemory>"
      "<MaxVirtualMemory>16000</MaxVirtualMemory>"
      "<GuaranteedVirtualMemory>6000</GuaranteedVirtualMemory>"
      "<MaxDiskSpace>5</MaxDiskSpace>"
      "<DefaultStorageService>uri:ogf:StorageService:HU/NIIF/SE01</DefaultStorageService>"
      "<Preemption>true</Preemption>"
      "<ServingState>production</ServingState>"
      "<TotalJobs>20</TotalJobs>"
      "<RunningJobs>5</RunningJobs>"
      "<LocalRunningJobs>4</LocalRunningJobs>"
      "<WaitingJobs>1</WaitingJobs>"
      "<LocalWaitingJobs>1</LocalWaitingJobs>"
      "<SuspendedJobs>2</SuspendedJobs>"
      "<LocalSuspendedJobs>2</LocalSuspendedJobs>"
      "<StagingJobs>1</StagingJobs>"
      "<PreLRMSWaitingJobs>1</PreLRMSWaitingJobs>"
      "<EstimatedAverageWaitingTime>12000</EstimatedAverageWaitingTime>"
      "<EstimatedWorstWaitingTime>70000</EstimatedWorstWaitingTime>"
      "<FreeSlots>14</FreeSlots>"
      "<FreeSlotsWithDuration>4:12000 14:3000</FreeSlotsWithDuration>"
      "<UsedSlots>7</UsedSlots>"
      "<RequestedSlots>378</RequestedSlots>"
      "<ReservationPolicy>none</ReservationPolicy>"
      "<Tag>HEPPO</Tag>"
      "<Tag>MIT12</Tag>"
      "<Associations>"
        "<ExecutionEnvironmentID>dualsocket</ExecutionEnvironmentID>"
      "</Associations>"
    "</ComputingShare>"
    "<ComputingShare CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\" BaseType=\"Share\">"
      "<Name>NIIF</Name>"
      "<Description>a share set up for NIIF users</Description>"
      "<MappingQueue>pbs-long</MappingQueue>"
      "<MaxWallTime>2000</MaxWallTime>"
      "<MaxMultiSlotWallTime>2000</MaxMultiSlotWallTime>"
      "<MinWallTime>0</MinWallTime>"
      "<DefaultWallTime>2000</DefaultWallTime>"
      "<MaxCPUTime>2000</MaxCPUTime>"
      "<MaxTotalCPUTime>16000</MaxTotalCPUTime>"
      "<MinCPUTime>0</MinCPUTime>"
      "<DefaultCPUTime>2000</DefaultCPUTime>"
      "<MaxTotalJobs>500</MaxTotalJobs>"
      "<MaxRunningJobs>50</MaxRunningJobs>"
      "<MaxWaitingJobs>200</MaxWaitingJobs>"
      "<MaxPreLRMSWaitingJobs>400</MaxPreLRMSWaitingJobs>"
      "<MaxUserRunningJobs>1</MaxUserRunningJobs>"
      "<MaxSlotsPerJob>16</MaxSlotsPerJob>"
      "<MaxStateInStreams>3</MaxStateInStreams>"
      "<MaxStageOutStreams>2</MaxStageOutStreams>"
      "<SchedulingPolicy>fifo</SchedulingPolicy>"
      "<MaxMainMemory>1</MaxMainMemory>"
      "<GuaranteedMainMemory>1</GuaranteedMainMemory>"
      "<MaxVirtualMemory>1</MaxVirtualMemory>"
      "<GuaranteedVirtualMemory>1</GuaranteedVirtualMemory>"
      "<MaxDiskSpace>20</MaxDiskSpace>"
      "<DefaultStorageService>uri:ogf:StorageService:HU/NIIF/SE01</DefaultStorageService>"
      "<Preemption>true</Preemption>"
      "<ServingState>draining</ServingState>"
      "<TotalJobs>40</TotalJobs>"
      "<RunningJobs>30</RunningJobs>"
      "<LocalRunningJobs>0</LocalRunningJobs>"
      "<WaitingJobs>1</WaitingJobs>"
      "<LocalWaitingJobs>1</LocalWaitingJobs>"
      "<SuspendedJobs>12</SuspendedJobs>"
      "<LocalSuspendedJobs>12</LocalSuspendedJobs>"
      "<StagingJobs>1</StagingJobs>"
      "<PreLRMSWaitingJobs>0</PreLRMSWaitingJobs>"
      "<EstimatedAverageWaitingTime>200</EstimatedAverageWaitingTime>"
      "<EstimatedWorstWaitingTime>2000</EstimatedWorstWaitingTime>"
      "<FreeSlots>14</FreeSlots>"
      "<FreeSlotsWithDuration>1:2000 7</FreeSlotsWithDuration>"
      "<UsedSlots>7</UsedSlots>"
      "<RequestedSlots>378</RequestedSlots>"
      "<ReservationPolicy>none</ReservationPolicy>"
      "<Tag>TT1</Tag>"
      "<Tag>HH12</Tag>"
      "<Associations>"
        "<ExecutionEnvironmentID>dualcore</ExecutionEnvironmentID>"
      "</Associations>"
    "</ComputingShare>"
    "<ComputingManager CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\" BaseType=\"Manager\">"
      "<Name>torque</Name>"
      "<OtherInfo></OtherInfo>"
      "<ProductName>torque</ProductName>"
      "<ProductVersion>2.3.3</ProductVersion>"
      "<Reservation>false</Reservation>"
      "<BulkSubmission>false</BulkSubmission>"
      "<TotalPhysicalCPUs>32</TotalPhysicalCPUs>"
      "<TotalLogicalCPUs>96</TotalLogicalCPUs>"
      "<TotalSlots>96</TotalSlots>"
      "<SlotsUsedByLocalJobs>40</SlotsUsedByLocalJobs>"
      "<SlotsUsedByGridJobs>20</SlotsUsedByGridJobs>"
      "<Homogeneous>false</Homogeneous>"
      "<NetworkInfo>infiniband</NetworkInfo>"
      "<NetworkInfo>gigabitethernet</NetworkInfo>"
      "<LogicalCPUDistribution>4:16 2:16</LogicalCPUDistribution>"
      "<WorkingAreaShared>true</WorkingAreaShared>"
      "<WorkingAreaGuaranteed>false</WorkingAreaGuaranteed>"
      "<WorkingAreaTotal>6005</WorkingAreaTotal>"
      "<WorkingAreaFree>3405</WorkingAreaFree>"
      "<WorkingAreaLifeTime>604800</WorkingAreaLifeTime>"
      "<WorkingAreaMultiSlotTotal>4134</WorkingAreaMultiSlotTotal>"
      "<WorkingAreaMultiSlotFree>405</WorkingAreaMultiSlotFree>"
      "<WorkingAreaMultiSlotLifeTime>604800</WorkingAreaMultiSlotLifeTime>"
      "<CacheTotal>10232</CacheTotal>"
      "<CacheFree>3405</CacheFree>"
      "<TmpDir>/tmp</TmpDir>"
      "<ScratchDir>/shared/scratch</ScratchDir>"
      "<ApplicationDir>/shared/Apps</ApplicationDir>"
      "<Benchmark CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
        "<Name>Specfp2000</Name>"
        "<OtherInfo>Compiler: gcc version 3.4.6 20060404</OtherInfo>"
        "<OtherInfo>Optimization flags: -O5 -msse3</OtherInfo>"
        "<Type>specfp2000</Type>"
        "<Value>956.876</Value>"
      "</Benchmark>"
      "<Benchmark CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
        "<Name>jbench</Name>"
        "<OtherInfo>JVM options: -d64 -server</OtherInfo>"
        "<Type>jbench</Type>"
        "<Value>3399.0</Value>"
      "</Benchmark>"
      "<Benchmark CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
        "<Type>bogomips</Type>"
        "<Value>2399.0</Value>"
      "</Benchmark>"
      "<ExecutionEnvironments>"
        "<ExecutionEnvironment CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\" BaseType=\"Resource\">"
          "<Name>dualsocket</Name>"
          "<Platform>amd64</Platform>"
          "<VirtualMachine>false</VirtualMachine>"
          "<TotalInstances>16</TotalInstances>"
          "<UsedInstances>15</UsedInstances>"
          "<UnavailableInstances>1</UnavailableInstances>"
          "<PhysicalCPUs>2</PhysicalCPUs>"
          "<LogicalCPUs>4</LogicalCPUs>"
          "<CPUMultiplicity>multicpu-multicore</CPUMultiplicity>"
          "<CPUVendor>AMD</CPUVendor>"
          "<CPUModel>Dual Core AMD Opteron(tm) Processor 275</CPUModel>"
          "<CPUVersion>2</CPUVersion>"
          "<CPUClockSpeed>2193</CPUClockSpeed>"
          "<CPUTimeScalingFactor>2.45</CPUTimeScalingFactor>"
          "<WallTimeScalingFactor>2.45</WallTimeScalingFactor>"
          "<MainMemorySize>4096</MainMemorySize>"
          "<VirtualMemorySize>20230</VirtualMemorySize>"
          "<OSFamily>linux</OSFamily>"
          "<OSName>centos</OSName>"
          "<OSVersion>5.4</OSVersion>"
          "<ConnectivityIn>true</ConnectivityIn>"
          "<ConnectivityOut>false</ConnectivityOut>"
          "<NetworkInfo>gigabitethernet</NetworkInfo>"
          "<NetworkInfo>infiniband</NetworkInfo>"
        "</ExecutionEnvironment>"
        "<ExecutionEnvironment CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\" BaseType=\"Resource\">"
          "<Name>dualcore</Name>"
          "<Platform>amd64</Platform>"
          "<VirtualMachine>false</VirtualMachine>"
          "<TotalInstances>16</TotalInstances>"
          "<UsedInstances>2</UsedInstances>"
          "<UnavailableInstances>0</UnavailableInstances>"
          "<PhysicalCPUs>1</PhysicalCPUs>"
          "<LogicalCPUs>2</LogicalCPUs>"
          "<CPUMultiplicity>singlecpu-multicore</CPUMultiplicity>"
          "<CPUVendor>Intel</CPUVendor>"
          "<CPUModel>Intel(R) Core(TM)2 CPU E8500</CPUModel>"
          "<CPUVersion>2</CPUVersion>"
          "<CPUClockSpeed>3820</CPUClockSpeed>"
          "<CPUTimeScalingFactor>4.45</CPUTimeScalingFactor>"
          "<WallTimeScalingFactor>4.45</WallTimeScalingFactor>"
          "<MainMemorySize>2048</MainMemorySize>"
          "<VirtualMemorySize>10230</VirtualMemorySize>"
          "<OSFamily>linux</OSFamily>"
          "<OSName>gentoo</OSName>"
          "<OSVersion>2.6</OSVersion>"
          "<ConnectivityIn>false</ConnectivityIn>"
          "<ConnectivityOut>true</ConnectivityOut>"
          "<NetworkInfo>gigabitethernet</NetworkInfo>"
          "<Benchmark CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
            "<Name>jbench</Name>"
            "<OtherInfo>JVM options: -d64 -server</OtherInfo>"
            "<Type>jbench</Type>"
            "<Value>3299.0</Value>"
          "</Benchmark>"
        "</ExecutionEnvironment>"
      "</ExecutionEnvironments>"
      "<ApplicationEnvironments>"
        "<ApplicationEnvironment CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
          "<Name>JRE</Name>"
          "<AppName>ENV/JAVA/JRE</AppName>"
          "<AppVersion>1.4.2</AppVersion>"
          "<State>installedverified</State>"
          "<RemovalDate>2011-04-21T10:05:12Z</RemovalDate>"
          "<License>unknown</License>"
          "<Description>Sun JRE</Description>"
          "<BestBenchmark>jbench</BestBenchmark>"
          "<BestBenchmark>bogomips</BestBenchmark>"
          "<ParallelSupport>false</ParallelSupport>"
          "<MaxSlots>4</MaxSlots>"
          "<MaxJobs>4</MaxJobs>"
          "<MaxUserSeats>1</MaxUserSeats>"
          "<FreeSlots>4</FreeSlots>"
          "<FreeJobs>4</FreeJobs>"
          "<FreeUserSeats>1</FreeUserSeats>"
          "<ApplicationHandle>"
            "<Name>java module</Name>"
            "<OtherInfo>command: \"module load java-1.4.2\"</OtherInfo>"
            "<Type>module</Type>"
            "<Value>java-1.4.2</Value>"
          "</ApplicationHandle>"
          "<ApplicationHandle>"
            "<Name>java path</Name>"
            "<OtherInfo>Path to java install</OtherInfo>"
            "<Type>path</Type>"
            "<Value>/local/jre-1.4.2</Value>"
          "</ApplicationHandle>"
        "</ApplicationEnvironment>"
        "<ApplicationEnvironment CreationTime=\"2008-04-21T10:05:12Z\" Validity=\"500\">"
          "<Name>TEST-ATLAS</Name>"
          "<AppName>APPS/HEP/TEST-ATLAS</AppName>"
          "<AppVersion>13.0.20</AppVersion>"
          "<State>installednotverified</State>"
          "<License>opensource</License>"
          "<Description>Atlas offline software</Description>"
          "<BestBenchmark>specfp2000</BestBenchmark>"
          "<ParallelSupport>false</ParallelSupport>"
          "<MaxSlots>100</MaxSlots>"
          "<MaxJobs>100</MaxJobs>"
          "<MaxUserSeats>60</MaxUserSeats>"
          "<FreeSlots>4</FreeSlots>"
          "<FreeJobs>4</FreeJobs>"
          "<FreeUserSeats>1</FreeUserSeats>"
          "<ApplicationHandle>"
            "<Name>Atlas install location</Name>"
            "<Type>path</Type>"
            "<Value>/shared/Apps</Value>"
          "</ApplicationHandle>"
        "</ApplicationEnvironment>"
      "</ApplicationEnvironments>"
    "</ComputingManager>"
  "</ComputingService>"
  "</Response>");

  std::list<Arc::ExecutionTarget> targets;
  Arc::TargetRetrieverARC1::ExtractTargets(Arc::URL(), response, targets);

  testLogger.msg(Arc::DEBUG, "targets.size() = %d", targets.size());

  CPPUNIT_ASSERT_EQUAL(2, (int)targets.size());

  /*
   * FreeSlotsWithDuration. In the ExecutionTarget the FreeSlotsWithDuration is
   * stored as a std::map, which mean that the keys are sorted from lower to
   * higher key value, thus they are not stored in the order they are parsed.
   */
  CPPUNIT_ASSERT_EQUAL(2, (int)targets.front().FreeSlotsWithDuration.size());
  CPPUNIT_ASSERT_EQUAL(Arc::Period(3000), targets.front().FreeSlotsWithDuration.begin()->first);
  CPPUNIT_ASSERT_EQUAL(14, targets.front().FreeSlotsWithDuration.begin()->second);
  CPPUNIT_ASSERT_EQUAL(Arc::Period(12000), targets.front().FreeSlotsWithDuration.rbegin()->first);
  CPPUNIT_ASSERT_EQUAL(4, targets.front().FreeSlotsWithDuration.rbegin()->second);
  CPPUNIT_ASSERT_EQUAL(Arc::Period(2000), targets.back().FreeSlotsWithDuration.begin()->first);
  CPPUNIT_ASSERT_EQUAL(1, targets.back().FreeSlotsWithDuration.begin()->second);
  CPPUNIT_ASSERT_EQUAL(Arc::Period(LONG_MAX), targets.back().FreeSlotsWithDuration.rbegin()->first);
  CPPUNIT_ASSERT_EQUAL(7, targets.back().FreeSlotsWithDuration.rbegin()->second);


  CPPUNIT_ASSERT_EQUAL(true, targets.front().ConnectivityIn);
  CPPUNIT_ASSERT_EQUAL(false, targets.front().ConnectivityOut);
  CPPUNIT_ASSERT_EQUAL(false, targets.back().ConnectivityIn);
  CPPUNIT_ASSERT_EQUAL(true, targets.back().ConnectivityOut);
}
#endif

CPPUNIT_TEST_SUITE_REGISTRATION(TargetRetrieverARC1Test);
