/**
 * \defgroup topology Topology Input Readers
 *
 * \section topologyOverview Topology Input Readers Overview
 *
 * The topology modules aim at reading a topology file generated by an automatic topology generator.
 *
 * The process is divided in two steps:
 * - running a topology generator to build a topology file
 * - reading the topology file and build a ns-3 simulation
 *
 * Hence, model is focused on being able to read correctly the various topology formats.
 *
 * Currently there are three models:
 * - ns3::OrbisTopologyReader for Orbis 0.7 traces (http://sysnet.ucsd.edu/~pmahadevan/topo_research/topo.html)
 * - ns3::InetTopologyReader for Inet 3.0 traces (http://topology.eecs.umich.edu/inet/)
 * - ns3::RocketfuelTopologyReader for Rocketfuel traces (http://www.cs.washington.edu/research/networking/rocketfuel/)
 *
 * An helper ns3::TopologyReaderHelper is provided to assist on trivial tasks.
 *
 * A good source for topology data is also Archipelago (http://www.caida.org/projects/ark/)
 *
 * The current Archipelago Measurements, monthly updated, are stored here:
 * http://data.caida.org/datasets/topology/ipv4.allpref24-aslinks/
 * (complete notation and triple data source, one for each working group)
 *
 * A different and more compact notation that signs only the AS-relationships is here:
 * http://www.caida.org/data/active/as-relationships/index.xml
 * (a sort of more Orbis-like format)
 *
 * The compact notation can be easily stripped down to a pure Orbis format, just removing
 * the double relationships (the compact format use one-way links, while Orbis use two-way
 * links) and pruning the 3rd parameter. Note that with the compact data Orbis can then be
 * used create a rescaled version of the topology, thus being the most effective way
 * (to my best knowledge) to make an internet-like topology.
 *
 * Examples can be found in the directory src/topology-read/examples/
 */
