/* NVTV NVidia internal encoder data header
 *
 * Author: Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: data_nx.h,v 1.2 2003/06/27 16:02:01 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Data tables and setup routines for the NVidia internal
 * encoder chip.  
 */

#ifndef _DATA_NX_H
#define _DATA_NX_H

#include "tv_chip.h"
#include "data.h"

void data_init_nx (TVSystem system, TVNxRegs *r);
void data_default_nx (TVSettings *s);
void data_clamp_nx (TVSettings *s, TVRegs *r);
void data_setup_nx (TVSettings *s, TVRegs *r);
void data_complete_nx (TVRegs *r);

extern TVNxImgRegs nx_50_normal_a;
extern TVNxImgRegs nx_50_normal_b;
extern TVNxImgRegs nx_50_normal_c;

extern TVNxImgRegs nx_60_normal_a;
extern TVNxImgRegs nx_60_normal_b;
extern TVNxImgRegs nx_60_normal_c;

#endif /* _DATA_NX_H */
