// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Graphic2d_ImageFile_HeaderFile
#define _Graphic2d_ImageFile_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Graphic2d_ImageFile_HeaderFile
#include <Handle_Graphic2d_ImageFile.hxx>
#endif

#ifndef _OSD_File_HeaderFile
#include <OSD_File.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_CardinalPoints_HeaderFile
#include <Aspect_CardinalPoints.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Graphic2d_Primitive_HeaderFile
#include <Graphic2d_Primitive.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
class Graphic2d_ImageDefinitionError;
class Graphic2d_GraphicObject;
class OSD_File;
class Graphic2d_Drawer;


//! The primitive ImageFile <br>
class Graphic2d_ImageFile : public Graphic2d_Primitive {

public:

  //! Defines an image with its center location; <br>
//!	    <X>, <Y> defines the position in the space model. <br>
//!	    <adx>, <ady> defines an offset in the device space. <br>
//!	    <ascale> defines a scale factor applied to the <br>
//!	    original size of the image. <br>
//!	    The image will be placed at this offset <br>
//!	    according to the type of placement. <br>
  Standard_EXPORT   Graphic2d_ImageFile(const Handle(Graphic2d_GraphicObject)& aGraphicObject,OSD_File& aFile,const Quantity_Length X,const Quantity_Length Y,const Quantity_Length adx = 0.0,const Quantity_Length ady = 0.0,const Aspect_CardinalPoints aTypeOfPlacement = Aspect_CP_Center,const Quantity_Factor aScale = 1.0);
  //! Modifies the center location of the image <me>. <br>
  Standard_EXPORT     void SetCenter(const Quantity_Length X,const Quantity_Length Y) ;
  //! Modifies the offset of the image <me>. <br>
  Standard_EXPORT     void SetOffset(const Quantity_Length dx,const Quantity_Length dy) ;
  //! Modifies the type of placement of the image <me>. <br>
  Standard_EXPORT     void SetPlacement(const Aspect_CardinalPoints aPlacement) ;
  //! Modifies the center location of the image <me> <br>
//!          by translating it. <br>
  Standard_EXPORT     void Translate(const Quantity_Length DX,const Quantity_Length DY) ;
  //! Changes the scale factor of the image. <br>
  Standard_EXPORT     void SetScale(const Quantity_Factor aScale) ;
  //! The image <me> follows the scale factor of the view <br>
//!	    if the flag is Standard_True. <br>
  Standard_EXPORT     void SetZoomable(const Standard_Boolean aFlag = Standard_False) ;
  //! Clear the reference to this imagefile if something <br>
//!         inside have changed,Forced the reload of this at Draw() <br>
//!         time. <br>
  Standard_EXPORT     void Clear() ;
  //! Returns the original scale factor applied to <br>
//!	    the image <me>. <br>
  Standard_EXPORT     Quantity_Factor Scale() const;
  //! Returns Standard_True if the image <me> follows <br>
//!	    the scale factor of the view. <br>
  Standard_EXPORT     Standard_Boolean IsZoomable() const;
  //! returns the position in the space model <br>
  Standard_EXPORT     void Position(Quantity_Length& X,Quantity_Length& Y) const;
  //! returns the offset in the device space <br>
  Standard_EXPORT     void Offset(Quantity_Length& aX,Quantity_Length& aY) const;
  //! returns the type of placement <br>
  Standard_EXPORT     Aspect_CardinalPoints Placement() const;
  //! returns the image file <br>
  Standard_EXPORT     OSD_File ImageFile() const;
  //! Returns Standard_True, the Image pixel size <br>
//!	    and the Image planes depth, if the image file : <br>
//!		- is not open <br>
//!		- exists <br>
//!		- have the extension .xwd <br>
//!	    NOTE that only XWD image file type are recognized. <br>
  Standard_EXPORT   static  Standard_Boolean Values(OSD_File& aFile,Standard_Integer& aWidth,Standard_Integer& aHeight,Standard_Integer& aDepth) ;
  //! Swaps long ints <br>
  Standard_EXPORT   static  void SwapLong(const Standard_Address anAddress,const Standard_Integer aNumOfBytes) ;
  
  Standard_EXPORT   virtual  void Save(Aspect_FStream& aFStream) const;




  DEFINE_STANDARD_RTTI(Graphic2d_ImageFile)

protected:

  //! Draws the image at the required center location <br>
//!	    defined by the SetCenter method. <br>
  Standard_EXPORT     void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;
  //! Returns Standard_True if the image <me> is picked, <br>
//!          Standard_False if not. <br>
  Standard_EXPORT     Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;



private: 

  //! Evaluates the center of the image in the device space. <br>
//!	    Called by the methods : <br>
//!		- Graphic2d_ImageFile::Draw <br>
//!		- Graphic2d_ImageFile::Pick <br>
//!		- Graphic2d_ImageFile::FillAndDraw <br>
  Standard_EXPORT     Standard_Boolean ComputeCenterAndSize(const Handle(Graphic2d_Drawer)& aDrawer,Standard_ShortReal& cx,Standard_ShortReal& cy,Standard_ShortReal& width,Standard_ShortReal& height) ;

OSD_File myFile;
TCollection_AsciiString myFileName;
Standard_ShortReal myX;
Standard_ShortReal myY;
Standard_ShortReal mydx;
Standard_ShortReal mydy;
Standard_Integer myWidth;
Standard_Integer myHeight;
Aspect_CardinalPoints myPlacement;
Standard_Boolean myIsZoomable;
Standard_ShortReal myScale;
Standard_Boolean myIsModified;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
