/*
  $Date: 1999/10/15 12:40:27 $
  $Revision: 1.1.1.1 $
  $Author: kise $
  output.c
*/

#include <stdio.h>
#include <math.h>
#include "const.h"
#include "defs.h"
#include "extern.h"
#include "function.h"


namespace voronoi{
    /* float pxmin, pxmax, pymin, pymax, cradius; */

    /*
     * (x,y)κɸȳǤ, κɸѴؿ
     * ܥΥ(x,y)ֹFRAME(-1)ˤ.
     */
    void in_frame(float *x, float *y, float d,
                  struct Edge *e, int lr,
                  Coordinate max_x, Coordinate max_y)
    {
        /* x κɸ0 ʲξ */
        if(*x < 0){
            *y += (-*x)*d;
            *x = 0;
            e->ep[lr]->sitenbr = FRAME;
            if(*y < 0){
                *x += (-*y)/d;
                *y = 0;
            }
            else if(*y > max_y){
                *x += ((float)max_y - *y)/d;
                *y = (float)max_y;
            }
        }
        /* x κɸmax_x ʾξ */
        else if(*x > max_x){
            *y += ((float)max_x - *x)*d;
            *x = (float)max_x;
            e->ep[lr]->sitenbr = FRAME;
            if(*y < 0){
                *x += (-*y)/d;
                *y = 0;
            }
            else if(*y > max_y){
                *x += ((float)max_y - *y)/d;
                *y = (float)max_y;
            }
        }
        /* y κɸ0 ʲξ */
        else if(*y < 0){
            *x += (-*y)/d;
            *y = 0;
            e->ep[lr]->sitenbr = FRAME;
        }
        /* y κɸmax_y ʾξ */
        else if(*y > max_y){
            *x += ((float)max_y - *y)/d;
            *y = (float)max_y;
            e->ep[lr]->sitenbr = FRAME;
        }
    }

    /* ̵±ǤκɸѴؿ */
    void s_in_frame(float *xsf, float *xef, float *ysf, float *yef,
                    struct Edge *e, Coordinate max_y)
    {
        float d;
    
        if((e->b) == 0) {	/* ξ */
            *xsf = *xef;
            *ysf = (float)max_y;
        }
        else {
            d = -(e->a)/(e->b); /*  */
	    
            if(d == 0){	/* 0 ξ */
                *xsf = 0;
                *ysf = *yef;
            }
            else if(d > 0){	/* ξ */
                if(*yef > *xef*d){
                    *xsf = 0;
                    *ysf = *yef - (*xef*d);
                }
                else {
                    *xsf = *xef - (*yef/d);
                    *ysf = 0;
                }
            }
            else {		/* ξ */
                if(((float)max_y - *yef) > ((-*xef) * d)){
                    *xsf = 0;
                    *ysf = *yef + ((-*xef) * d);
                }
                else {
                    *xsf = *xef - (-((float)max_y - *yef)) / d;
                    *ysf = (float)max_y;
                }
            }
        }
    }

    /* ̵±Ǥ뽪κɸѴؿ */
    void e_in_frame(float *xsf, float *xef, float *ysf, float *yef,
                    struct Edge *e, Coordinate max_x, Coordinate max_y)
    {
        float d;

        if((e->b) ==0) {	/* ξ */
            *xef = *xsf;
            *yef = 0;
        }
        else {
            d = -(e->a)/(e->b); /*  */

            if(d == 0){	/* 0 ξ */
                *xef = (float)max_x;
                *yef = *ysf;
            }
            else if(d > 0){	/* ξ */
                if(((float)max_y - *ysf) > (((float)max_x - *xsf) * d)){
                    *xef = (float)max_x;
                    *yef = *ysf + ((float)max_x - *xsf) * d;
                }
                else {
                    *xef = *xsf + ((float)max_y - *ysf) / d;
                    *yef = (float)max_y;
                }
            }
            else {		/* ξ */
                if(*ysf > (- ((float)max_x - *xsf) * d)){
                    *xef = (float)max_x;
                    *yef = *ysf - (- ((float)max_x - *xsf) * d);
                }
                else {
                    *xef = *xsf + (-*ysf) / d;
                    *yef =0;
                }
            }
        }
    }

    /*
     * , κɸ̵±, ޤ, ȳξ,
     * ɸ, ΥܥΥֹFRAME(-1) ˤؿ
     */
    void frameout(float *xsf, float *xef, float *ysf, float *yef,
                  int *sp, int *ep, struct Edge *e,
                  Coordinate max_x, Coordinate max_y)
    {
        float d;

        /* , Ȥ̵±Ǥʤ */
        if((e->ep[LE] != (struct Site *)NULL) &&
           (e->ep[RE] != (struct Site *)NULL)){
            *xsf = e->ep[LE]->coord.x; /* x ɸ */
            *xef = e->ep[RE]->coord.x; /* x ɸ */
            *ysf = e->ep[LE]->coord.y; /* y ɸ */
            *yef = e->ep[RE]->coord.y; /* y ɸ */

            /*  ΤȤ */
            if(*xsf == *xef) {
                if(*ysf < 0) {
                    *ysf =0;
                    e->ep[LE]->sitenbr = FRAME;
                }
                else if(*ysf > max_y) {
                    *ysf = (float)max_y;
                    e->ep[LE]->sitenbr = FRAME;
                }
                if(*yef < 0) {
                    *yef = 0;
                    e->ep[RE]->sitenbr = FRAME;
                }
                else if(*yef > max_y) {
                    *yef = (float)max_y;
                    e->ep[RE]->sitenbr = FRAME;
                }
            }

            /* ͭ¤ΤȤ */
            else {
                d = (*yef - *ysf)/(*xef - *xsf); /*  */

                /* ȳξ */
                in_frame(xsf,ysf,d,e,LE,max_x,max_y);
                /* ȳξ */	    
                in_frame(xef,yef,d,e,RE,max_x,max_y);
            }
	
            *sp = e->ep[LE]->sitenbr; /* ֹ */
            *ep = e->ep[RE]->sitenbr; /* ֹ */
	
        }
    
        /* ̵±ξ */
        else if((e->ep[LE] == (struct Site *)NULL)) {
            *xef = e->ep[RE]->coord.x; /* x ɸ */
            *yef = e->ep[RE]->coord.y; /* y ɸ */
            *sp = FRAME;	/* ֹFRAME  */
            *ep = e->ep[RE]->sitenbr; /* ֹ */

            /* ˤ */
            s_in_frame(xsf,xef,ysf,yef,e,max_y);
        }
        
        /* ̵±ξ */
        else if((e->ep[RE] == (struct Site *)NULL)){
            *xsf = e->ep[LE]->coord.x; /* x ɸ */
            *ysf = e->ep[LE]->coord.y; /* y ɸ */
            *sp = e->ep[LE]->sitenbr; /* ֹ */
            *ep = FRAME;	/* ֹFRAME  */

            /* ˤ */
            e_in_frame(xsf,xef,ysf,yef,e,max_x,max_y);
        }
    }

    /*
     * Ϣʬ֤ΥܥΥդΤߤlineseg ˳Ǽ,
     * Ϣʬ֤δطneighbor Ĥؿ.
     */
    void out_ep2(struct Edge *e, struct Site *v,
                 Coordinate imax, Coordinate jmax)
    {
        int i,sp,ep;
        float xsf,xef,ysf,yef;
        //  float si,sj,ei,ej;
        Coordinate max_x=imax-1;
        Coordinate max_y=jmax-1;

        static unsigned int current_neighbor_size = INITNEIGHBOR;
        static unsigned int current_lineseg_size  = INITLINE;

        /* double i1,j1,i2,j2; */



        /* ٥뤬ƱϽϤʤ */
        if(output_pvor == NO && e->lab1 == e->lab2) {
            point_edge++;
            return;
        }
        else {
            /*
             * ܥΥ̵±, ޤ, ȳɤȽꤷ,
             * ⤷, ʤκɸ˽
             */
            frameout(&xsf,&xef,&ysf,&yef,&sp,&ep,e,imax-1,jmax-1);
	
            /* νˤäƤ, ΰȳξϤʤ */
            if((xsf < 0.0) || (xsf > (float)max_x) ||
               (xef < 0.0) || (xef > (float)max_x) ||
               (ysf < 0.0) || (ysf > (float)max_y) ||
               (yef < 0.0) || (yef > (float)max_y))
                return;
        }

        // ꥸʥȰ㤦Ȥ
        // ٥ȥȤƤߤ
        //
        //  if((e->ep[LE] != (struct Site *)NULL) &&
        //     (e->ep[RE] != (struct Site *)NULL)){
        //    /* ܥΥդλȤ̵±Ǥʤ */
        //		
        //    si = e->ep[LE]->coord.x; /* x ɸ */
        //    ei = e->ep[RE]->coord.x; /* x ɸ */
        //    sj = e->ep[LE]->coord.y; /* y ɸ */
        //    ej = e->ep[RE]->coord.y; /* y ɸ */
        //		
        //    if(!((si < (float)imax)&&(ei < (float)imax)&&
        //	 (sj < (float)jmax)&&(ej < (float)jmax)
        //	 &&(si > 0)&&(ei > 0)&&(sj > 0)&&(ej > 0))){
        //      /* ⤷Ȥ˲ˤä */
        //      return;
        //      /* neighbor ΥåȤԤʤ */
        //    }
        //  }
        //  else{
        //    /* ܥΥդλΤɤ餫̵±Ǥ */
        //    return;
        //    /* neighbor ΥåȤԤʤ */
        //  }
	
        /*
         * Ϣʬܴطneighbor ˴ϿƤ,
         * ϿƤΥ, ΥܥΥդ֤
         * Υ礭Ӥ,Ϣʬ֤εΥ
         */

        i = search(e->lab1,e->lab2); /* ϥåɽϿƤ뤫Ĵ٤ */

        /* ̤Ͽξ */

        if(i == NODATA){
            enter(e->lab1,e->lab2,NEIGHnbr); /* ϥåɽϿ */
            /*
              i1 = (double)(component[e->lab1].xc);
              j1 = (double)(component[e->lab1].yc);
              i2 = (double)(component[e->lab2].xc);
              j2 = (double)(component[e->lab2].yc);
            */

            /* ֤εΥ */
            neighbor[NEIGHnbr].dist = e->dist; /* Ϣʬ֤κǾΥ */
            neighbor[NEIGHnbr].lab1 = e->lab1;
            neighbor[NEIGHnbr].lab2 = e->lab2;
	
            /* ſ֤γ٤ */
            /*	if(i1 == i2) {
                neighbor[NEIGHnbr].angle = -RIGHTANGLE;
                }
                else {
                angle = atan2((j2-j1),(i2-i1))*2*RIGHTANGLE/M_PI;
			
                if(angle > RIGHTANGLE){
                neighbor[NEIGHnbr].angle = (float)(angle-2*RIGHTANGLE);
                }
                else if(angle <= -RIGHTANGLE){
                neighbor[NEIGHnbr].angle = (float)(angle+2*RIGHTANGLE);
                }
                else {
                neighbor[NEIGHnbr].angle = (float)angle;
                }
                }
            */
            /*	neighbor[NEIGHnbr].dist = 
                (float)sqrt((component[e->lab1].xc - component[e->lab2].xc) *
                (component[e->lab1].xc - component[e->lab2].xc) +
                (component[e->lab1].yc - component[e->lab2].yc) *
                (component[e->lab1].yc - component[e->lab2].yc));*/
            /* Ϣʬνſ֤εΥ */
            /*	dx = (double)(component[e->lab2].xc - component[e->lab1].xc);
                dy = (double)(component[e->lab2].yc - component[e->lab1].yc);
                neighbor[NEIGHnbr].angle = (float)atan2(dy,dx);*/
	
            NEIGHnbr++;
            if(NEIGHnbr >= current_neighbor_size) {
                neighbor=(Neighborhood *)myrealloc(neighbor,
                                                   current_neighbor_size,
                                                   INCNEIGHBOR,
                                                   sizeof(Neighborhood));
                current_neighbor_size+=INCNEIGHBOR;
            }
        }

        /* ϿѤߤξ */
        else {
            if(neighbor[i].dist > e->dist) /* ΥӤûϢ */
                neighbor[i].dist = e->dist; /* ʬ֤εΥȤ */
        }

        if(sp > SiteMax) SiteMax = sp;
        if(ep > SiteMax) SiteMax = ep;

        /* ܥΥդξǼ */
        lineseg[LINEnbr].sp = sp;
        lineseg[LINEnbr].ep = ep;
        lineseg[LINEnbr].xs = (unsigned int)(xsf+0.5);
        lineseg[LINEnbr].xe = (unsigned int)(xef+0.5);
        lineseg[LINEnbr].ys = (unsigned int)(ysf+0.5);
        lineseg[LINEnbr].ye = (unsigned int)(yef+0.5);
        lineseg[LINEnbr].lab1 = e->lab1;
        lineseg[LINEnbr].lab2 = e->lab2;
        lineseg[LINEnbr].yn = OUTPUT;
        LINEnbr++;
        point_edge++;
        if(LINEnbr >= current_lineseg_size) {
            lineseg=(LineSegment *)myrealloc(lineseg,
                                             current_lineseg_size,
                                             INCLINE,
                                             sizeof(LineSegment));
            current_lineseg_size+=INCLINE;
        }
    }
}
